<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyPointsPaymentItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoyaltyPointsPaymentItem
 * @subpackage Structs
 */
class LoyaltyPointsPaymentItem extends AbstractPaymentItem
{
    /**
     * The Points
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSpendingPointsByClient
     */
    public $Points;
    /**
     * The UnsynchedRefund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UnsynchedRefund;
    /**
     * Constructor method for LoyaltyPointsPaymentItem
     * @uses LoyaltyPointsPaymentItem::setPoints()
     * @uses LoyaltyPointsPaymentItem::setUnsynchedRefund()
     * @param \patest\ArrayType\ArrayOfSpendingPointsByClient $points
     * @param bool $unsynchedRefund
     */
    public function __construct(\patest\ArrayType\ArrayOfSpendingPointsByClient $points = null, $unsynchedRefund = null)
    {
        $this
            ->setPoints($points)
            ->setUnsynchedRefund($unsynchedRefund);
    }
    /**
     * Get Points value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSpendingPointsByClient|null
     */
    public function getPoints()
    {
        return isset($this->Points) ? $this->Points : null;
    }
    /**
     * Set Points value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSpendingPointsByClient $points
     * @return \patest\StructType\LoyaltyPointsPaymentItem
     */
    public function setPoints(\patest\ArrayType\ArrayOfSpendingPointsByClient $points = null)
    {
        if (is_null($points) || (is_array($points) && empty($points))) {
            unset($this->Points);
        } else {
            $this->Points = $points;
        }
        return $this;
    }
    /**
     * Get UnsynchedRefund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUnsynchedRefund()
    {
        return isset($this->UnsynchedRefund) ? $this->UnsynchedRefund : null;
    }
    /**
     * Set UnsynchedRefund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $unsynchedRefund
     * @return \patest\StructType\LoyaltyPointsPaymentItem
     */
    public function setUnsynchedRefund($unsynchedRefund = null)
    {
        // validation for constraint: boolean
        if (!is_null($unsynchedRefund) && !is_bool($unsynchedRefund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unsynchedRefund, true), gettype($unsynchedRefund)), __LINE__);
        }
        if (is_null($unsynchedRefund) || (is_array($unsynchedRefund) && empty($unsynchedRefund))) {
            unset($this->UnsynchedRefund);
        } else {
            $this->UnsynchedRefund = $unsynchedRefund;
        }
        return $this;
    }
}
