<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LookupExternalAuthenticationData-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LookupExternalAuthenticationData-Request
 * @subpackage Structs
 */
class LookupExternalAuthenticationData_Request extends ExtensibleDataContract
{
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The ExternalService
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalService;
    /**
     * The UserType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserType;
    /**
     * Constructor method for LookupExternalAuthenticationData-Request
     * @uses LookupExternalAuthenticationData_Request::setExternalId()
     * @uses LookupExternalAuthenticationData_Request::setExternalService()
     * @uses LookupExternalAuthenticationData_Request::setUserType()
     * @param string $externalId
     * @param string $externalService
     * @param string $userType
     */
    public function __construct($externalId = null, $externalService = null, $userType = null)
    {
        $this
            ->setExternalId($externalId)
            ->setExternalService($externalService)
            ->setUserType($userType);
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \patest\StructType\LookupExternalAuthenticationData_Request
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get ExternalService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalService()
    {
        return isset($this->ExternalService) ? $this->ExternalService : null;
    }
    /**
     * Set ExternalService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalService
     * @return \patest\StructType\LookupExternalAuthenticationData_Request
     */
    public function setExternalService($externalService = null)
    {
        // validation for constraint: string
        if (!is_null($externalService) && !is_string($externalService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalService, true), gettype($externalService)), __LINE__);
        }
        if (is_null($externalService) || (is_array($externalService) && empty($externalService))) {
            unset($this->ExternalService);
        } else {
            $this->ExternalService = $externalService;
        }
        return $this;
    }
    /**
     * Get UserType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserType()
    {
        return isset($this->UserType) ? $this->UserType : null;
    }
    /**
     * Set UserType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userType
     * @return \patest\StructType\LookupExternalAuthenticationData_Request
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: string
        if (!is_null($userType) && !is_string($userType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userType, true), gettype($userType)), __LINE__);
        }
        if (is_null($userType) || (is_array($userType) && empty($userType))) {
            unset($this->UserType);
        } else {
            $this->UserType = $userType;
        }
        return $this;
    }
}
