<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginClient-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoginClient-Request
 * @subpackage Structs
 */
class LoginClient_Request extends AbstractStructBase
{
    /**
     * The IsGetClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsGetClientTypes;
    /**
     * The LoginName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * Constructor method for LoginClient-Request
     * @uses LoginClient_Request::setIsGetClientTypes()
     * @uses LoginClient_Request::setLoginName()
     * @uses LoginClient_Request::setPassword()
     * @uses LoginClient_Request::setClientId()
     * @param bool $isGetClientTypes
     * @param string $loginName
     * @param string $password
     * @param string $clientId
     */
    public function __construct($isGetClientTypes = null, $loginName = null, $password = null, $clientId = null)
    {
        $this
            ->setIsGetClientTypes($isGetClientTypes)
            ->setLoginName($loginName)
            ->setPassword($password)
            ->setClientId($clientId);
    }
    /**
     * Get IsGetClientTypes value
     * @return bool|null
     */
    public function getIsGetClientTypes()
    {
        return $this->IsGetClientTypes;
    }
    /**
     * Set IsGetClientTypes value
     * @param bool $isGetClientTypes
     * @return \patest\StructType\LoginClient_Request
     */
    public function setIsGetClientTypes($isGetClientTypes = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGetClientTypes) && !is_bool($isGetClientTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGetClientTypes, true), gettype($isGetClientTypes)), __LINE__);
        }
        $this->IsGetClientTypes = $isGetClientTypes;
        return $this;
    }
    /**
     * Get LoginName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginName()
    {
        return isset($this->LoginName) ? $this->LoginName : null;
    }
    /**
     * Set LoginName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginName
     * @return \patest\StructType\LoginClient_Request
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        if (is_null($loginName) || (is_array($loginName) && empty($loginName))) {
            unset($this->LoginName);
        } else {
            $this->LoginName = $loginName;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \patest\StructType\LoginClient_Request
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\LoginClient_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
}
