<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LiabilityStatusInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LiabilityStatusInfo
 * @subpackage Structs
 */
class LiabilityStatusInfo extends AbstractStructBase
{
    /**
     * The IsSellable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSellable;
    /**
     * The LiabilityStatusId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LiabilityStatusId;
    /**
     * Constructor method for LiabilityStatusInfo
     * @uses LiabilityStatusInfo::setIsSellable()
     * @uses LiabilityStatusInfo::setLiabilityStatusId()
     * @param bool $isSellable
     * @param string $liabilityStatusId
     */
    public function __construct($isSellable = null, $liabilityStatusId = null)
    {
        $this
            ->setIsSellable($isSellable)
            ->setLiabilityStatusId($liabilityStatusId);
    }
    /**
     * Get IsSellable value
     * @return bool|null
     */
    public function getIsSellable()
    {
        return $this->IsSellable;
    }
    /**
     * Set IsSellable value
     * @param bool $isSellable
     * @return \patest\StructType\LiabilityStatusInfo
     */
    public function setIsSellable($isSellable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSellable) && !is_bool($isSellable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSellable, true), gettype($isSellable)), __LINE__);
        }
        $this->IsSellable = $isSellable;
        return $this;
    }
    /**
     * Get LiabilityStatusId value
     * @return string|null
     */
    public function getLiabilityStatusId()
    {
        return $this->LiabilityStatusId;
    }
    /**
     * Set LiabilityStatusId value
     * @param string $liabilityStatusId
     * @return \patest\StructType\LiabilityStatusInfo
     */
    public function setLiabilityStatusId($liabilityStatusId = null)
    {
        // validation for constraint: string
        if (!is_null($liabilityStatusId) && !is_string($liabilityStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($liabilityStatusId, true), gettype($liabilityStatusId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($liabilityStatusId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $liabilityStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($liabilityStatusId, true)), __LINE__);
        }
        $this->LiabilityStatusId = $liabilityStatusId;
        return $this;
    }
}
