<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LiabilityItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LiabilityItem
 * @subpackage Structs
 */
class LiabilityItem extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_AbstractItemDetails
     */
    public $Details;
    /**
     * The DueAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $DueAmount;
    /**
     * The FullAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $FullAmount;
    /**
     * The IdInTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdInTransaction;
    /**
     * The IsReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsReservation;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemType;
    /**
     * The NewItemIdOfReservation
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewItemIdOfReservation;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $PaidAmount;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * The SellDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SellDate;
    /**
     * The SellItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SellItemId;
    /**
     * The ServiceSpecificId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServiceSpecificId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransactionNumber;
    /**
     * The RefundPaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $RefundPaidAmount;
    /**
     * The RefundLiability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $RefundLiability;
    /**
     * The FacePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $FacePrice;
    /**
     * The CommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $CommissionAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TaxAmount;
    /**
     * The ListPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $ListPrice;
    /**
     * Constructor method for LiabilityItem
     * @uses LiabilityItem::setClientId()
     * @uses LiabilityItem::setDetails()
     * @uses LiabilityItem::setDueAmount()
     * @uses LiabilityItem::setFullAmount()
     * @uses LiabilityItem::setIdInTransaction()
     * @uses LiabilityItem::setIsReservation()
     * @uses LiabilityItem::setItemType()
     * @uses LiabilityItem::setNewItemIdOfReservation()
     * @uses LiabilityItem::setPaidAmount()
     * @uses LiabilityItem::setProductId()
     * @uses LiabilityItem::setSellDate()
     * @uses LiabilityItem::setSellItemId()
     * @uses LiabilityItem::setServiceSpecificId()
     * @uses LiabilityItem::setTransactionGuid()
     * @uses LiabilityItem::setTransactionNumber()
     * @uses LiabilityItem::setRefundPaidAmount()
     * @uses LiabilityItem::setRefundLiability()
     * @uses LiabilityItem::setFacePrice()
     * @uses LiabilityItem::setCommissionAmount()
     * @uses LiabilityItem::setTaxAmount()
     * @uses LiabilityItem::setListPrice()
     * @param string $clientId
     * @param \patest\StructType\Sales_AbstractItemDetails $details
     * @param \patest\StructType\Money $dueAmount
     * @param \patest\StructType\Money $fullAmount
     * @param int $idInTransaction
     * @param bool $isReservation
     * @param int $itemType
     * @param string $newItemIdOfReservation
     * @param \patest\StructType\Money $paidAmount
     * @param string $productId
     * @param string $sellDate
     * @param string $sellItemId
     * @param string $serviceSpecificId
     * @param string $transactionGuid
     * @param int $transactionNumber
     * @param \patest\StructType\Money $refundPaidAmount
     * @param \patest\StructType\Money $refundLiability
     * @param \patest\StructType\Money $facePrice
     * @param \patest\StructType\Money $commissionAmount
     * @param \patest\StructType\Money $taxAmount
     * @param \patest\StructType\Money $listPrice
     */
    public function __construct($clientId = null, \patest\StructType\Sales_AbstractItemDetails $details = null, \patest\StructType\Money $dueAmount = null, \patest\StructType\Money $fullAmount = null, $idInTransaction = null, $isReservation = null, $itemType = null, $newItemIdOfReservation = null, \patest\StructType\Money $paidAmount = null, $productId = null, $sellDate = null, $sellItemId = null, $serviceSpecificId = null, $transactionGuid = null, $transactionNumber = null, \patest\StructType\Money $refundPaidAmount = null, \patest\StructType\Money $refundLiability = null, \patest\StructType\Money $facePrice = null, \patest\StructType\Money $commissionAmount = null, \patest\StructType\Money $taxAmount = null, \patest\StructType\Money $listPrice = null)
    {
        $this
            ->setClientId($clientId)
            ->setDetails($details)
            ->setDueAmount($dueAmount)
            ->setFullAmount($fullAmount)
            ->setIdInTransaction($idInTransaction)
            ->setIsReservation($isReservation)
            ->setItemType($itemType)
            ->setNewItemIdOfReservation($newItemIdOfReservation)
            ->setPaidAmount($paidAmount)
            ->setProductId($productId)
            ->setSellDate($sellDate)
            ->setSellItemId($sellItemId)
            ->setServiceSpecificId($serviceSpecificId)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber)
            ->setRefundPaidAmount($refundPaidAmount)
            ->setRefundLiability($refundLiability)
            ->setFacePrice($facePrice)
            ->setCommissionAmount($commissionAmount)
            ->setTaxAmount($taxAmount)
            ->setListPrice($listPrice);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\LiabilityItem
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_AbstractItemDetails|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_AbstractItemDetails $details
     * @return \patest\StructType\LiabilityItem
     */
    public function setDetails(\patest\StructType\Sales_AbstractItemDetails $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get DueAmount value
     * @return \patest\StructType\Money|null
     */
    public function getDueAmount()
    {
        return $this->DueAmount;
    }
    /**
     * Set DueAmount value
     * @param \patest\StructType\Money $dueAmount
     * @return \patest\StructType\LiabilityItem
     */
    public function setDueAmount(\patest\StructType\Money $dueAmount = null)
    {
        $this->DueAmount = $dueAmount;
        return $this;
    }
    /**
     * Get FullAmount value
     * @return \patest\StructType\Money|null
     */
    public function getFullAmount()
    {
        return $this->FullAmount;
    }
    /**
     * Set FullAmount value
     * @param \patest\StructType\Money $fullAmount
     * @return \patest\StructType\LiabilityItem
     */
    public function setFullAmount(\patest\StructType\Money $fullAmount = null)
    {
        $this->FullAmount = $fullAmount;
        return $this;
    }
    /**
     * Get IdInTransaction value
     * @return int|null
     */
    public function getIdInTransaction()
    {
        return $this->IdInTransaction;
    }
    /**
     * Set IdInTransaction value
     * @param int $idInTransaction
     * @return \patest\StructType\LiabilityItem
     */
    public function setIdInTransaction($idInTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInTransaction) && !(is_int($idInTransaction) || ctype_digit($idInTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInTransaction, true), gettype($idInTransaction)), __LINE__);
        }
        $this->IdInTransaction = $idInTransaction;
        return $this;
    }
    /**
     * Get IsReservation value
     * @return bool|null
     */
    public function getIsReservation()
    {
        return $this->IsReservation;
    }
    /**
     * Set IsReservation value
     * @param bool $isReservation
     * @return \patest\StructType\LiabilityItem
     */
    public function setIsReservation($isReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReservation) && !is_bool($isReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReservation, true), gettype($isReservation)), __LINE__);
        }
        $this->IsReservation = $isReservation;
        return $this;
    }
    /**
     * Get ItemType value
     * @return int|null
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * Set ItemType value
     * @param int $itemType
     * @return \patest\StructType\LiabilityItem
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        $this->ItemType = $itemType;
        return $this;
    }
    /**
     * Get NewItemIdOfReservation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewItemIdOfReservation()
    {
        return isset($this->NewItemIdOfReservation) ? $this->NewItemIdOfReservation : null;
    }
    /**
     * Set NewItemIdOfReservation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newItemIdOfReservation
     * @return \patest\StructType\LiabilityItem
     */
    public function setNewItemIdOfReservation($newItemIdOfReservation = null)
    {
        // validation for constraint: string
        if (!is_null($newItemIdOfReservation) && !is_string($newItemIdOfReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newItemIdOfReservation, true), gettype($newItemIdOfReservation)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newItemIdOfReservation) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newItemIdOfReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newItemIdOfReservation, true)), __LINE__);
        }
        if (is_null($newItemIdOfReservation) || (is_array($newItemIdOfReservation) && empty($newItemIdOfReservation))) {
            unset($this->NewItemIdOfReservation);
        } else {
            $this->NewItemIdOfReservation = $newItemIdOfReservation;
        }
        return $this;
    }
    /**
     * Get PaidAmount value
     * @return \patest\StructType\Money|null
     */
    public function getPaidAmount()
    {
        return $this->PaidAmount;
    }
    /**
     * Set PaidAmount value
     * @param \patest\StructType\Money $paidAmount
     * @return \patest\StructType\LiabilityItem
     */
    public function setPaidAmount(\patest\StructType\Money $paidAmount = null)
    {
        $this->PaidAmount = $paidAmount;
        return $this;
    }
    /**
     * Get ProductId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param string $productId
     * @return \patest\StructType\LiabilityItem
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get SellDate value
     * @return string|null
     */
    public function getSellDate()
    {
        return $this->SellDate;
    }
    /**
     * Set SellDate value
     * @param string $sellDate
     * @return \patest\StructType\LiabilityItem
     */
    public function setSellDate($sellDate = null)
    {
        // validation for constraint: string
        if (!is_null($sellDate) && !is_string($sellDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellDate, true), gettype($sellDate)), __LINE__);
        }
        $this->SellDate = $sellDate;
        return $this;
    }
    /**
     * Get SellItemId value
     * @return string|null
     */
    public function getSellItemId()
    {
        return $this->SellItemId;
    }
    /**
     * Set SellItemId value
     * @param string $sellItemId
     * @return \patest\StructType\LiabilityItem
     */
    public function setSellItemId($sellItemId = null)
    {
        // validation for constraint: string
        if (!is_null($sellItemId) && !is_string($sellItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellItemId, true), gettype($sellItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sellItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sellItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sellItemId, true)), __LINE__);
        }
        $this->SellItemId = $sellItemId;
        return $this;
    }
    /**
     * Get ServiceSpecificId value
     * @return string|null
     */
    public function getServiceSpecificId()
    {
        return $this->ServiceSpecificId;
    }
    /**
     * Set ServiceSpecificId value
     * @param string $serviceSpecificId
     * @return \patest\StructType\LiabilityItem
     */
    public function setServiceSpecificId($serviceSpecificId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceSpecificId) && !is_string($serviceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceSpecificId, true), gettype($serviceSpecificId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($serviceSpecificId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $serviceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($serviceSpecificId, true)), __LINE__);
        }
        $this->ServiceSpecificId = $serviceSpecificId;
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\LiabilityItem
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionNumber value
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return $this->TransactionNumber;
    }
    /**
     * Set TransactionNumber value
     * @param int $transactionNumber
     * @return \patest\StructType\LiabilityItem
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        $this->TransactionNumber = $transactionNumber;
        return $this;
    }
    /**
     * Get RefundPaidAmount value
     * @return \patest\StructType\Money|null
     */
    public function getRefundPaidAmount()
    {
        return $this->RefundPaidAmount;
    }
    /**
     * Set RefundPaidAmount value
     * @param \patest\StructType\Money $refundPaidAmount
     * @return \patest\StructType\LiabilityItem
     */
    public function setRefundPaidAmount(\patest\StructType\Money $refundPaidAmount = null)
    {
        $this->RefundPaidAmount = $refundPaidAmount;
        return $this;
    }
    /**
     * Get RefundLiability value
     * @return \patest\StructType\Money|null
     */
    public function getRefundLiability()
    {
        return $this->RefundLiability;
    }
    /**
     * Set RefundLiability value
     * @param \patest\StructType\Money $refundLiability
     * @return \patest\StructType\LiabilityItem
     */
    public function setRefundLiability(\patest\StructType\Money $refundLiability = null)
    {
        $this->RefundLiability = $refundLiability;
        return $this;
    }
    /**
     * Get FacePrice value
     * @return \patest\StructType\Money|null
     */
    public function getFacePrice()
    {
        return $this->FacePrice;
    }
    /**
     * Set FacePrice value
     * @param \patest\StructType\Money $facePrice
     * @return \patest\StructType\LiabilityItem
     */
    public function setFacePrice(\patest\StructType\Money $facePrice = null)
    {
        $this->FacePrice = $facePrice;
        return $this;
    }
    /**
     * Get CommissionAmount value
     * @return \patest\StructType\Money|null
     */
    public function getCommissionAmount()
    {
        return $this->CommissionAmount;
    }
    /**
     * Set CommissionAmount value
     * @param \patest\StructType\Money $commissionAmount
     * @return \patest\StructType\LiabilityItem
     */
    public function setCommissionAmount(\patest\StructType\Money $commissionAmount = null)
    {
        $this->CommissionAmount = $commissionAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTaxAmount()
    {
        return isset($this->TaxAmount) ? $this->TaxAmount : null;
    }
    /**
     * Set TaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $taxAmount
     * @return \patest\StructType\LiabilityItem
     */
    public function setTaxAmount(\patest\StructType\Money $taxAmount = null)
    {
        if (is_null($taxAmount) || (is_array($taxAmount) && empty($taxAmount))) {
            unset($this->TaxAmount);
        } else {
            $this->TaxAmount = $taxAmount;
        }
        return $this;
    }
    /**
     * Get ListPrice value
     * @return \patest\StructType\Money|null
     */
    public function getListPrice()
    {
        return $this->ListPrice;
    }
    /**
     * Set ListPrice value
     * @param \patest\StructType\Money $listPrice
     * @return \patest\StructType\LiabilityItem
     */
    public function setListPrice(\patest\StructType\Money $listPrice = null)
    {
        $this->ListPrice = $listPrice;
        return $this;
    }
}
