<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeepAlive-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:KeepAlive-Request
 * @subpackage Structs
 */
class KeepAlive_Request extends ExtensibleDataContract
{
    /**
     * The ApplicationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationName;
    /**
     * Constructor method for KeepAlive-Request
     * @uses KeepAlive_Request::setApplicationName()
     * @param string $applicationName
     */
    public function __construct($applicationName = null)
    {
        $this
            ->setApplicationName($applicationName);
    }
    /**
     * Get ApplicationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationName()
    {
        return isset($this->ApplicationName) ? $this->ApplicationName : null;
    }
    /**
     * Set ApplicationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationName
     * @return \patest\StructType\KeepAlive_Request
     */
    public function setApplicationName($applicationName = null)
    {
        // validation for constraint: string
        if (!is_null($applicationName) && !is_string($applicationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationName, true), gettype($applicationName)), __LINE__);
        }
        if (is_null($applicationName) || (is_array($applicationName) && empty($applicationName))) {
            unset($this->ApplicationName);
        } else {
            $this->ApplicationName = $applicationName;
        }
        return $this;
    }
}
