<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobStatus StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:JobStatus
 * @subpackage Structs
 */
class JobStatus extends AbstractStructBase
{
    /**
     * The CompletedItemCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompletedItemCount;
    /**
     * The FailedItemCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FailedItemCount;
    /**
     * The IsHealthy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsHealthy;
    /**
     * The LastRunAtUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LastRunAtUtc;
    /**
     * The NextRunAtUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NextRunAtUtc;
    /**
     * The QueueLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $QueueLength;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * Constructor method for JobStatus
     * @uses JobStatus::setCompletedItemCount()
     * @uses JobStatus::setFailedItemCount()
     * @uses JobStatus::setIsHealthy()
     * @uses JobStatus::setLastRunAtUtc()
     * @uses JobStatus::setNextRunAtUtc()
     * @uses JobStatus::setQueueLength()
     * @uses JobStatus::setState()
     * @param int $completedItemCount
     * @param int $failedItemCount
     * @param bool $isHealthy
     * @param string $lastRunAtUtc
     * @param string $nextRunAtUtc
     * @param int $queueLength
     * @param string $state
     */
    public function __construct($completedItemCount = null, $failedItemCount = null, $isHealthy = null, $lastRunAtUtc = null, $nextRunAtUtc = null, $queueLength = null, $state = null)
    {
        $this
            ->setCompletedItemCount($completedItemCount)
            ->setFailedItemCount($failedItemCount)
            ->setIsHealthy($isHealthy)
            ->setLastRunAtUtc($lastRunAtUtc)
            ->setNextRunAtUtc($nextRunAtUtc)
            ->setQueueLength($queueLength)
            ->setState($state);
    }
    /**
     * Get CompletedItemCount value
     * @return int|null
     */
    public function getCompletedItemCount()
    {
        return $this->CompletedItemCount;
    }
    /**
     * Set CompletedItemCount value
     * @param int $completedItemCount
     * @return \patest\StructType\JobStatus
     */
    public function setCompletedItemCount($completedItemCount = null)
    {
        // validation for constraint: int
        if (!is_null($completedItemCount) && !(is_int($completedItemCount) || ctype_digit($completedItemCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($completedItemCount, true), gettype($completedItemCount)), __LINE__);
        }
        $this->CompletedItemCount = $completedItemCount;
        return $this;
    }
    /**
     * Get FailedItemCount value
     * @return int|null
     */
    public function getFailedItemCount()
    {
        return $this->FailedItemCount;
    }
    /**
     * Set FailedItemCount value
     * @param int $failedItemCount
     * @return \patest\StructType\JobStatus
     */
    public function setFailedItemCount($failedItemCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedItemCount) && !(is_int($failedItemCount) || ctype_digit($failedItemCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedItemCount, true), gettype($failedItemCount)), __LINE__);
        }
        $this->FailedItemCount = $failedItemCount;
        return $this;
    }
    /**
     * Get IsHealthy value
     * @return bool|null
     */
    public function getIsHealthy()
    {
        return $this->IsHealthy;
    }
    /**
     * Set IsHealthy value
     * @param bool $isHealthy
     * @return \patest\StructType\JobStatus
     */
    public function setIsHealthy($isHealthy = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHealthy) && !is_bool($isHealthy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHealthy, true), gettype($isHealthy)), __LINE__);
        }
        $this->IsHealthy = $isHealthy;
        return $this;
    }
    /**
     * Get LastRunAtUtc value
     * @return string|null
     */
    public function getLastRunAtUtc()
    {
        return $this->LastRunAtUtc;
    }
    /**
     * Set LastRunAtUtc value
     * @param string $lastRunAtUtc
     * @return \patest\StructType\JobStatus
     */
    public function setLastRunAtUtc($lastRunAtUtc = null)
    {
        // validation for constraint: string
        if (!is_null($lastRunAtUtc) && !is_string($lastRunAtUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastRunAtUtc, true), gettype($lastRunAtUtc)), __LINE__);
        }
        $this->LastRunAtUtc = $lastRunAtUtc;
        return $this;
    }
    /**
     * Get NextRunAtUtc value
     * @return string|null
     */
    public function getNextRunAtUtc()
    {
        return $this->NextRunAtUtc;
    }
    /**
     * Set NextRunAtUtc value
     * @param string $nextRunAtUtc
     * @return \patest\StructType\JobStatus
     */
    public function setNextRunAtUtc($nextRunAtUtc = null)
    {
        // validation for constraint: string
        if (!is_null($nextRunAtUtc) && !is_string($nextRunAtUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextRunAtUtc, true), gettype($nextRunAtUtc)), __LINE__);
        }
        $this->NextRunAtUtc = $nextRunAtUtc;
        return $this;
    }
    /**
     * Get QueueLength value
     * @return int|null
     */
    public function getQueueLength()
    {
        return $this->QueueLength;
    }
    /**
     * Set QueueLength value
     * @param int $queueLength
     * @return \patest\StructType\JobStatus
     */
    public function setQueueLength($queueLength = null)
    {
        // validation for constraint: int
        if (!is_null($queueLength) && !(is_int($queueLength) || ctype_digit($queueLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($queueLength, true), gettype($queueLength)), __LINE__);
        }
        $this->QueueLength = $queueLength;
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \patest\StructType\JobStatus
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
}
