<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IsFeatureEnabled-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:IsFeatureEnabled-Request
 * @subpackage Structs
 */
class IsFeatureEnabled_Request extends ExtensibleDataContract
{
    /**
     * The Context
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $Context;
    /**
     * The FeatureFlagName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FeatureFlagName;
    /**
     * Constructor method for IsFeatureEnabled-Request
     * @uses IsFeatureEnabled_Request::setContext()
     * @uses IsFeatureEnabled_Request::setFeatureFlagName()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $featureFlagName
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context = null, $featureFlagName = null)
    {
        $this
            ->setContext($context)
            ->setFeatureFlagName($featureFlagName);
    }
    /**
     * Get Context value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getContext()
    {
        return isset($this->Context) ? $this->Context : null;
    }
    /**
     * Set Context value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @return \patest\StructType\IsFeatureEnabled_Request
     */
    public function setContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context = null)
    {
        if (is_null($context) || (is_array($context) && empty($context))) {
            unset($this->Context);
        } else {
            $this->Context = $context;
        }
        return $this;
    }
    /**
     * Get FeatureFlagName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFeatureFlagName()
    {
        return isset($this->FeatureFlagName) ? $this->FeatureFlagName : null;
    }
    /**
     * Set FeatureFlagName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $featureFlagName
     * @return \patest\StructType\IsFeatureEnabled_Request
     */
    public function setFeatureFlagName($featureFlagName = null)
    {
        // validation for constraint: string
        if (!is_null($featureFlagName) && !is_string($featureFlagName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($featureFlagName, true), gettype($featureFlagName)), __LINE__);
        }
        if (is_null($featureFlagName) || (is_array($featureFlagName) && empty($featureFlagName))) {
            unset($this->FeatureFlagName);
        } else {
            $this->FeatureFlagName = $featureFlagName;
        }
        return $this;
    }
}
