<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IsEventAvailableAt-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:IsEventAvailableAt-Request
 * @subpackage Structs
 */
class IsEventAvailableAt_Request extends ExtensibleDataContract
{
    /**
     * The CouponId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CouponId;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The SecurityContext
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SecurityContext;
    /**
     * The UtcDateTimeToCheckFor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UtcDateTimeToCheckFor;
    /**
     * Constructor method for IsEventAvailableAt-Request
     * @uses IsEventAvailableAt_Request::setCouponId()
     * @uses IsEventAvailableAt_Request::setEventId()
     * @uses IsEventAvailableAt_Request::setSecurityContext()
     * @uses IsEventAvailableAt_Request::setUtcDateTimeToCheckFor()
     * @param string $couponId
     * @param string $eventId
     * @param string $securityContext
     * @param string $utcDateTimeToCheckFor
     */
    public function __construct($couponId = null, $eventId = null, $securityContext = null, $utcDateTimeToCheckFor = null)
    {
        $this
            ->setCouponId($couponId)
            ->setEventId($eventId)
            ->setSecurityContext($securityContext)
            ->setUtcDateTimeToCheckFor($utcDateTimeToCheckFor);
    }
    /**
     * Get CouponId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponId()
    {
        return isset($this->CouponId) ? $this->CouponId : null;
    }
    /**
     * Set CouponId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponId
     * @return \patest\StructType\IsEventAvailableAt_Request
     */
    public function setCouponId($couponId = null)
    {
        // validation for constraint: string
        if (!is_null($couponId) && !is_string($couponId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponId, true), gettype($couponId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($couponId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $couponId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($couponId, true)), __LINE__);
        }
        if (is_null($couponId) || (is_array($couponId) && empty($couponId))) {
            unset($this->CouponId);
        } else {
            $this->CouponId = $couponId;
        }
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\IsEventAvailableAt_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get SecurityContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityContext()
    {
        return isset($this->SecurityContext) ? $this->SecurityContext : null;
    }
    /**
     * Set SecurityContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityContext
     * @return \patest\StructType\IsEventAvailableAt_Request
     */
    public function setSecurityContext($securityContext = null)
    {
        // validation for constraint: string
        if (!is_null($securityContext) && !is_string($securityContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityContext, true), gettype($securityContext)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($securityContext) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $securityContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($securityContext, true)), __LINE__);
        }
        if (is_null($securityContext) || (is_array($securityContext) && empty($securityContext))) {
            unset($this->SecurityContext);
        } else {
            $this->SecurityContext = $securityContext;
        }
        return $this;
    }
    /**
     * Get UtcDateTimeToCheckFor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUtcDateTimeToCheckFor()
    {
        return isset($this->UtcDateTimeToCheckFor) ? $this->UtcDateTimeToCheckFor : null;
    }
    /**
     * Set UtcDateTimeToCheckFor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $utcDateTimeToCheckFor
     * @return \patest\StructType\IsEventAvailableAt_Request
     */
    public function setUtcDateTimeToCheckFor($utcDateTimeToCheckFor = null)
    {
        // validation for constraint: string
        if (!is_null($utcDateTimeToCheckFor) && !is_string($utcDateTimeToCheckFor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($utcDateTimeToCheckFor, true), gettype($utcDateTimeToCheckFor)), __LINE__);
        }
        if (is_null($utcDateTimeToCheckFor) || (is_array($utcDateTimeToCheckFor) && empty($utcDateTimeToCheckFor))) {
            unset($this->UtcDateTimeToCheckFor);
        } else {
            $this->UtcDateTimeToCheckFor = $utcDateTimeToCheckFor;
        }
        return $this;
    }
}
