<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentifyAndLinkClientResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:IdentifyAndLinkClientResponse
 * @subpackage Structs
 */
class IdentifyAndLinkClientResponse extends AbstractStructBase
{
    /**
     * The IdentifiedClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdentifiedClientId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for IdentifyAndLinkClientResponse
     * @uses IdentifyAndLinkClientResponse::setIdentifiedClientId()
     * @uses IdentifyAndLinkClientResponse::setStatus()
     * @param string $identifiedClientId
     * @param string $status
     */
    public function __construct($identifiedClientId = null, $status = null)
    {
        $this
            ->setIdentifiedClientId($identifiedClientId)
            ->setStatus($status);
    }
    /**
     * Get IdentifiedClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentifiedClientId()
    {
        return isset($this->IdentifiedClientId) ? $this->IdentifiedClientId : null;
    }
    /**
     * Set IdentifiedClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identifiedClientId
     * @return \patest\StructType\IdentifyAndLinkClientResponse
     */
    public function setIdentifiedClientId($identifiedClientId = null)
    {
        // validation for constraint: string
        if (!is_null($identifiedClientId) && !is_string($identifiedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifiedClientId, true), gettype($identifiedClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($identifiedClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $identifiedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($identifiedClientId, true)), __LINE__);
        }
        if (is_null($identifiedClientId) || (is_array($identifiedClientId) && empty($identifiedClientId))) {
            unset($this->IdentifiedClientId);
        } else {
            $this->IdentifiedClientId = $identifiedClientId;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \patest\EnumType\IdentifyAndLinkClientStatus::valueIsValid()
     * @uses \patest\EnumType\IdentifyAndLinkClientStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\IdentifyAndLinkClientResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\IdentifyAndLinkClientStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\IdentifyAndLinkClientStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\IdentifyAndLinkClientStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
