<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.ReminderDefinition StructType
 * @subpackage Structs
 */
class HelpDesk_ReminderDefinition extends PersistableEntity
{
    /**
     * The DisplayMessageForClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DisplayMessageForClient;
    /**
     * The RequestTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestTypeId;
    /**
     * The TimeDelta
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $TimeDelta;
    /**
     * The Urgency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Urgency;
    /**
     * The When
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $When;
    /**
     * Constructor method for HelpDesk.ReminderDefinition
     * @uses HelpDesk_ReminderDefinition::setDisplayMessageForClient()
     * @uses HelpDesk_ReminderDefinition::setRequestTypeId()
     * @uses HelpDesk_ReminderDefinition::setTimeDelta()
     * @uses HelpDesk_ReminderDefinition::setUrgency()
     * @uses HelpDesk_ReminderDefinition::setWhen()
     * @param \patest\StructType\GlobalString $displayMessageForClient
     * @param string $requestTypeId
     * @param string $timeDelta
     * @param string $urgency
     * @param string $when
     */
    public function __construct(\patest\StructType\GlobalString $displayMessageForClient = null, $requestTypeId = null, $timeDelta = null, $urgency = null, $when = null)
    {
        $this
            ->setDisplayMessageForClient($displayMessageForClient)
            ->setRequestTypeId($requestTypeId)
            ->setTimeDelta($timeDelta)
            ->setUrgency($urgency)
            ->setWhen($when);
    }
    /**
     * Get DisplayMessageForClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDisplayMessageForClient()
    {
        return isset($this->DisplayMessageForClient) ? $this->DisplayMessageForClient : null;
    }
    /**
     * Set DisplayMessageForClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $displayMessageForClient
     * @return \patest\StructType\HelpDesk_ReminderDefinition
     */
    public function setDisplayMessageForClient(\patest\StructType\GlobalString $displayMessageForClient = null)
    {
        if (is_null($displayMessageForClient) || (is_array($displayMessageForClient) && empty($displayMessageForClient))) {
            unset($this->DisplayMessageForClient);
        } else {
            $this->DisplayMessageForClient = $displayMessageForClient;
        }
        return $this;
    }
    /**
     * Get RequestTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTypeId()
    {
        return isset($this->RequestTypeId) ? $this->RequestTypeId : null;
    }
    /**
     * Set RequestTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTypeId
     * @return \patest\StructType\HelpDesk_ReminderDefinition
     */
    public function setRequestTypeId($requestTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($requestTypeId) && !is_string($requestTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTypeId, true), gettype($requestTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestTypeId, true)), __LINE__);
        }
        if (is_null($requestTypeId) || (is_array($requestTypeId) && empty($requestTypeId))) {
            unset($this->RequestTypeId);
        } else {
            $this->RequestTypeId = $requestTypeId;
        }
        return $this;
    }
    /**
     * Get TimeDelta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeDelta()
    {
        return isset($this->TimeDelta) ? $this->TimeDelta : null;
    }
    /**
     * Set TimeDelta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeDelta
     * @return \patest\StructType\HelpDesk_ReminderDefinition
     */
    public function setTimeDelta($timeDelta = null)
    {
        // validation for constraint: string
        if (!is_null($timeDelta) && !is_string($timeDelta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeDelta, true), gettype($timeDelta)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($timeDelta) && false === mb_strpos($timeDelta, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $timeDelta)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($timeDelta, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($timeDelta) && false !== mb_strpos($timeDelta, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $timeDelta)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($timeDelta, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($timeDelta) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $timeDelta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($timeDelta, true)), __LINE__);
        }
        if (is_null($timeDelta) || (is_array($timeDelta) && empty($timeDelta))) {
            unset($this->TimeDelta);
        } else {
            $this->TimeDelta = $timeDelta;
        }
        return $this;
    }
    /**
     * Get Urgency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrgency()
    {
        return isset($this->Urgency) ? $this->Urgency : null;
    }
    /**
     * Set Urgency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestPriority::valueIsValid()
     * @uses \patest\EnumType\RequestPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $urgency
     * @return \patest\StructType\HelpDesk_ReminderDefinition
     */
    public function setUrgency($urgency = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestPriority::valueIsValid($urgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestPriority', is_array($urgency) ? implode(', ', $urgency) : var_export($urgency, true), implode(', ', \patest\EnumType\RequestPriority::getValidValues())), __LINE__);
        }
        if (is_null($urgency) || (is_array($urgency) && empty($urgency))) {
            unset($this->Urgency);
        } else {
            $this->Urgency = $urgency;
        }
        return $this;
    }
    /**
     * Get When value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhen()
    {
        return isset($this->When) ? $this->When : null;
    }
    /**
     * Set When value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReminderTimeOption::valueIsValid()
     * @uses \patest\EnumType\ReminderTimeOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $when
     * @return \patest\StructType\HelpDesk_ReminderDefinition
     */
    public function setWhen($when = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReminderTimeOption::valueIsValid($when)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReminderTimeOption', is_array($when) ? implode(', ', $when) : var_export($when, true), implode(', ', \patest\EnumType\ReminderTimeOption::getValidValues())), __LINE__);
        }
        if (is_null($when) || (is_array($when) && empty($when))) {
            unset($this->When);
        } else {
            $this->When = $when;
        }
        return $this;
    }
}
