<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.CustomerCallServiceRequest StructType
 * @subpackage Structs
 */
class HelpDesk_CustomerCallServiceRequest extends HelpDesk_ServiceRequest
{
    /**
     * The RelatedDepartment
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedDepartment;
    /**
     * The RelatedUser
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedUser;
    /**
     * The RelevantFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelevantFrom;
    /**
     * The RelevantUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelevantUntil;
    /**
     * The TalkDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TalkDetails;
    /**
     * The Topic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Topic;
    /**
     * Constructor method for HelpDesk.CustomerCallServiceRequest
     * @uses HelpDesk_CustomerCallServiceRequest::setRelatedDepartment()
     * @uses HelpDesk_CustomerCallServiceRequest::setRelatedUser()
     * @uses HelpDesk_CustomerCallServiceRequest::setRelevantFrom()
     * @uses HelpDesk_CustomerCallServiceRequest::setRelevantUntil()
     * @uses HelpDesk_CustomerCallServiceRequest::setTalkDetails()
     * @uses HelpDesk_CustomerCallServiceRequest::setTopic()
     * @param string $relatedDepartment
     * @param string $relatedUser
     * @param string $relevantFrom
     * @param string $relevantUntil
     * @param string $talkDetails
     * @param string $topic
     */
    public function __construct($relatedDepartment = null, $relatedUser = null, $relevantFrom = null, $relevantUntil = null, $talkDetails = null, $topic = null)
    {
        $this
            ->setRelatedDepartment($relatedDepartment)
            ->setRelatedUser($relatedUser)
            ->setRelevantFrom($relevantFrom)
            ->setRelevantUntil($relevantUntil)
            ->setTalkDetails($talkDetails)
            ->setTopic($topic);
    }
    /**
     * Get RelatedDepartment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedDepartment()
    {
        return isset($this->RelatedDepartment) ? $this->RelatedDepartment : null;
    }
    /**
     * Set RelatedDepartment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedDepartment
     * @return \patest\StructType\HelpDesk_CustomerCallServiceRequest
     */
    public function setRelatedDepartment($relatedDepartment = null)
    {
        // validation for constraint: string
        if (!is_null($relatedDepartment) && !is_string($relatedDepartment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedDepartment, true), gettype($relatedDepartment)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedDepartment) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedDepartment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedDepartment, true)), __LINE__);
        }
        if (is_null($relatedDepartment) || (is_array($relatedDepartment) && empty($relatedDepartment))) {
            unset($this->RelatedDepartment);
        } else {
            $this->RelatedDepartment = $relatedDepartment;
        }
        return $this;
    }
    /**
     * Get RelatedUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedUser()
    {
        return isset($this->RelatedUser) ? $this->RelatedUser : null;
    }
    /**
     * Set RelatedUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedUser
     * @return \patest\StructType\HelpDesk_CustomerCallServiceRequest
     */
    public function setRelatedUser($relatedUser = null)
    {
        // validation for constraint: string
        if (!is_null($relatedUser) && !is_string($relatedUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedUser, true), gettype($relatedUser)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedUser) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedUser, true)), __LINE__);
        }
        if (is_null($relatedUser) || (is_array($relatedUser) && empty($relatedUser))) {
            unset($this->RelatedUser);
        } else {
            $this->RelatedUser = $relatedUser;
        }
        return $this;
    }
    /**
     * Get RelevantFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelevantFrom()
    {
        return isset($this->RelevantFrom) ? $this->RelevantFrom : null;
    }
    /**
     * Set RelevantFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relevantFrom
     * @return \patest\StructType\HelpDesk_CustomerCallServiceRequest
     */
    public function setRelevantFrom($relevantFrom = null)
    {
        // validation for constraint: string
        if (!is_null($relevantFrom) && !is_string($relevantFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relevantFrom, true), gettype($relevantFrom)), __LINE__);
        }
        if (is_null($relevantFrom) || (is_array($relevantFrom) && empty($relevantFrom))) {
            unset($this->RelevantFrom);
        } else {
            $this->RelevantFrom = $relevantFrom;
        }
        return $this;
    }
    /**
     * Get RelevantUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelevantUntil()
    {
        return isset($this->RelevantUntil) ? $this->RelevantUntil : null;
    }
    /**
     * Set RelevantUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relevantUntil
     * @return \patest\StructType\HelpDesk_CustomerCallServiceRequest
     */
    public function setRelevantUntil($relevantUntil = null)
    {
        // validation for constraint: string
        if (!is_null($relevantUntil) && !is_string($relevantUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relevantUntil, true), gettype($relevantUntil)), __LINE__);
        }
        if (is_null($relevantUntil) || (is_array($relevantUntil) && empty($relevantUntil))) {
            unset($this->RelevantUntil);
        } else {
            $this->RelevantUntil = $relevantUntil;
        }
        return $this;
    }
    /**
     * Get TalkDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTalkDetails()
    {
        return isset($this->TalkDetails) ? $this->TalkDetails : null;
    }
    /**
     * Set TalkDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $talkDetails
     * @return \patest\StructType\HelpDesk_CustomerCallServiceRequest
     */
    public function setTalkDetails($talkDetails = null)
    {
        // validation for constraint: string
        if (!is_null($talkDetails) && !is_string($talkDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($talkDetails, true), gettype($talkDetails)), __LINE__);
        }
        if (is_null($talkDetails) || (is_array($talkDetails) && empty($talkDetails))) {
            unset($this->TalkDetails);
        } else {
            $this->TalkDetails = $talkDetails;
        }
        return $this;
    }
    /**
     * Get Topic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTopic()
    {
        return isset($this->Topic) ? $this->Topic : null;
    }
    /**
     * Set Topic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $topic
     * @return \patest\StructType\HelpDesk_CustomerCallServiceRequest
     */
    public function setTopic($topic = null)
    {
        // validation for constraint: string
        if (!is_null($topic) && !is_string($topic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($topic, true), gettype($topic)), __LINE__);
        }
        if (is_null($topic) || (is_array($topic) && empty($topic))) {
            unset($this->Topic);
        } else {
            $this->Topic = $topic;
        }
        return $this;
    }
}
