<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HallDesignBreakingChangeInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:HallDesignBreakingChangeInfo
 * @subpackage Structs
 */
class HallDesignBreakingChangeInfo extends AbstractStructBase
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The ChangeKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ChangeKind;
    /**
     * The NewGaCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NewGaCapacity;
    /**
     * The RemovedSeatIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $RemovedSeatIds;
    /**
     * Constructor method for HallDesignBreakingChangeInfo
     * @uses HallDesignBreakingChangeInfo::setAreaId()
     * @uses HallDesignBreakingChangeInfo::setChangeKind()
     * @uses HallDesignBreakingChangeInfo::setNewGaCapacity()
     * @uses HallDesignBreakingChangeInfo::setRemovedSeatIds()
     * @param string $areaId
     * @param string $changeKind
     * @param int $newGaCapacity
     * @param \patest\ArrayType\ArrayOfint $removedSeatIds
     */
    public function __construct($areaId = null, $changeKind = null, $newGaCapacity = null, \patest\ArrayType\ArrayOfint $removedSeatIds = null)
    {
        $this
            ->setAreaId($areaId)
            ->setChangeKind($changeKind)
            ->setNewGaCapacity($newGaCapacity)
            ->setRemovedSeatIds($removedSeatIds);
    }
    /**
     * Get AreaId value
     * @return string|null
     */
    public function getAreaId()
    {
        return $this->AreaId;
    }
    /**
     * Set AreaId value
     * @param string $areaId
     * @return \patest\StructType\HallDesignBreakingChangeInfo
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        $this->AreaId = $areaId;
        return $this;
    }
    /**
     * Get ChangeKind value
     * @return string|null
     */
    public function getChangeKind()
    {
        return $this->ChangeKind;
    }
    /**
     * Set ChangeKind value
     * @uses \patest\EnumType\HallDesignBreakingChangeKind::valueIsValid()
     * @uses \patest\EnumType\HallDesignBreakingChangeKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $changeKind
     * @return \patest\StructType\HallDesignBreakingChangeInfo
     */
    public function setChangeKind($changeKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HallDesignBreakingChangeKind::valueIsValid($changeKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HallDesignBreakingChangeKind', is_array($changeKind) ? implode(', ', $changeKind) : var_export($changeKind, true), implode(', ', \patest\EnumType\HallDesignBreakingChangeKind::getValidValues())), __LINE__);
        }
        $this->ChangeKind = $changeKind;
        return $this;
    }
    /**
     * Get NewGaCapacity value
     * @return int|null
     */
    public function getNewGaCapacity()
    {
        return $this->NewGaCapacity;
    }
    /**
     * Set NewGaCapacity value
     * @param int $newGaCapacity
     * @return \patest\StructType\HallDesignBreakingChangeInfo
     */
    public function setNewGaCapacity($newGaCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($newGaCapacity) && !(is_int($newGaCapacity) || ctype_digit($newGaCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newGaCapacity, true), gettype($newGaCapacity)), __LINE__);
        }
        $this->NewGaCapacity = $newGaCapacity;
        return $this;
    }
    /**
     * Get RemovedSeatIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getRemovedSeatIds()
    {
        return isset($this->RemovedSeatIds) ? $this->RemovedSeatIds : null;
    }
    /**
     * Set RemovedSeatIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $removedSeatIds
     * @return \patest\StructType\HallDesignBreakingChangeInfo
     */
    public function setRemovedSeatIds(\patest\ArrayType\ArrayOfint $removedSeatIds = null)
    {
        if (is_null($removedSeatIds) || (is_array($removedSeatIds) && empty($removedSeatIds))) {
            unset($this->RemovedSeatIds);
        } else {
            $this->RemovedSeatIds = $removedSeatIds;
        }
        return $this;
    }
}
