<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucher.GiftVoucherSearchData StructType
 * @subpackage Structs
 */
class GiftVoucher_GiftVoucherSearchData extends GiftVoucher_GiftVoucherItemTransaction
{
    /**
     * The GiftVoucherDefinitionId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherDefinitionId;
    /**
     * The GiftVoucherName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $GiftVoucherName;
    /**
     * The GiftVoucherNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftVoucherNumber;
    /**
     * The GiftVoucherTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherTypeId;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The ProductItemStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductItemStatus;
    /**
     * Constructor method for GiftVoucher.GiftVoucherSearchData
     * @uses GiftVoucher_GiftVoucherSearchData::setGiftVoucherDefinitionId()
     * @uses GiftVoucher_GiftVoucherSearchData::setGiftVoucherName()
     * @uses GiftVoucher_GiftVoucherSearchData::setGiftVoucherNumber()
     * @uses GiftVoucher_GiftVoucherSearchData::setGiftVoucherTypeId()
     * @uses GiftVoucher_GiftVoucherSearchData::setOrganizationUnitId()
     * @uses GiftVoucher_GiftVoucherSearchData::setPrintCount()
     * @uses GiftVoucher_GiftVoucherSearchData::setProductItemStatus()
     * @param string $giftVoucherDefinitionId
     * @param \patest\StructType\GlobalString $giftVoucherName
     * @param string $giftVoucherNumber
     * @param string $giftVoucherTypeId
     * @param string $organizationUnitId
     * @param int $printCount
     * @param string $productItemStatus
     */
    public function __construct($giftVoucherDefinitionId = null, \patest\StructType\GlobalString $giftVoucherName = null, $giftVoucherNumber = null, $giftVoucherTypeId = null, $organizationUnitId = null, $printCount = null, $productItemStatus = null)
    {
        $this
            ->setGiftVoucherDefinitionId($giftVoucherDefinitionId)
            ->setGiftVoucherName($giftVoucherName)
            ->setGiftVoucherNumber($giftVoucherNumber)
            ->setGiftVoucherTypeId($giftVoucherTypeId)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPrintCount($printCount)
            ->setProductItemStatus($productItemStatus);
    }
    /**
     * Get GiftVoucherDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherDefinitionId()
    {
        return isset($this->GiftVoucherDefinitionId) ? $this->GiftVoucherDefinitionId : null;
    }
    /**
     * Set GiftVoucherDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherDefinitionId
     * @return \patest\StructType\GiftVoucher_GiftVoucherSearchData
     */
    public function setGiftVoucherDefinitionId($giftVoucherDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherDefinitionId) && !is_string($giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherDefinitionId, true), gettype($giftVoucherDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherDefinitionId, true)), __LINE__);
        }
        if (is_null($giftVoucherDefinitionId) || (is_array($giftVoucherDefinitionId) && empty($giftVoucherDefinitionId))) {
            unset($this->GiftVoucherDefinitionId);
        } else {
            $this->GiftVoucherDefinitionId = $giftVoucherDefinitionId;
        }
        return $this;
    }
    /**
     * Get GiftVoucherName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getGiftVoucherName()
    {
        return isset($this->GiftVoucherName) ? $this->GiftVoucherName : null;
    }
    /**
     * Set GiftVoucherName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $giftVoucherName
     * @return \patest\StructType\GiftVoucher_GiftVoucherSearchData
     */
    public function setGiftVoucherName(\patest\StructType\GlobalString $giftVoucherName = null)
    {
        if (is_null($giftVoucherName) || (is_array($giftVoucherName) && empty($giftVoucherName))) {
            unset($this->GiftVoucherName);
        } else {
            $this->GiftVoucherName = $giftVoucherName;
        }
        return $this;
    }
    /**
     * Get GiftVoucherNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherNumber()
    {
        return isset($this->GiftVoucherNumber) ? $this->GiftVoucherNumber : null;
    }
    /**
     * Set GiftVoucherNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherNumber
     * @return \patest\StructType\GiftVoucher_GiftVoucherSearchData
     */
    public function setGiftVoucherNumber($giftVoucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherNumber) && !is_string($giftVoucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherNumber, true), gettype($giftVoucherNumber)), __LINE__);
        }
        if (is_null($giftVoucherNumber) || (is_array($giftVoucherNumber) && empty($giftVoucherNumber))) {
            unset($this->GiftVoucherNumber);
        } else {
            $this->GiftVoucherNumber = $giftVoucherNumber;
        }
        return $this;
    }
    /**
     * Get GiftVoucherTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherTypeId()
    {
        return isset($this->GiftVoucherTypeId) ? $this->GiftVoucherTypeId : null;
    }
    /**
     * Set GiftVoucherTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherTypeId
     * @return \patest\StructType\GiftVoucher_GiftVoucherSearchData
     */
    public function setGiftVoucherTypeId($giftVoucherTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherTypeId) && !is_string($giftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherTypeId, true), gettype($giftVoucherTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherTypeId, true)), __LINE__);
        }
        if (is_null($giftVoucherTypeId) || (is_array($giftVoucherTypeId) && empty($giftVoucherTypeId))) {
            unset($this->GiftVoucherTypeId);
        } else {
            $this->GiftVoucherTypeId = $giftVoucherTypeId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\GiftVoucher_GiftVoucherSearchData
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\GiftVoucher_GiftVoucherSearchData
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get ProductItemStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductItemStatus()
    {
        return isset($this->ProductItemStatus) ? $this->ProductItemStatus : null;
    }
    /**
     * Set ProductItemStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GiftVoucherStatus::valueIsValid()
     * @uses \patest\EnumType\GiftVoucherStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productItemStatus
     * @return \patest\StructType\GiftVoucher_GiftVoucherSearchData
     */
    public function setProductItemStatus($productItemStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GiftVoucherStatus::valueIsValid($productItemStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GiftVoucherStatus', is_array($productItemStatus) ? implode(', ', $productItemStatus) : var_export($productItemStatus, true), implode(', ', \patest\EnumType\GiftVoucherStatus::getValidValues())), __LINE__);
        }
        if (is_null($productItemStatus) || (is_array($productItemStatus) && empty($productItemStatus))) {
            unset($this->ProductItemStatus);
        } else {
            $this->ProductItemStatus = $productItemStatus;
        }
        return $this;
    }
}
