<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucher.CardFilter StructType
 * @subpackage Structs
 */
class GiftVoucher_CardFilter extends FilterEntity
{
    /**
     * The CardProgramIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CardProgramIds
     */
    public $CardProgramIds;
    /**
     * The CardTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CardTypeId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Provider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Provider;
    /**
     * Constructor method for GiftVoucher.CardFilter
     * @uses GiftVoucher_CardFilter::setCardProgramIds()
     * @uses GiftVoucher_CardFilter::setCardTypeId()
     * @uses GiftVoucher_CardFilter::setDescription()
     * @uses GiftVoucher_CardFilter::setName()
     * @uses GiftVoucher_CardFilter::setProvider()
     * @param \patest\StructType\CardProgramIds $cardProgramIds
     * @param string $cardTypeId
     * @param string $description
     * @param string $name
     * @param string $provider
     */
    public function __construct(\patest\StructType\CardProgramIds $cardProgramIds = null, $cardTypeId = null, $description = null, $name = null, $provider = null)
    {
        $this
            ->setCardProgramIds($cardProgramIds)
            ->setCardTypeId($cardTypeId)
            ->setDescription($description)
            ->setName($name)
            ->setProvider($provider);
    }
    /**
     * Get CardProgramIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CardProgramIds|null
     */
    public function getCardProgramIds()
    {
        return isset($this->CardProgramIds) ? $this->CardProgramIds : null;
    }
    /**
     * Set CardProgramIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CardProgramIds $cardProgramIds
     * @return \patest\StructType\GiftVoucher_CardFilter
     */
    public function setCardProgramIds(\patest\StructType\CardProgramIds $cardProgramIds = null)
    {
        if (is_null($cardProgramIds) || (is_array($cardProgramIds) && empty($cardProgramIds))) {
            unset($this->CardProgramIds);
        } else {
            $this->CardProgramIds = $cardProgramIds;
        }
        return $this;
    }
    /**
     * Get CardTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardTypeId()
    {
        return isset($this->CardTypeId) ? $this->CardTypeId : null;
    }
    /**
     * Set CardTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardTypeId
     * @return \patest\StructType\GiftVoucher_CardFilter
     */
    public function setCardTypeId($cardTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeId) && !is_string($cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeId, true), gettype($cardTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cardTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cardTypeId, true)), __LINE__);
        }
        if (is_null($cardTypeId) || (is_array($cardTypeId) && empty($cardTypeId))) {
            unset($this->CardTypeId);
        } else {
            $this->CardTypeId = $cardTypeId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\GiftVoucher_CardFilter
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\GiftVoucher_CardFilter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Provider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvider()
    {
        return isset($this->Provider) ? $this->Provider : null;
    }
    /**
     * Set Provider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provider
     * @return \patest\StructType\GiftVoucher_CardFilter
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider, true), gettype($provider)), __LINE__);
        }
        if (is_null($provider) || (is_array($provider) && empty($provider))) {
            unset($this->Provider);
        } else {
            $this->Provider = $provider;
        }
        return $this;
    }
}
