<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUpdatedEntitiesResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetUpdatedEntitiesResponse
 * @subpackage Structs
 */
class GetUpdatedEntitiesResponse extends AbstractStructBase
{
    /**
     * The Entities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAnyEntity
     */
    public $Entities;
    /**
     * The WaterMark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WaterMark;
    /**
     * Constructor method for GetUpdatedEntitiesResponse
     * @uses GetUpdatedEntitiesResponse::setEntities()
     * @uses GetUpdatedEntitiesResponse::setWaterMark()
     * @param \patest\ArrayType\ArrayOfAnyEntity $entities
     * @param string $waterMark
     */
    public function __construct(\patest\ArrayType\ArrayOfAnyEntity $entities = null, $waterMark = null)
    {
        $this
            ->setEntities($entities)
            ->setWaterMark($waterMark);
    }
    /**
     * Get Entities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAnyEntity|null
     */
    public function getEntities()
    {
        return isset($this->Entities) ? $this->Entities : null;
    }
    /**
     * Set Entities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAnyEntity $entities
     * @return \patest\StructType\GetUpdatedEntitiesResponse
     */
    public function setEntities(\patest\ArrayType\ArrayOfAnyEntity $entities = null)
    {
        if (is_null($entities) || (is_array($entities) && empty($entities))) {
            unset($this->Entities);
        } else {
            $this->Entities = $entities;
        }
        return $this;
    }
    /**
     * Get WaterMark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWaterMark()
    {
        return isset($this->WaterMark) ? $this->WaterMark : null;
    }
    /**
     * Set WaterMark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $waterMark
     * @return \patest\StructType\GetUpdatedEntitiesResponse
     */
    public function setWaterMark($waterMark = null)
    {
        // validation for constraint: string
        if (!is_null($waterMark) && !is_string($waterMark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waterMark, true), gettype($waterMark)), __LINE__);
        }
        if (is_null($waterMark) || (is_array($waterMark) && empty($waterMark))) {
            unset($this->WaterMark);
        } else {
            $this->WaterMark = $waterMark;
        }
        return $this;
    }
}
