<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTransactionAccessControlDataRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetTransactionAccessControlDataRequest
 * @subpackage Structs
 */
class GetTransactionAccessControlDataRequest extends ExtensibleDataContract
{
    /**
     * The GetAlsoItemsThatCanNotBeLoadedOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GetAlsoItemsThatCanNotBeLoadedOnCard;
    /**
     * The ItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $ItemIds;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The OnlyForCurrentOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OnlyForCurrentOwner;
    /**
     * The GetAccessCardActivations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GetAccessCardActivations;
    /**
     * Constructor method for GetTransactionAccessControlDataRequest
     * @uses GetTransactionAccessControlDataRequest::setGetAlsoItemsThatCanNotBeLoadedOnCard()
     * @uses GetTransactionAccessControlDataRequest::setItemIds()
     * @uses GetTransactionAccessControlDataRequest::setTransactionId()
     * @uses GetTransactionAccessControlDataRequest::setOnlyForCurrentOwner()
     * @uses GetTransactionAccessControlDataRequest::setGetAccessCardActivations()
     * @param bool $getAlsoItemsThatCanNotBeLoadedOnCard
     * @param \patest\ArrayType\ArrayOfint $itemIds
     * @param string $transactionId
     * @param bool $onlyForCurrentOwner
     * @param bool $getAccessCardActivations
     */
    public function __construct($getAlsoItemsThatCanNotBeLoadedOnCard = null, \patest\ArrayType\ArrayOfint $itemIds = null, $transactionId = null, $onlyForCurrentOwner = null, $getAccessCardActivations = null)
    {
        $this
            ->setGetAlsoItemsThatCanNotBeLoadedOnCard($getAlsoItemsThatCanNotBeLoadedOnCard)
            ->setItemIds($itemIds)
            ->setTransactionId($transactionId)
            ->setOnlyForCurrentOwner($onlyForCurrentOwner)
            ->setGetAccessCardActivations($getAccessCardActivations);
    }
    /**
     * Get GetAlsoItemsThatCanNotBeLoadedOnCard value
     * @return bool|null
     */
    public function getGetAlsoItemsThatCanNotBeLoadedOnCard()
    {
        return $this->GetAlsoItemsThatCanNotBeLoadedOnCard;
    }
    /**
     * Set GetAlsoItemsThatCanNotBeLoadedOnCard value
     * @param bool $getAlsoItemsThatCanNotBeLoadedOnCard
     * @return \patest\StructType\GetTransactionAccessControlDataRequest
     */
    public function setGetAlsoItemsThatCanNotBeLoadedOnCard($getAlsoItemsThatCanNotBeLoadedOnCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($getAlsoItemsThatCanNotBeLoadedOnCard) && !is_bool($getAlsoItemsThatCanNotBeLoadedOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getAlsoItemsThatCanNotBeLoadedOnCard, true), gettype($getAlsoItemsThatCanNotBeLoadedOnCard)), __LINE__);
        }
        $this->GetAlsoItemsThatCanNotBeLoadedOnCard = $getAlsoItemsThatCanNotBeLoadedOnCard;
        return $this;
    }
    /**
     * Get ItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getItemIds()
    {
        return isset($this->ItemIds) ? $this->ItemIds : null;
    }
    /**
     * Set ItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $itemIds
     * @return \patest\StructType\GetTransactionAccessControlDataRequest
     */
    public function setItemIds(\patest\ArrayType\ArrayOfint $itemIds = null)
    {
        if (is_null($itemIds) || (is_array($itemIds) && empty($itemIds))) {
            unset($this->ItemIds);
        } else {
            $this->ItemIds = $itemIds;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \patest\StructType\GetTransactionAccessControlDataRequest
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get OnlyForCurrentOwner value
     * @return bool|null
     */
    public function getOnlyForCurrentOwner()
    {
        return $this->OnlyForCurrentOwner;
    }
    /**
     * Set OnlyForCurrentOwner value
     * @param bool $onlyForCurrentOwner
     * @return \patest\StructType\GetTransactionAccessControlDataRequest
     */
    public function setOnlyForCurrentOwner($onlyForCurrentOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyForCurrentOwner) && !is_bool($onlyForCurrentOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyForCurrentOwner, true), gettype($onlyForCurrentOwner)), __LINE__);
        }
        $this->OnlyForCurrentOwner = $onlyForCurrentOwner;
        return $this;
    }
    /**
     * Get GetAccessCardActivations value
     * @return bool|null
     */
    public function getGetAccessCardActivations()
    {
        return $this->GetAccessCardActivations;
    }
    /**
     * Set GetAccessCardActivations value
     * @param bool $getAccessCardActivations
     * @return \patest\StructType\GetTransactionAccessControlDataRequest
     */
    public function setGetAccessCardActivations($getAccessCardActivations = null)
    {
        // validation for constraint: boolean
        if (!is_null($getAccessCardActivations) && !is_bool($getAccessCardActivations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getAccessCardActivations, true), gettype($getAccessCardActivations)), __LINE__);
        }
        $this->GetAccessCardActivations = $getAccessCardActivations;
        return $this;
    }
}
