<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTicketViewConfigurationsForEvents-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetTicketViewConfigurationsForEvents-Request
 * @subpackage Structs
 */
class GetTicketViewConfigurationsForEvents_Request extends ExtensibleDataContract
{
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CrmId;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $EventIds;
    /**
     * The IncludeAdditionalTicketBackNotes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeAdditionalTicketBackNotes;
    /**
     * The IncludeEventHeaders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeEventHeaders;
    /**
     * The IncludeMyTicketsCards
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeMyTicketsCards;
    /**
     * Constructor method for GetTicketViewConfigurationsForEvents-Request
     * @uses GetTicketViewConfigurationsForEvents_Request::setCrmId()
     * @uses GetTicketViewConfigurationsForEvents_Request::setEventIds()
     * @uses GetTicketViewConfigurationsForEvents_Request::setIncludeAdditionalTicketBackNotes()
     * @uses GetTicketViewConfigurationsForEvents_Request::setIncludeEventHeaders()
     * @uses GetTicketViewConfigurationsForEvents_Request::setIncludeMyTicketsCards()
     * @param string $crmId
     * @param \patest\ArrayType\ArrayOfguid $eventIds
     * @param bool $includeAdditionalTicketBackNotes
     * @param bool $includeEventHeaders
     * @param bool $includeMyTicketsCards
     */
    public function __construct($crmId = null, \patest\ArrayType\ArrayOfguid $eventIds = null, $includeAdditionalTicketBackNotes = null, $includeEventHeaders = null, $includeMyTicketsCards = null)
    {
        $this
            ->setCrmId($crmId)
            ->setEventIds($eventIds)
            ->setIncludeAdditionalTicketBackNotes($includeAdditionalTicketBackNotes)
            ->setIncludeEventHeaders($includeEventHeaders)
            ->setIncludeMyTicketsCards($includeMyTicketsCards);
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\GetTicketViewConfigurationsForEvents_Request
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($crmId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($crmId, true)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $eventIds
     * @return \patest\StructType\GetTicketViewConfigurationsForEvents_Request
     */
    public function setEventIds(\patest\ArrayType\ArrayOfguid $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get IncludeAdditionalTicketBackNotes value
     * @return bool|null
     */
    public function getIncludeAdditionalTicketBackNotes()
    {
        return $this->IncludeAdditionalTicketBackNotes;
    }
    /**
     * Set IncludeAdditionalTicketBackNotes value
     * @param bool $includeAdditionalTicketBackNotes
     * @return \patest\StructType\GetTicketViewConfigurationsForEvents_Request
     */
    public function setIncludeAdditionalTicketBackNotes($includeAdditionalTicketBackNotes = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAdditionalTicketBackNotes) && !is_bool($includeAdditionalTicketBackNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeAdditionalTicketBackNotes, true), gettype($includeAdditionalTicketBackNotes)), __LINE__);
        }
        $this->IncludeAdditionalTicketBackNotes = $includeAdditionalTicketBackNotes;
        return $this;
    }
    /**
     * Get IncludeEventHeaders value
     * @return bool|null
     */
    public function getIncludeEventHeaders()
    {
        return $this->IncludeEventHeaders;
    }
    /**
     * Set IncludeEventHeaders value
     * @param bool $includeEventHeaders
     * @return \patest\StructType\GetTicketViewConfigurationsForEvents_Request
     */
    public function setIncludeEventHeaders($includeEventHeaders = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeEventHeaders) && !is_bool($includeEventHeaders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeEventHeaders, true), gettype($includeEventHeaders)), __LINE__);
        }
        $this->IncludeEventHeaders = $includeEventHeaders;
        return $this;
    }
    /**
     * Get IncludeMyTicketsCards value
     * @return bool|null
     */
    public function getIncludeMyTicketsCards()
    {
        return $this->IncludeMyTicketsCards;
    }
    /**
     * Set IncludeMyTicketsCards value
     * @param bool $includeMyTicketsCards
     * @return \patest\StructType\GetTicketViewConfigurationsForEvents_Request
     */
    public function setIncludeMyTicketsCards($includeMyTicketsCards = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeMyTicketsCards) && !is_bool($includeMyTicketsCards)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeMyTicketsCards, true), gettype($includeMyTicketsCards)), __LINE__);
        }
        $this->IncludeMyTicketsCards = $includeMyTicketsCards;
        return $this;
    }
}
