<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSectorsOfArea-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetSectorsOfArea-Response
 * @subpackage Structs
 */
class GetSectorsOfArea_Response extends ExtensibleDataContract
{
    /**
     * The SeatingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SeatingType;
    /**
     * The Values
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidstring
     */
    public $Values;
    /**
     * Constructor method for GetSectorsOfArea-Response
     * @uses GetSectorsOfArea_Response::setSeatingType()
     * @uses GetSectorsOfArea_Response::setValues()
     * @param string $seatingType
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidstring $values
     */
    public function __construct($seatingType = null, \patest\ArrayType\ArrayOfKeyValueOfguidstring $values = null)
    {
        $this
            ->setSeatingType($seatingType)
            ->setValues($values);
    }
    /**
     * Get SeatingType value
     * @return string|null
     */
    public function getSeatingType()
    {
        return $this->SeatingType;
    }
    /**
     * Set SeatingType value
     * @uses \patest\EnumType\AreaSeatingType::valueIsValid()
     * @uses \patest\EnumType\AreaSeatingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatingType
     * @return \patest\StructType\GetSectorsOfArea_Response
     */
    public function setSeatingType($seatingType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaSeatingType::valueIsValid($seatingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaSeatingType', is_array($seatingType) ? implode(', ', $seatingType) : var_export($seatingType, true), implode(', ', \patest\EnumType\AreaSeatingType::getValidValues())), __LINE__);
        }
        $this->SeatingType = $seatingType;
        return $this;
    }
    /**
     * Get Values value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidstring|null
     */
    public function getValues()
    {
        return isset($this->Values) ? $this->Values : null;
    }
    /**
     * Set Values value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidstring $values
     * @return \patest\StructType\GetSectorsOfArea_Response
     */
    public function setValues(\patest\ArrayType\ArrayOfKeyValueOfguidstring $values = null)
    {
        if (is_null($values) || (is_array($values) && empty($values))) {
            unset($this->Values);
        } else {
            $this->Values = $values;
        }
        return $this;
    }
}
