<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSeatToolTipInfo-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetSeatToolTipInfo-Request
 * @subpackage Structs
 */
class GetSeatToolTipInfo_Request extends ExtensibleDataContract
{
    /**
     * The AreaGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaGuid;
    /**
     * The SeatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatId;
    /**
     * The SeatingPlanGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanGuid;
    /**
     * The EventPricingRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GetEventPricing_Request
     */
    public $EventPricingRequest;
    /**
     * The IncludeEventPricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeEventPricing;
    /**
     * The IncludeSeatInventoryDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeSeatInventoryDetails;
    /**
     * The IncludeTransactionDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeTransactionDetails;
    /**
     * The IncludeSessionInfoIfExists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeSessionInfoIfExists;
    /**
     * The IncludeSeatLevelPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeSeatLevelPrice;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * Constructor method for GetSeatToolTipInfo-Request
     * @uses GetSeatToolTipInfo_Request::setAreaGuid()
     * @uses GetSeatToolTipInfo_Request::setSeatId()
     * @uses GetSeatToolTipInfo_Request::setSeatingPlanGuid()
     * @uses GetSeatToolTipInfo_Request::setEventPricingRequest()
     * @uses GetSeatToolTipInfo_Request::setIncludeEventPricing()
     * @uses GetSeatToolTipInfo_Request::setIncludeSeatInventoryDetails()
     * @uses GetSeatToolTipInfo_Request::setIncludeTransactionDetails()
     * @uses GetSeatToolTipInfo_Request::setIncludeSessionInfoIfExists()
     * @uses GetSeatToolTipInfo_Request::setIncludeSeatLevelPrice()
     * @uses GetSeatToolTipInfo_Request::setShowId()
     * @uses GetSeatToolTipInfo_Request::setHallVersionId()
     * @param string $areaGuid
     * @param int $seatId
     * @param string $seatingPlanGuid
     * @param \patest\StructType\GetEventPricing_Request $eventPricingRequest
     * @param bool $includeEventPricing
     * @param bool $includeSeatInventoryDetails
     * @param bool $includeTransactionDetails
     * @param bool $includeSessionInfoIfExists
     * @param bool $includeSeatLevelPrice
     * @param string $showId
     * @param string $hallVersionId
     */
    public function __construct($areaGuid = null, $seatId = null, $seatingPlanGuid = null, \patest\StructType\GetEventPricing_Request $eventPricingRequest = null, $includeEventPricing = null, $includeSeatInventoryDetails = null, $includeTransactionDetails = null, $includeSessionInfoIfExists = null, $includeSeatLevelPrice = null, $showId = null, $hallVersionId = null)
    {
        $this
            ->setAreaGuid($areaGuid)
            ->setSeatId($seatId)
            ->setSeatingPlanGuid($seatingPlanGuid)
            ->setEventPricingRequest($eventPricingRequest)
            ->setIncludeEventPricing($includeEventPricing)
            ->setIncludeSeatInventoryDetails($includeSeatInventoryDetails)
            ->setIncludeTransactionDetails($includeTransactionDetails)
            ->setIncludeSessionInfoIfExists($includeSessionInfoIfExists)
            ->setIncludeSeatLevelPrice($includeSeatLevelPrice)
            ->setShowId($showId)
            ->setHallVersionId($hallVersionId);
    }
    /**
     * Get AreaGuid value
     * @return string|null
     */
    public function getAreaGuid()
    {
        return $this->AreaGuid;
    }
    /**
     * Set AreaGuid value
     * @param string $areaGuid
     * @return \patest\StructType\GetSeatToolTipInfo_Request
     */
    public function setAreaGuid($areaGuid = null)
    {
        // validation for constraint: string
        if (!is_null($areaGuid) && !is_string($areaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaGuid, true), gettype($areaGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaGuid, true)), __LINE__);
        }
        $this->AreaGuid = $areaGuid;
        return $this;
    }
    /**
     * Get SeatId value
     * @return int|null
     */
    public function getSeatId()
    {
        return $this->SeatId;
    }
    /**
     * Set SeatId value
     * @param int $seatId
     * @return \patest\StructType\GetSeatToolTipInfo_Request
     */
    public function setSeatId($seatId = null)
    {
        // validation for constraint: int
        if (!is_null($seatId) && !(is_int($seatId) || ctype_digit($seatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatId, true), gettype($seatId)), __LINE__);
        }
        $this->SeatId = $seatId;
        return $this;
    }
    /**
     * Get SeatingPlanGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingPlanGuid()
    {
        return isset($this->SeatingPlanGuid) ? $this->SeatingPlanGuid : null;
    }
    /**
     * Set SeatingPlanGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatingPlanGuid
     * @return \patest\StructType\GetSeatToolTipInfo_Request
     */
    public function setSeatingPlanGuid($seatingPlanGuid = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanGuid) && !is_string($seatingPlanGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanGuid, true), gettype($seatingPlanGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanGuid, true)), __LINE__);
        }
        if (is_null($seatingPlanGuid) || (is_array($seatingPlanGuid) && empty($seatingPlanGuid))) {
            unset($this->SeatingPlanGuid);
        } else {
            $this->SeatingPlanGuid = $seatingPlanGuid;
        }
        return $this;
    }
    /**
     * Get EventPricingRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GetEventPricing_Request|null
     */
    public function getEventPricingRequest()
    {
        return isset($this->EventPricingRequest) ? $this->EventPricingRequest : null;
    }
    /**
     * Set EventPricingRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GetEventPricing_Request $eventPricingRequest
     * @return \patest\StructType\GetSeatToolTipInfo_Request
     */
    public function setEventPricingRequest(\patest\StructType\GetEventPricing_Request $eventPricingRequest = null)
    {
        if (is_null($eventPricingRequest) || (is_array($eventPricingRequest) && empty($eventPricingRequest))) {
            unset($this->EventPricingRequest);
        } else {
            $this->EventPricingRequest = $eventPricingRequest;
        }
        return $this;
    }
    /**
     * Get IncludeEventPricing value
     * @return bool|null
     */
    public function getIncludeEventPricing()
    {
        return $this->IncludeEventPricing;
    }
    /**
     * Set IncludeEventPricing value
     * @param bool $includeEventPricing
     * @return \patest\StructType\GetSeatToolTipInfo_Request
     */
    public function setIncludeEventPricing($includeEventPricing = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeEventPricing) && !is_bool($includeEventPricing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeEventPricing, true), gettype($includeEventPricing)), __LINE__);
        }
        $this->IncludeEventPricing = $includeEventPricing;
        return $this;
    }
    /**
     * Get IncludeSeatInventoryDetails value
     * @return bool|null
     */
    public function getIncludeSeatInventoryDetails()
    {
        return $this->IncludeSeatInventoryDetails;
    }
    /**
     * Set IncludeSeatInventoryDetails value
     * @param bool $includeSeatInventoryDetails
     * @return \patest\StructType\GetSeatToolTipInfo_Request
     */
    public function setIncludeSeatInventoryDetails($includeSeatInventoryDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSeatInventoryDetails) && !is_bool($includeSeatInventoryDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeSeatInventoryDetails, true), gettype($includeSeatInventoryDetails)), __LINE__);
        }
        $this->IncludeSeatInventoryDetails = $includeSeatInventoryDetails;
        return $this;
    }
    /**
     * Get IncludeTransactionDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeTransactionDetails()
    {
        return isset($this->IncludeTransactionDetails) ? $this->IncludeTransactionDetails : null;
    }
    /**
     * Set IncludeTransactionDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeTransactionDetails
     * @return \patest\StructType\GetSeatToolTipInfo_Request
     */
    public function setIncludeTransactionDetails($includeTransactionDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTransactionDetails) && !is_bool($includeTransactionDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeTransactionDetails, true), gettype($includeTransactionDetails)), __LINE__);
        }
        if (is_null($includeTransactionDetails) || (is_array($includeTransactionDetails) && empty($includeTransactionDetails))) {
            unset($this->IncludeTransactionDetails);
        } else {
            $this->IncludeTransactionDetails = $includeTransactionDetails;
        }
        return $this;
    }
    /**
     * Get IncludeSessionInfoIfExists value
     * @return bool|null
     */
    public function getIncludeSessionInfoIfExists()
    {
        return $this->IncludeSessionInfoIfExists;
    }
    /**
     * Set IncludeSessionInfoIfExists value
     * @param bool $includeSessionInfoIfExists
     * @return \patest\StructType\GetSeatToolTipInfo_Request
     */
    public function setIncludeSessionInfoIfExists($includeSessionInfoIfExists = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSessionInfoIfExists) && !is_bool($includeSessionInfoIfExists)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeSessionInfoIfExists, true), gettype($includeSessionInfoIfExists)), __LINE__);
        }
        $this->IncludeSessionInfoIfExists = $includeSessionInfoIfExists;
        return $this;
    }
    /**
     * Get IncludeSeatLevelPrice value
     * @return bool|null
     */
    public function getIncludeSeatLevelPrice()
    {
        return $this->IncludeSeatLevelPrice;
    }
    /**
     * Set IncludeSeatLevelPrice value
     * @param bool $includeSeatLevelPrice
     * @return \patest\StructType\GetSeatToolTipInfo_Request
     */
    public function setIncludeSeatLevelPrice($includeSeatLevelPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSeatLevelPrice) && !is_bool($includeSeatLevelPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeSeatLevelPrice, true), gettype($includeSeatLevelPrice)), __LINE__);
        }
        $this->IncludeSeatLevelPrice = $includeSeatLevelPrice;
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\GetSeatToolTipInfo_Request
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get HallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionId()
    {
        return isset($this->HallVersionId) ? $this->HallVersionId : null;
    }
    /**
     * Set HallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionId
     * @return \patest\StructType\GetSeatToolTipInfo_Request
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        if (is_null($hallVersionId) || (is_array($hallVersionId) && empty($hallVersionId))) {
            unset($this->HallVersionId);
        } else {
            $this->HallVersionId = $hallVersionId;
        }
        return $this;
    }
}
