<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSalePoints-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetSalePoints-Request
 * @subpackage Structs
 */
class GetSalePoints_Request extends ExtensibleDataContract
{
    /**
     * The BelongingToTheseSites
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $BelongingToTheseSites;
    /**
     * The ExplicitAuthentication
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ExplicitAuthentication;
    /**
     * The GetInactiveToo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GetInactiveToo;
    /**
     * The TenantCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TenantCompanyId;
    /**
     * The UserLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserLogin;
    /**
     * The UserPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserPassword;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for GetSalePoints-Request
     * @uses GetSalePoints_Request::setBelongingToTheseSites()
     * @uses GetSalePoints_Request::setExplicitAuthentication()
     * @uses GetSalePoints_Request::setGetInactiveToo()
     * @uses GetSalePoints_Request::setTenantCompanyId()
     * @uses GetSalePoints_Request::setUserLogin()
     * @uses GetSalePoints_Request::setUserPassword()
     * @uses GetSalePoints_Request::setUserId()
     * @param \patest\ArrayType\ArrayOfguid $belongingToTheseSites
     * @param bool $explicitAuthentication
     * @param bool $getInactiveToo
     * @param int $tenantCompanyId
     * @param string $userLogin
     * @param string $userPassword
     * @param string $userId
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $belongingToTheseSites = null, $explicitAuthentication = null, $getInactiveToo = null, $tenantCompanyId = null, $userLogin = null, $userPassword = null, $userId = null)
    {
        $this
            ->setBelongingToTheseSites($belongingToTheseSites)
            ->setExplicitAuthentication($explicitAuthentication)
            ->setGetInactiveToo($getInactiveToo)
            ->setTenantCompanyId($tenantCompanyId)
            ->setUserLogin($userLogin)
            ->setUserPassword($userPassword)
            ->setUserId($userId);
    }
    /**
     * Get BelongingToTheseSites value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getBelongingToTheseSites()
    {
        return isset($this->BelongingToTheseSites) ? $this->BelongingToTheseSites : null;
    }
    /**
     * Set BelongingToTheseSites value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $belongingToTheseSites
     * @return \patest\StructType\GetSalePoints_Request
     */
    public function setBelongingToTheseSites(\patest\ArrayType\ArrayOfguid $belongingToTheseSites = null)
    {
        if (is_null($belongingToTheseSites) || (is_array($belongingToTheseSites) && empty($belongingToTheseSites))) {
            unset($this->BelongingToTheseSites);
        } else {
            $this->BelongingToTheseSites = $belongingToTheseSites;
        }
        return $this;
    }
    /**
     * Get ExplicitAuthentication value
     * @return bool|null
     */
    public function getExplicitAuthentication()
    {
        return $this->ExplicitAuthentication;
    }
    /**
     * Set ExplicitAuthentication value
     * @param bool $explicitAuthentication
     * @return \patest\StructType\GetSalePoints_Request
     */
    public function setExplicitAuthentication($explicitAuthentication = null)
    {
        // validation for constraint: boolean
        if (!is_null($explicitAuthentication) && !is_bool($explicitAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($explicitAuthentication, true), gettype($explicitAuthentication)), __LINE__);
        }
        $this->ExplicitAuthentication = $explicitAuthentication;
        return $this;
    }
    /**
     * Get GetInactiveToo value
     * @return bool|null
     */
    public function getGetInactiveToo()
    {
        return $this->GetInactiveToo;
    }
    /**
     * Set GetInactiveToo value
     * @param bool $getInactiveToo
     * @return \patest\StructType\GetSalePoints_Request
     */
    public function setGetInactiveToo($getInactiveToo = null)
    {
        // validation for constraint: boolean
        if (!is_null($getInactiveToo) && !is_bool($getInactiveToo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getInactiveToo, true), gettype($getInactiveToo)), __LINE__);
        }
        $this->GetInactiveToo = $getInactiveToo;
        return $this;
    }
    /**
     * Get TenantCompanyId value
     * @return int|null
     */
    public function getTenantCompanyId()
    {
        return $this->TenantCompanyId;
    }
    /**
     * Set TenantCompanyId value
     * @param int $tenantCompanyId
     * @return \patest\StructType\GetSalePoints_Request
     */
    public function setTenantCompanyId($tenantCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($tenantCompanyId) && !(is_int($tenantCompanyId) || ctype_digit($tenantCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tenantCompanyId, true), gettype($tenantCompanyId)), __LINE__);
        }
        $this->TenantCompanyId = $tenantCompanyId;
        return $this;
    }
    /**
     * Get UserLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLogin()
    {
        return isset($this->UserLogin) ? $this->UserLogin : null;
    }
    /**
     * Set UserLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userLogin
     * @return \patest\StructType\GetSalePoints_Request
     */
    public function setUserLogin($userLogin = null)
    {
        // validation for constraint: string
        if (!is_null($userLogin) && !is_string($userLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLogin, true), gettype($userLogin)), __LINE__);
        }
        if (is_null($userLogin) || (is_array($userLogin) && empty($userLogin))) {
            unset($this->UserLogin);
        } else {
            $this->UserLogin = $userLogin;
        }
        return $this;
    }
    /**
     * Get UserPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserPassword()
    {
        return isset($this->UserPassword) ? $this->UserPassword : null;
    }
    /**
     * Set UserPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userPassword
     * @return \patest\StructType\GetSalePoints_Request
     */
    public function setUserPassword($userPassword = null)
    {
        // validation for constraint: string
        if (!is_null($userPassword) && !is_string($userPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userPassword, true), gettype($userPassword)), __LINE__);
        }
        if (is_null($userPassword) || (is_array($userPassword) && empty($userPassword))) {
            unset($this->UserPassword);
        } else {
            $this->UserPassword = $userPassword;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\GetSalePoints_Request
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
