<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPaymentPlanDefaults-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetPaymentPlanDefaults-Request
 * @subpackage Structs
 */
class GetPaymentPlanDefaults_Request extends AbstractStructBase
{
    /**
     * The DownPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DownPayment;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $TotalAmount;
    /**
     * Constructor method for GetPaymentPlanDefaults-Request
     * @uses GetPaymentPlanDefaults_Request::setDownPayment()
     * @uses GetPaymentPlanDefaults_Request::setPaymentMethodId()
     * @uses GetPaymentPlanDefaults_Request::setTotalAmount()
     * @param \patest\StructType\Money $downPayment
     * @param string $paymentMethodId
     * @param \patest\StructType\Money $totalAmount
     */
    public function __construct(\patest\StructType\Money $downPayment = null, $paymentMethodId = null, \patest\StructType\Money $totalAmount = null)
    {
        $this
            ->setDownPayment($downPayment)
            ->setPaymentMethodId($paymentMethodId)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get DownPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDownPayment()
    {
        return isset($this->DownPayment) ? $this->DownPayment : null;
    }
    /**
     * Set DownPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $downPayment
     * @return \patest\StructType\GetPaymentPlanDefaults_Request
     */
    public function setDownPayment(\patest\StructType\Money $downPayment = null)
    {
        if (is_null($downPayment) || (is_array($downPayment) && empty($downPayment))) {
            unset($this->DownPayment);
        } else {
            $this->DownPayment = $downPayment;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->PaymentMethodId;
    }
    /**
     * Set PaymentMethodId value
     * @param string $paymentMethodId
     * @return \patest\StructType\GetPaymentPlanDefaults_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        $this->PaymentMethodId = $paymentMethodId;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param \patest\StructType\Money $totalAmount
     * @return \patest\StructType\GetPaymentPlanDefaults_Request
     */
    public function setTotalAmount(\patest\StructType\Money $totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
}
