<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetExtraPromptElementAvailablProductsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetExtraPromptElementAvailablProductsRequest
 * @subpackage Structs
 */
class GetExtraPromptElementAvailablProductsRequest extends AbstractStructBase
{
    /**
     * The ElementsIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ElementsIds;
    /**
     * The LinkingProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LinkingProductId;
    /**
     * The PromptId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PromptId;
    /**
     * Constructor method for GetExtraPromptElementAvailablProductsRequest
     * @uses GetExtraPromptElementAvailablProductsRequest::setElementsIds()
     * @uses GetExtraPromptElementAvailablProductsRequest::setLinkingProductId()
     * @uses GetExtraPromptElementAvailablProductsRequest::setPromptId()
     * @param \patest\ArrayType\ArrayOfguid $elementsIds
     * @param string $linkingProductId
     * @param string $promptId
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $elementsIds = null, $linkingProductId = null, $promptId = null)
    {
        $this
            ->setElementsIds($elementsIds)
            ->setLinkingProductId($linkingProductId)
            ->setPromptId($promptId);
    }
    /**
     * Get ElementsIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getElementsIds()
    {
        return isset($this->ElementsIds) ? $this->ElementsIds : null;
    }
    /**
     * Set ElementsIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $elementsIds
     * @return \patest\StructType\GetExtraPromptElementAvailablProductsRequest
     */
    public function setElementsIds(\patest\ArrayType\ArrayOfguid $elementsIds = null)
    {
        if (is_null($elementsIds) || (is_array($elementsIds) && empty($elementsIds))) {
            unset($this->ElementsIds);
        } else {
            $this->ElementsIds = $elementsIds;
        }
        return $this;
    }
    /**
     * Get LinkingProductId value
     * @return string|null
     */
    public function getLinkingProductId()
    {
        return $this->LinkingProductId;
    }
    /**
     * Set LinkingProductId value
     * @param string $linkingProductId
     * @return \patest\StructType\GetExtraPromptElementAvailablProductsRequest
     */
    public function setLinkingProductId($linkingProductId = null)
    {
        // validation for constraint: string
        if (!is_null($linkingProductId) && !is_string($linkingProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkingProductId, true), gettype($linkingProductId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($linkingProductId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $linkingProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($linkingProductId, true)), __LINE__);
        }
        $this->LinkingProductId = $linkingProductId;
        return $this;
    }
    /**
     * Get PromptId value
     * @return string|null
     */
    public function getPromptId()
    {
        return $this->PromptId;
    }
    /**
     * Set PromptId value
     * @param string $promptId
     * @return \patest\StructType\GetExtraPromptElementAvailablProductsRequest
     */
    public function setPromptId($promptId = null)
    {
        // validation for constraint: string
        if (!is_null($promptId) && !is_string($promptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promptId, true), gettype($promptId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($promptId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $promptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($promptId, true)), __LINE__);
        }
        $this->PromptId = $promptId;
        return $this;
    }
}
