<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDefaultBundleContentRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetDefaultBundleContentRequest
 * @subpackage Structs
 */
class GetDefaultBundleContentRequest extends ExtensibleDataContract
{
    /**
     * The BundleDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BundleDate;
    /**
     * The BundleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BundleId;
    /**
     * The QuantityOfBundles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuantityOfBundles;
    /**
     * The QuantityPerPriceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidint
     */
    public $QuantityPerPriceType;
    /**
     * Constructor method for GetDefaultBundleContentRequest
     * @uses GetDefaultBundleContentRequest::setBundleDate()
     * @uses GetDefaultBundleContentRequest::setBundleId()
     * @uses GetDefaultBundleContentRequest::setQuantityOfBundles()
     * @uses GetDefaultBundleContentRequest::setQuantityPerPriceType()
     * @param string $bundleDate
     * @param string $bundleId
     * @param int $quantityOfBundles
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidint $quantityPerPriceType
     */
    public function __construct($bundleDate = null, $bundleId = null, $quantityOfBundles = null, \patest\ArrayType\ArrayOfKeyValueOfguidint $quantityPerPriceType = null)
    {
        $this
            ->setBundleDate($bundleDate)
            ->setBundleId($bundleId)
            ->setQuantityOfBundles($quantityOfBundles)
            ->setQuantityPerPriceType($quantityPerPriceType);
    }
    /**
     * Get BundleDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBundleDate()
    {
        return isset($this->BundleDate) ? $this->BundleDate : null;
    }
    /**
     * Set BundleDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bundleDate
     * @return \patest\StructType\GetDefaultBundleContentRequest
     */
    public function setBundleDate($bundleDate = null)
    {
        // validation for constraint: string
        if (!is_null($bundleDate) && !is_string($bundleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleDate, true), gettype($bundleDate)), __LINE__);
        }
        if (is_null($bundleDate) || (is_array($bundleDate) && empty($bundleDate))) {
            unset($this->BundleDate);
        } else {
            $this->BundleDate = $bundleDate;
        }
        return $this;
    }
    /**
     * Get BundleId value
     * @return string|null
     */
    public function getBundleId()
    {
        return $this->BundleId;
    }
    /**
     * Set BundleId value
     * @param string $bundleId
     * @return \patest\StructType\GetDefaultBundleContentRequest
     */
    public function setBundleId($bundleId = null)
    {
        // validation for constraint: string
        if (!is_null($bundleId) && !is_string($bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleId, true), gettype($bundleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bundleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bundleId, true)), __LINE__);
        }
        $this->BundleId = $bundleId;
        return $this;
    }
    /**
     * Get QuantityOfBundles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantityOfBundles()
    {
        return isset($this->QuantityOfBundles) ? $this->QuantityOfBundles : null;
    }
    /**
     * Set QuantityOfBundles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantityOfBundles
     * @return \patest\StructType\GetDefaultBundleContentRequest
     */
    public function setQuantityOfBundles($quantityOfBundles = null)
    {
        // validation for constraint: int
        if (!is_null($quantityOfBundles) && !(is_int($quantityOfBundles) || ctype_digit($quantityOfBundles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityOfBundles, true), gettype($quantityOfBundles)), __LINE__);
        }
        if (is_null($quantityOfBundles) || (is_array($quantityOfBundles) && empty($quantityOfBundles))) {
            unset($this->QuantityOfBundles);
        } else {
            $this->QuantityOfBundles = $quantityOfBundles;
        }
        return $this;
    }
    /**
     * Get QuantityPerPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidint|null
     */
    public function getQuantityPerPriceType()
    {
        return isset($this->QuantityPerPriceType) ? $this->QuantityPerPriceType : null;
    }
    /**
     * Set QuantityPerPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidint $quantityPerPriceType
     * @return \patest\StructType\GetDefaultBundleContentRequest
     */
    public function setQuantityPerPriceType(\patest\ArrayType\ArrayOfKeyValueOfguidint $quantityPerPriceType = null)
    {
        if (is_null($quantityPerPriceType) || (is_array($quantityPerPriceType) && empty($quantityPerPriceType))) {
            unset($this->QuantityPerPriceType);
        } else {
            $this->QuantityPerPriceType = $quantityPerPriceType;
        }
        return $this;
    }
}
