<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetClientEventsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetClientEventsRequest
 * @subpackage Structs
 */
class GetClientEventsRequest extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The FromEventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromEventDate;
    /**
     * The FromEventLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FromEventLocalId;
    /**
     * The GetPastEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GetPastEvents;
    /**
     * The IncludeGenres
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeGenres;
    /**
     * The IncludeNfc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeNfc;
    /**
     * The IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged;
    /**
     * The IncludeTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeTickets;
    /**
     * The IncludeTicketsOfSpecificRelationshipType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IncludeTicketsOfSpecificRelationshipType;
    /**
     * The IncludeTicketsOfStronglyConnectedOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeTicketsOfStronglyConnectedOwners;
    /**
     * The MaxPageSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxPageSize;
    /**
     * The StronglyRelatedClientsMaxAgeFilterForTicketList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StronglyRelatedClientsMaxAgeFilterForTicketList;
    /**
     * Constructor method for GetClientEventsRequest
     * @uses GetClientEventsRequest::setClientId()
     * @uses GetClientEventsRequest::setFromEventDate()
     * @uses GetClientEventsRequest::setFromEventLocalId()
     * @uses GetClientEventsRequest::setGetPastEvents()
     * @uses GetClientEventsRequest::setIncludeGenres()
     * @uses GetClientEventsRequest::setIncludeNfc()
     * @uses GetClientEventsRequest::setIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged()
     * @uses GetClientEventsRequest::setIncludeTickets()
     * @uses GetClientEventsRequest::setIncludeTicketsOfSpecificRelationshipType()
     * @uses GetClientEventsRequest::setIncludeTicketsOfStronglyConnectedOwners()
     * @uses GetClientEventsRequest::setMaxPageSize()
     * @uses GetClientEventsRequest::setStronglyRelatedClientsMaxAgeFilterForTicketList()
     * @param string $clientId
     * @param string $fromEventDate
     * @param int $fromEventLocalId
     * @param bool $getPastEvents
     * @param bool $includeGenres
     * @param bool $includeNfc
     * @param bool $includePurchasedByClientNonForwardedOwnedByRelatedUnderaged
     * @param bool $includeTickets
     * @param string $includeTicketsOfSpecificRelationshipType
     * @param bool $includeTicketsOfStronglyConnectedOwners
     * @param int $maxPageSize
     * @param int $stronglyRelatedClientsMaxAgeFilterForTicketList
     */
    public function __construct($clientId = null, $fromEventDate = null, $fromEventLocalId = null, $getPastEvents = null, $includeGenres = null, $includeNfc = null, $includePurchasedByClientNonForwardedOwnedByRelatedUnderaged = null, $includeTickets = null, $includeTicketsOfSpecificRelationshipType = null, $includeTicketsOfStronglyConnectedOwners = null, $maxPageSize = null, $stronglyRelatedClientsMaxAgeFilterForTicketList = null)
    {
        $this
            ->setClientId($clientId)
            ->setFromEventDate($fromEventDate)
            ->setFromEventLocalId($fromEventLocalId)
            ->setGetPastEvents($getPastEvents)
            ->setIncludeGenres($includeGenres)
            ->setIncludeNfc($includeNfc)
            ->setIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged)
            ->setIncludeTickets($includeTickets)
            ->setIncludeTicketsOfSpecificRelationshipType($includeTicketsOfSpecificRelationshipType)
            ->setIncludeTicketsOfStronglyConnectedOwners($includeTicketsOfStronglyConnectedOwners)
            ->setMaxPageSize($maxPageSize)
            ->setStronglyRelatedClientsMaxAgeFilterForTicketList($stronglyRelatedClientsMaxAgeFilterForTicketList);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\GetClientEventsRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get FromEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromEventDate()
    {
        return isset($this->FromEventDate) ? $this->FromEventDate : null;
    }
    /**
     * Set FromEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromEventDate
     * @return \patest\StructType\GetClientEventsRequest
     */
    public function setFromEventDate($fromEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromEventDate) && !is_string($fromEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromEventDate, true), gettype($fromEventDate)), __LINE__);
        }
        if (is_null($fromEventDate) || (is_array($fromEventDate) && empty($fromEventDate))) {
            unset($this->FromEventDate);
        } else {
            $this->FromEventDate = $fromEventDate;
        }
        return $this;
    }
    /**
     * Get FromEventLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromEventLocalId()
    {
        return isset($this->FromEventLocalId) ? $this->FromEventLocalId : null;
    }
    /**
     * Set FromEventLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromEventLocalId
     * @return \patest\StructType\GetClientEventsRequest
     */
    public function setFromEventLocalId($fromEventLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($fromEventLocalId) && !(is_int($fromEventLocalId) || ctype_digit($fromEventLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromEventLocalId, true), gettype($fromEventLocalId)), __LINE__);
        }
        if (is_null($fromEventLocalId) || (is_array($fromEventLocalId) && empty($fromEventLocalId))) {
            unset($this->FromEventLocalId);
        } else {
            $this->FromEventLocalId = $fromEventLocalId;
        }
        return $this;
    }
    /**
     * Get GetPastEvents value
     * @return bool|null
     */
    public function getGetPastEvents()
    {
        return $this->GetPastEvents;
    }
    /**
     * Set GetPastEvents value
     * @param bool $getPastEvents
     * @return \patest\StructType\GetClientEventsRequest
     */
    public function setGetPastEvents($getPastEvents = null)
    {
        // validation for constraint: boolean
        if (!is_null($getPastEvents) && !is_bool($getPastEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getPastEvents, true), gettype($getPastEvents)), __LINE__);
        }
        $this->GetPastEvents = $getPastEvents;
        return $this;
    }
    /**
     * Get IncludeGenres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeGenres()
    {
        return isset($this->IncludeGenres) ? $this->IncludeGenres : null;
    }
    /**
     * Set IncludeGenres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeGenres
     * @return \patest\StructType\GetClientEventsRequest
     */
    public function setIncludeGenres($includeGenres = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeGenres) && !is_bool($includeGenres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeGenres, true), gettype($includeGenres)), __LINE__);
        }
        if (is_null($includeGenres) || (is_array($includeGenres) && empty($includeGenres))) {
            unset($this->IncludeGenres);
        } else {
            $this->IncludeGenres = $includeGenres;
        }
        return $this;
    }
    /**
     * Get IncludeNfc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeNfc()
    {
        return isset($this->IncludeNfc) ? $this->IncludeNfc : null;
    }
    /**
     * Set IncludeNfc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeNfc
     * @return \patest\StructType\GetClientEventsRequest
     */
    public function setIncludeNfc($includeNfc = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeNfc) && !is_bool($includeNfc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeNfc, true), gettype($includeNfc)), __LINE__);
        }
        if (is_null($includeNfc) || (is_array($includeNfc) && empty($includeNfc))) {
            unset($this->IncludeNfc);
        } else {
            $this->IncludeNfc = $includeNfc;
        }
        return $this;
    }
    /**
     * Get IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged()
    {
        return isset($this->IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged) ? $this->IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged : null;
    }
    /**
     * Set IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includePurchasedByClientNonForwardedOwnedByRelatedUnderaged
     * @return \patest\StructType\GetClientEventsRequest
     */
    public function setIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged) && !is_bool($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged, true), gettype($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged)), __LINE__);
        }
        if (is_null($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged) || (is_array($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged) && empty($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged))) {
            unset($this->IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged);
        } else {
            $this->IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged = $includePurchasedByClientNonForwardedOwnedByRelatedUnderaged;
        }
        return $this;
    }
    /**
     * Get IncludeTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeTickets()
    {
        return isset($this->IncludeTickets) ? $this->IncludeTickets : null;
    }
    /**
     * Set IncludeTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeTickets
     * @return \patest\StructType\GetClientEventsRequest
     */
    public function setIncludeTickets($includeTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTickets) && !is_bool($includeTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeTickets, true), gettype($includeTickets)), __LINE__);
        }
        if (is_null($includeTickets) || (is_array($includeTickets) && empty($includeTickets))) {
            unset($this->IncludeTickets);
        } else {
            $this->IncludeTickets = $includeTickets;
        }
        return $this;
    }
    /**
     * Get IncludeTicketsOfSpecificRelationshipType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeTicketsOfSpecificRelationshipType()
    {
        return isset($this->IncludeTicketsOfSpecificRelationshipType) ? $this->IncludeTicketsOfSpecificRelationshipType : null;
    }
    /**
     * Set IncludeTicketsOfSpecificRelationshipType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $includeTicketsOfSpecificRelationshipType
     * @return \patest\StructType\GetClientEventsRequest
     */
    public function setIncludeTicketsOfSpecificRelationshipType($includeTicketsOfSpecificRelationshipType = null)
    {
        // validation for constraint: string
        if (!is_null($includeTicketsOfSpecificRelationshipType) && !is_string($includeTicketsOfSpecificRelationshipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($includeTicketsOfSpecificRelationshipType, true), gettype($includeTicketsOfSpecificRelationshipType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($includeTicketsOfSpecificRelationshipType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $includeTicketsOfSpecificRelationshipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($includeTicketsOfSpecificRelationshipType, true)), __LINE__);
        }
        if (is_null($includeTicketsOfSpecificRelationshipType) || (is_array($includeTicketsOfSpecificRelationshipType) && empty($includeTicketsOfSpecificRelationshipType))) {
            unset($this->IncludeTicketsOfSpecificRelationshipType);
        } else {
            $this->IncludeTicketsOfSpecificRelationshipType = $includeTicketsOfSpecificRelationshipType;
        }
        return $this;
    }
    /**
     * Get IncludeTicketsOfStronglyConnectedOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeTicketsOfStronglyConnectedOwners()
    {
        return isset($this->IncludeTicketsOfStronglyConnectedOwners) ? $this->IncludeTicketsOfStronglyConnectedOwners : null;
    }
    /**
     * Set IncludeTicketsOfStronglyConnectedOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeTicketsOfStronglyConnectedOwners
     * @return \patest\StructType\GetClientEventsRequest
     */
    public function setIncludeTicketsOfStronglyConnectedOwners($includeTicketsOfStronglyConnectedOwners = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTicketsOfStronglyConnectedOwners) && !is_bool($includeTicketsOfStronglyConnectedOwners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeTicketsOfStronglyConnectedOwners, true), gettype($includeTicketsOfStronglyConnectedOwners)), __LINE__);
        }
        if (is_null($includeTicketsOfStronglyConnectedOwners) || (is_array($includeTicketsOfStronglyConnectedOwners) && empty($includeTicketsOfStronglyConnectedOwners))) {
            unset($this->IncludeTicketsOfStronglyConnectedOwners);
        } else {
            $this->IncludeTicketsOfStronglyConnectedOwners = $includeTicketsOfStronglyConnectedOwners;
        }
        return $this;
    }
    /**
     * Get MaxPageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxPageSize()
    {
        return isset($this->MaxPageSize) ? $this->MaxPageSize : null;
    }
    /**
     * Set MaxPageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxPageSize
     * @return \patest\StructType\GetClientEventsRequest
     */
    public function setMaxPageSize($maxPageSize = null)
    {
        // validation for constraint: int
        if (!is_null($maxPageSize) && !(is_int($maxPageSize) || ctype_digit($maxPageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxPageSize, true), gettype($maxPageSize)), __LINE__);
        }
        if (is_null($maxPageSize) || (is_array($maxPageSize) && empty($maxPageSize))) {
            unset($this->MaxPageSize);
        } else {
            $this->MaxPageSize = $maxPageSize;
        }
        return $this;
    }
    /**
     * Get StronglyRelatedClientsMaxAgeFilterForTicketList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStronglyRelatedClientsMaxAgeFilterForTicketList()
    {
        return isset($this->StronglyRelatedClientsMaxAgeFilterForTicketList) ? $this->StronglyRelatedClientsMaxAgeFilterForTicketList : null;
    }
    /**
     * Set StronglyRelatedClientsMaxAgeFilterForTicketList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $stronglyRelatedClientsMaxAgeFilterForTicketList
     * @return \patest\StructType\GetClientEventsRequest
     */
    public function setStronglyRelatedClientsMaxAgeFilterForTicketList($stronglyRelatedClientsMaxAgeFilterForTicketList = null)
    {
        // validation for constraint: int
        if (!is_null($stronglyRelatedClientsMaxAgeFilterForTicketList) && !(is_int($stronglyRelatedClientsMaxAgeFilterForTicketList) || ctype_digit($stronglyRelatedClientsMaxAgeFilterForTicketList))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stronglyRelatedClientsMaxAgeFilterForTicketList, true), gettype($stronglyRelatedClientsMaxAgeFilterForTicketList)), __LINE__);
        }
        if (is_null($stronglyRelatedClientsMaxAgeFilterForTicketList) || (is_array($stronglyRelatedClientsMaxAgeFilterForTicketList) && empty($stronglyRelatedClientsMaxAgeFilterForTicketList))) {
            unset($this->StronglyRelatedClientsMaxAgeFilterForTicketList);
        } else {
            $this->StronglyRelatedClientsMaxAgeFilterForTicketList = $stronglyRelatedClientsMaxAgeFilterForTicketList;
        }
        return $this;
    }
}
