<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCaptionsByKeysRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetCaptionsByKeysRequest
 * @subpackage Structs
 */
class GetCaptionsByKeysRequest extends ExtensibleDataContract
{
    /**
     * The Ids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $Ids;
    /**
     * The Keys
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $Keys;
    /**
     * The KeysPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KeysPrefix;
    /**
     * Constructor method for GetCaptionsByKeysRequest
     * @uses GetCaptionsByKeysRequest::setIds()
     * @uses GetCaptionsByKeysRequest::setKeys()
     * @uses GetCaptionsByKeysRequest::setKeysPrefix()
     * @param \patest\ArrayType\ArrayOfint $ids
     * @param \patest\ArrayType\ArrayOfstring $keys
     * @param string $keysPrefix
     */
    public function __construct(\patest\ArrayType\ArrayOfint $ids = null, \patest\ArrayType\ArrayOfstring $keys = null, $keysPrefix = null)
    {
        $this
            ->setIds($ids)
            ->setKeys($keys)
            ->setKeysPrefix($keysPrefix);
    }
    /**
     * Get Ids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getIds()
    {
        return isset($this->Ids) ? $this->Ids : null;
    }
    /**
     * Set Ids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $ids
     * @return \patest\StructType\GetCaptionsByKeysRequest
     */
    public function setIds(\patest\ArrayType\ArrayOfint $ids = null)
    {
        if (is_null($ids) || (is_array($ids) && empty($ids))) {
            unset($this->Ids);
        } else {
            $this->Ids = $ids;
        }
        return $this;
    }
    /**
     * Get Keys value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getKeys()
    {
        return isset($this->Keys) ? $this->Keys : null;
    }
    /**
     * Set Keys value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $keys
     * @return \patest\StructType\GetCaptionsByKeysRequest
     */
    public function setKeys(\patest\ArrayType\ArrayOfstring $keys = null)
    {
        if (is_null($keys) || (is_array($keys) && empty($keys))) {
            unset($this->Keys);
        } else {
            $this->Keys = $keys;
        }
        return $this;
    }
    /**
     * Get KeysPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKeysPrefix()
    {
        return isset($this->KeysPrefix) ? $this->KeysPrefix : null;
    }
    /**
     * Set KeysPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $keysPrefix
     * @return \patest\StructType\GetCaptionsByKeysRequest
     */
    public function setKeysPrefix($keysPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($keysPrefix) && !is_string($keysPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keysPrefix, true), gettype($keysPrefix)), __LINE__);
        }
        if (is_null($keysPrefix) || (is_array($keysPrefix) && empty($keysPrefix))) {
            unset($this->KeysPrefix);
        } else {
            $this->KeysPrefix = $keysPrefix;
        }
        return $this;
    }
}
