<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailablePrintOptionsForBasketSale-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAvailablePrintOptionsForBasketSale-Request
 * @subpackage Structs
 */
class GetAvailablePrintOptionsForBasketSale_Request extends GetAvailablePrintOptionsBaseRequest
{
    /**
     * The ItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ItemIds;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for GetAvailablePrintOptionsForBasketSale-Request
     * @uses GetAvailablePrintOptionsForBasketSale_Request::setItemIds()
     * @uses GetAvailablePrintOptionsForBasketSale_Request::setTransactionGuid()
     * @param \patest\ArrayType\ArrayOfguid $itemIds
     * @param string $transactionGuid
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $itemIds = null, $transactionGuid = null)
    {
        $this
            ->setItemIds($itemIds)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get ItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getItemIds()
    {
        return isset($this->ItemIds) ? $this->ItemIds : null;
    }
    /**
     * Set ItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $itemIds
     * @return \patest\StructType\GetAvailablePrintOptionsForBasketSale_Request
     */
    public function setItemIds(\patest\ArrayType\ArrayOfguid $itemIds = null)
    {
        if (is_null($itemIds) || (is_array($itemIds) && empty($itemIds))) {
            unset($this->ItemIds);
        } else {
            $this->ItemIds = $itemIds;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\GetAvailablePrintOptionsForBasketSale_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
}
