<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralAdmissionPrioritySettings StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GeneralAdmissionPrioritySettings
 * @subpackage Structs
 */
class GeneralAdmissionPrioritySettings extends AbstractGeneralAdmissionLayerSettings
{
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Priority;
    /**
     * Constructor method for GeneralAdmissionPrioritySettings
     * @uses GeneralAdmissionPrioritySettings::setPriority()
     * @param int $priority
     */
    public function __construct($priority = null)
    {
        $this
            ->setPriority($priority);
    }
    /**
     * Get Priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \patest\StructType\GeneralAdmissionPrioritySettings
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
}
