<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Foundation.Notifications.Monitoring.Node StructType
 * @subpackage Structs
 */
class Foundation_Notifications_Monitoring_Node extends AnyEntity
{
    /**
     * The Blocked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Blocked;
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Color;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Count;
    /**
     * The FailedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedCount;
    /**
     * The Filtered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Filtered;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Nodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfFoundation_Notifications_Monitoring_Node
     */
    public $Nodes;
    /**
     * The RunAsync
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RunAsync;
    /**
     * The TotalCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalCount;
    /**
     * The TotalFailedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalFailedCount;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Foundation.Notifications.Monitoring.Node
     * @uses Foundation_Notifications_Monitoring_Node::setBlocked()
     * @uses Foundation_Notifications_Monitoring_Node::setColor()
     * @uses Foundation_Notifications_Monitoring_Node::setCount()
     * @uses Foundation_Notifications_Monitoring_Node::setFailedCount()
     * @uses Foundation_Notifications_Monitoring_Node::setFiltered()
     * @uses Foundation_Notifications_Monitoring_Node::setId()
     * @uses Foundation_Notifications_Monitoring_Node::setName()
     * @uses Foundation_Notifications_Monitoring_Node::setNodes()
     * @uses Foundation_Notifications_Monitoring_Node::setRunAsync()
     * @uses Foundation_Notifications_Monitoring_Node::setTotalCount()
     * @uses Foundation_Notifications_Monitoring_Node::setTotalFailedCount()
     * @uses Foundation_Notifications_Monitoring_Node::setType()
     * @param bool $blocked
     * @param string $color
     * @param int $count
     * @param int $failedCount
     * @param bool $filtered
     * @param string $id
     * @param string $name
     * @param \patest\StructType\RecordSetOfFoundation_Notifications_Monitoring_Node $nodes
     * @param bool $runAsync
     * @param int $totalCount
     * @param int $totalFailedCount
     * @param string $type
     */
    public function __construct($blocked = null, $color = null, $count = null, $failedCount = null, $filtered = null, $id = null, $name = null, \patest\StructType\RecordSetOfFoundation_Notifications_Monitoring_Node $nodes = null, $runAsync = null, $totalCount = null, $totalFailedCount = null, $type = null)
    {
        $this
            ->setBlocked($blocked)
            ->setColor($color)
            ->setCount($count)
            ->setFailedCount($failedCount)
            ->setFiltered($filtered)
            ->setId($id)
            ->setName($name)
            ->setNodes($nodes)
            ->setRunAsync($runAsync)
            ->setTotalCount($totalCount)
            ->setTotalFailedCount($totalFailedCount)
            ->setType($type);
    }
    /**
     * Get Blocked value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBlocked()
    {
        return isset($this->Blocked) ? $this->Blocked : null;
    }
    /**
     * Set Blocked value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $blocked
     * @return \patest\StructType\Foundation_Notifications_Monitoring_Node
     */
    public function setBlocked($blocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($blocked) && !is_bool($blocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($blocked, true), gettype($blocked)), __LINE__);
        }
        if (is_null($blocked) || (is_array($blocked) && empty($blocked))) {
            unset($this->Blocked);
        } else {
            $this->Blocked = $blocked;
        }
        return $this;
    }
    /**
     * Get Color value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getColor()
    {
        return isset($this->Color) ? $this->Color : null;
    }
    /**
     * Set Color value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $color
     * @return \patest\StructType\Foundation_Notifications_Monitoring_Node
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        if (is_null($color) || (is_array($color) && empty($color))) {
            unset($this->Color);
        } else {
            $this->Color = $color;
        }
        return $this;
    }
    /**
     * Get Count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCount()
    {
        return isset($this->Count) ? $this->Count : null;
    }
    /**
     * Set Count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $count
     * @return \patest\StructType\Foundation_Notifications_Monitoring_Node
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        if (is_null($count) || (is_array($count) && empty($count))) {
            unset($this->Count);
        } else {
            $this->Count = $count;
        }
        return $this;
    }
    /**
     * Get FailedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedCount()
    {
        return isset($this->FailedCount) ? $this->FailedCount : null;
    }
    /**
     * Set FailedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedCount
     * @return \patest\StructType\Foundation_Notifications_Monitoring_Node
     */
    public function setFailedCount($failedCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedCount) && !(is_int($failedCount) || ctype_digit($failedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedCount, true), gettype($failedCount)), __LINE__);
        }
        if (is_null($failedCount) || (is_array($failedCount) && empty($failedCount))) {
            unset($this->FailedCount);
        } else {
            $this->FailedCount = $failedCount;
        }
        return $this;
    }
    /**
     * Get Filtered value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFiltered()
    {
        return isset($this->Filtered) ? $this->Filtered : null;
    }
    /**
     * Set Filtered value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $filtered
     * @return \patest\StructType\Foundation_Notifications_Monitoring_Node
     */
    public function setFiltered($filtered = null)
    {
        // validation for constraint: boolean
        if (!is_null($filtered) && !is_bool($filtered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filtered, true), gettype($filtered)), __LINE__);
        }
        if (is_null($filtered) || (is_array($filtered) && empty($filtered))) {
            unset($this->Filtered);
        } else {
            $this->Filtered = $filtered;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Foundation_Notifications_Monitoring_Node
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Foundation_Notifications_Monitoring_Node
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Nodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfFoundation_Notifications_Monitoring_Node|null
     */
    public function getNodes()
    {
        return isset($this->Nodes) ? $this->Nodes : null;
    }
    /**
     * Set Nodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfFoundation_Notifications_Monitoring_Node $nodes
     * @return \patest\StructType\Foundation_Notifications_Monitoring_Node
     */
    public function setNodes(\patest\StructType\RecordSetOfFoundation_Notifications_Monitoring_Node $nodes = null)
    {
        if (is_null($nodes) || (is_array($nodes) && empty($nodes))) {
            unset($this->Nodes);
        } else {
            $this->Nodes = $nodes;
        }
        return $this;
    }
    /**
     * Get RunAsync value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRunAsync()
    {
        return isset($this->RunAsync) ? $this->RunAsync : null;
    }
    /**
     * Set RunAsync value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $runAsync
     * @return \patest\StructType\Foundation_Notifications_Monitoring_Node
     */
    public function setRunAsync($runAsync = null)
    {
        // validation for constraint: boolean
        if (!is_null($runAsync) && !is_bool($runAsync)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($runAsync, true), gettype($runAsync)), __LINE__);
        }
        if (is_null($runAsync) || (is_array($runAsync) && empty($runAsync))) {
            unset($this->RunAsync);
        } else {
            $this->RunAsync = $runAsync;
        }
        return $this;
    }
    /**
     * Get TotalCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalCount()
    {
        return isset($this->TotalCount) ? $this->TotalCount : null;
    }
    /**
     * Set TotalCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalCount
     * @return \patest\StructType\Foundation_Notifications_Monitoring_Node
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !(is_int($totalCount) || ctype_digit($totalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCount, true), gettype($totalCount)), __LINE__);
        }
        if (is_null($totalCount) || (is_array($totalCount) && empty($totalCount))) {
            unset($this->TotalCount);
        } else {
            $this->TotalCount = $totalCount;
        }
        return $this;
    }
    /**
     * Get TotalFailedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalFailedCount()
    {
        return isset($this->TotalFailedCount) ? $this->TotalFailedCount : null;
    }
    /**
     * Set TotalFailedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalFailedCount
     * @return \patest\StructType\Foundation_Notifications_Monitoring_Node
     */
    public function setTotalFailedCount($totalFailedCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalFailedCount) && !(is_int($totalFailedCount) || ctype_digit($totalFailedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalFailedCount, true), gettype($totalFailedCount)), __LINE__);
        }
        if (is_null($totalFailedCount) || (is_array($totalFailedCount) && empty($totalFailedCount))) {
            unset($this->TotalFailedCount);
        } else {
            $this->TotalFailedCount = $totalFailedCount;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MonitoringNodeTypes::valueIsValid()
     * @uses \patest\EnumType\MonitoringNodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\Foundation_Notifications_Monitoring_Node
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MonitoringNodeTypes::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MonitoringNodeTypes', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\MonitoringNodeTypes::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
