<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FindPaymentToken-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FindPaymentToken-Response
 * @subpackage Structs
 */
class FindPaymentToken_Response extends ExtensibleDataContract
{
    /**
     * The PaymentToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentToken;
    /**
     * Constructor method for FindPaymentToken-Response
     * @uses FindPaymentToken_Response::setPaymentToken()
     * @param string $paymentToken
     */
    public function __construct($paymentToken = null)
    {
        $this
            ->setPaymentToken($paymentToken);
    }
    /**
     * Get PaymentToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentToken()
    {
        return isset($this->PaymentToken) ? $this->PaymentToken : null;
    }
    /**
     * Set PaymentToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentToken
     * @return \patest\StructType\FindPaymentToken_Response
     */
    public function setPaymentToken($paymentToken = null)
    {
        // validation for constraint: string
        if (!is_null($paymentToken) && !is_string($paymentToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentToken, true), gettype($paymentToken)), __LINE__);
        }
        if (is_null($paymentToken) || (is_array($paymentToken) && empty($paymentToken))) {
            unset($this->PaymentToken);
        } else {
            $this->PaymentToken = $paymentToken;
        }
        return $this;
    }
}
