<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FindPaymentToken-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FindPaymentToken-Request
 * @subpackage Structs
 */
class FindPaymentToken_Request extends ExtensibleDataContract
{
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentServerSessionCookie
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentServerSessionCookie;
    /**
     * Constructor method for FindPaymentToken-Request
     * @uses FindPaymentToken_Request::setPaymentMethodId()
     * @uses FindPaymentToken_Request::setPaymentServerSessionCookie()
     * @param string $paymentMethodId
     * @param string $paymentServerSessionCookie
     */
    public function __construct($paymentMethodId = null, $paymentServerSessionCookie = null)
    {
        $this
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentServerSessionCookie($paymentServerSessionCookie);
    }
    /**
     * Get PaymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->PaymentMethodId;
    }
    /**
     * Set PaymentMethodId value
     * @param string $paymentMethodId
     * @return \patest\StructType\FindPaymentToken_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        $this->PaymentMethodId = $paymentMethodId;
        return $this;
    }
    /**
     * Get PaymentServerSessionCookie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentServerSessionCookie()
    {
        return isset($this->PaymentServerSessionCookie) ? $this->PaymentServerSessionCookie : null;
    }
    /**
     * Set PaymentServerSessionCookie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentServerSessionCookie
     * @return \patest\StructType\FindPaymentToken_Request
     */
    public function setPaymentServerSessionCookie($paymentServerSessionCookie = null)
    {
        // validation for constraint: string
        if (!is_null($paymentServerSessionCookie) && !is_string($paymentServerSessionCookie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentServerSessionCookie, true), gettype($paymentServerSessionCookie)), __LINE__);
        }
        if (is_null($paymentServerSessionCookie) || (is_array($paymentServerSessionCookie) && empty($paymentServerSessionCookie))) {
            unset($this->PaymentServerSessionCookie);
        } else {
            $this->PaymentServerSessionCookie = $paymentServerSessionCookie;
        }
        return $this;
    }
}
