<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterEntity StructType
 * @subpackage Structs
 */
class FilterEntity extends AnyEntity
{
    /**
     * The FilterName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FilterName;
    /**
     * The ModuleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModuleName;
    /**
     * The SavedFilterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SavedFilterId;
    /**
     * The SearchTarget
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SearchTarget;
    /**
     * Constructor method for FilterEntity
     * @uses FilterEntity::setFilterName()
     * @uses FilterEntity::setModuleName()
     * @uses FilterEntity::setSavedFilterId()
     * @uses FilterEntity::setSearchTarget()
     * @param string $filterName
     * @param string $moduleName
     * @param string $savedFilterId
     * @param string $searchTarget
     */
    public function __construct($filterName = null, $moduleName = null, $savedFilterId = null, $searchTarget = null)
    {
        $this
            ->setFilterName($filterName)
            ->setModuleName($moduleName)
            ->setSavedFilterId($savedFilterId)
            ->setSearchTarget($searchTarget);
    }
    /**
     * Get FilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilterName()
    {
        return isset($this->FilterName) ? $this->FilterName : null;
    }
    /**
     * Set FilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filterName
     * @return \patest\StructType\FilterEntity
     */
    public function setFilterName($filterName = null)
    {
        // validation for constraint: string
        if (!is_null($filterName) && !is_string($filterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filterName, true), gettype($filterName)), __LINE__);
        }
        if (is_null($filterName) || (is_array($filterName) && empty($filterName))) {
            unset($this->FilterName);
        } else {
            $this->FilterName = $filterName;
        }
        return $this;
    }
    /**
     * Get ModuleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModuleName()
    {
        return isset($this->ModuleName) ? $this->ModuleName : null;
    }
    /**
     * Set ModuleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moduleName
     * @return \patest\StructType\FilterEntity
     */
    public function setModuleName($moduleName = null)
    {
        // validation for constraint: string
        if (!is_null($moduleName) && !is_string($moduleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moduleName, true), gettype($moduleName)), __LINE__);
        }
        if (is_null($moduleName) || (is_array($moduleName) && empty($moduleName))) {
            unset($this->ModuleName);
        } else {
            $this->ModuleName = $moduleName;
        }
        return $this;
    }
    /**
     * Get SavedFilterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSavedFilterId()
    {
        return isset($this->SavedFilterId) ? $this->SavedFilterId : null;
    }
    /**
     * Set SavedFilterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $savedFilterId
     * @return \patest\StructType\FilterEntity
     */
    public function setSavedFilterId($savedFilterId = null)
    {
        // validation for constraint: string
        if (!is_null($savedFilterId) && !is_string($savedFilterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savedFilterId, true), gettype($savedFilterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($savedFilterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $savedFilterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($savedFilterId, true)), __LINE__);
        }
        if (is_null($savedFilterId) || (is_array($savedFilterId) && empty($savedFilterId))) {
            unset($this->SavedFilterId);
        } else {
            $this->SavedFilterId = $savedFilterId;
        }
        return $this;
    }
    /**
     * Get SearchTarget value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSearchTarget()
    {
        return isset($this->SearchTarget) ? $this->SearchTarget : null;
    }
    /**
     * Set SearchTarget value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $searchTarget
     * @return \patest\StructType\FilterEntity
     */
    public function setSearchTarget($searchTarget = null)
    {
        // validation for constraint: string
        if (!is_null($searchTarget) && !is_string($searchTarget)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchTarget, true), gettype($searchTarget)), __LINE__);
        }
        if (is_null($searchTarget) || (is_array($searchTarget) && empty($searchTarget))) {
            unset($this->SearchTarget);
        } else {
            $this->SearchTarget = $searchTarget;
        }
        return $this;
    }
}
