<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Facade.ItemWaitingForAction StructType
 * @subpackage Structs
 */
class Facade_ItemWaitingForAction extends AnyEntity
{
    /**
     * The ActionExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionExpiryDate;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The FormattedEventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormattedEventDate;
    /**
     * The GroupedRelatedIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupedRelatedIds;
    /**
     * The GroupedRelatedItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupedRelatedItemIds;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallName;
    /**
     * The IsGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGroup;
    /**
     * The IsPurchasedByClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPurchasedByClient;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemName;
    /**
     * The ItemTypeNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemTypeNumber;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Qty;
    /**
     * The RelatedId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedId;
    /**
     * The RelatedItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RelatedItemId;
    /**
     * The RelatedProductInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedProductInstanceId;
    /**
     * The RelatedTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedTransactionId;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectorName;
    /**
     * The TransactionClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionClientId;
    /**
     * The TransactionReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionReferenceNumber;
    /**
     * The WaitForActionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $WaitForActionType;
    /**
     * Constructor method for Facade.ItemWaitingForAction
     * @uses Facade_ItemWaitingForAction::setActionExpiryDate()
     * @uses Facade_ItemWaitingForAction::setAreaName()
     * @uses Facade_ItemWaitingForAction::setClientId()
     * @uses Facade_ItemWaitingForAction::setDetails()
     * @uses Facade_ItemWaitingForAction::setEventDate()
     * @uses Facade_ItemWaitingForAction::setFormattedEventDate()
     * @uses Facade_ItemWaitingForAction::setGroupedRelatedIds()
     * @uses Facade_ItemWaitingForAction::setGroupedRelatedItemIds()
     * @uses Facade_ItemWaitingForAction::setHallName()
     * @uses Facade_ItemWaitingForAction::setIsGroup()
     * @uses Facade_ItemWaitingForAction::setIsPurchasedByClient()
     * @uses Facade_ItemWaitingForAction::setItemName()
     * @uses Facade_ItemWaitingForAction::setItemTypeNumber()
     * @uses Facade_ItemWaitingForAction::setPriceTypeId()
     * @uses Facade_ItemWaitingForAction::setQty()
     * @uses Facade_ItemWaitingForAction::setRelatedId()
     * @uses Facade_ItemWaitingForAction::setRelatedItemId()
     * @uses Facade_ItemWaitingForAction::setRelatedProductInstanceId()
     * @uses Facade_ItemWaitingForAction::setRelatedTransactionId()
     * @uses Facade_ItemWaitingForAction::setRowName()
     * @uses Facade_ItemWaitingForAction::setSeatName()
     * @uses Facade_ItemWaitingForAction::setSectorName()
     * @uses Facade_ItemWaitingForAction::setTransactionClientId()
     * @uses Facade_ItemWaitingForAction::setTransactionReferenceNumber()
     * @uses Facade_ItemWaitingForAction::setWaitForActionType()
     * @param string $actionExpiryDate
     * @param string $areaName
     * @param string $clientId
     * @param string $details
     * @param string $eventDate
     * @param string $formattedEventDate
     * @param string $groupedRelatedIds
     * @param string $groupedRelatedItemIds
     * @param string $hallName
     * @param bool $isGroup
     * @param bool $isPurchasedByClient
     * @param string $itemName
     * @param int $itemTypeNumber
     * @param string $priceTypeId
     * @param int $qty
     * @param string $relatedId
     * @param int $relatedItemId
     * @param string $relatedProductInstanceId
     * @param string $relatedTransactionId
     * @param string $rowName
     * @param string $seatName
     * @param string $sectorName
     * @param string $transactionClientId
     * @param int $transactionReferenceNumber
     * @param string[] $waitForActionType
     */
    public function __construct($actionExpiryDate = null, $areaName = null, $clientId = null, $details = null, $eventDate = null, $formattedEventDate = null, $groupedRelatedIds = null, $groupedRelatedItemIds = null, $hallName = null, $isGroup = null, $isPurchasedByClient = null, $itemName = null, $itemTypeNumber = null, $priceTypeId = null, $qty = null, $relatedId = null, $relatedItemId = null, $relatedProductInstanceId = null, $relatedTransactionId = null, $rowName = null, $seatName = null, $sectorName = null, $transactionClientId = null, $transactionReferenceNumber = null, array $waitForActionType = array())
    {
        $this
            ->setActionExpiryDate($actionExpiryDate)
            ->setAreaName($areaName)
            ->setClientId($clientId)
            ->setDetails($details)
            ->setEventDate($eventDate)
            ->setFormattedEventDate($formattedEventDate)
            ->setGroupedRelatedIds($groupedRelatedIds)
            ->setGroupedRelatedItemIds($groupedRelatedItemIds)
            ->setHallName($hallName)
            ->setIsGroup($isGroup)
            ->setIsPurchasedByClient($isPurchasedByClient)
            ->setItemName($itemName)
            ->setItemTypeNumber($itemTypeNumber)
            ->setPriceTypeId($priceTypeId)
            ->setQty($qty)
            ->setRelatedId($relatedId)
            ->setRelatedItemId($relatedItemId)
            ->setRelatedProductInstanceId($relatedProductInstanceId)
            ->setRelatedTransactionId($relatedTransactionId)
            ->setRowName($rowName)
            ->setSeatName($seatName)
            ->setSectorName($sectorName)
            ->setTransactionClientId($transactionClientId)
            ->setTransactionReferenceNumber($transactionReferenceNumber)
            ->setWaitForActionType($waitForActionType);
    }
    /**
     * Get ActionExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionExpiryDate()
    {
        return isset($this->ActionExpiryDate) ? $this->ActionExpiryDate : null;
    }
    /**
     * Set ActionExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionExpiryDate
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setActionExpiryDate($actionExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($actionExpiryDate) && !is_string($actionExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionExpiryDate, true), gettype($actionExpiryDate)), __LINE__);
        }
        if (is_null($actionExpiryDate) || (is_array($actionExpiryDate) && empty($actionExpiryDate))) {
            unset($this->ActionExpiryDate);
        } else {
            $this->ActionExpiryDate = $actionExpiryDate;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $details
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get FormattedEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormattedEventDate()
    {
        return isset($this->FormattedEventDate) ? $this->FormattedEventDate : null;
    }
    /**
     * Set FormattedEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formattedEventDate
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setFormattedEventDate($formattedEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($formattedEventDate) && !is_string($formattedEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedEventDate, true), gettype($formattedEventDate)), __LINE__);
        }
        if (is_null($formattedEventDate) || (is_array($formattedEventDate) && empty($formattedEventDate))) {
            unset($this->FormattedEventDate);
        } else {
            $this->FormattedEventDate = $formattedEventDate;
        }
        return $this;
    }
    /**
     * Get GroupedRelatedIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupedRelatedIds()
    {
        return isset($this->GroupedRelatedIds) ? $this->GroupedRelatedIds : null;
    }
    /**
     * Set GroupedRelatedIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupedRelatedIds
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setGroupedRelatedIds($groupedRelatedIds = null)
    {
        // validation for constraint: string
        if (!is_null($groupedRelatedIds) && !is_string($groupedRelatedIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupedRelatedIds, true), gettype($groupedRelatedIds)), __LINE__);
        }
        if (is_null($groupedRelatedIds) || (is_array($groupedRelatedIds) && empty($groupedRelatedIds))) {
            unset($this->GroupedRelatedIds);
        } else {
            $this->GroupedRelatedIds = $groupedRelatedIds;
        }
        return $this;
    }
    /**
     * Get GroupedRelatedItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupedRelatedItemIds()
    {
        return isset($this->GroupedRelatedItemIds) ? $this->GroupedRelatedItemIds : null;
    }
    /**
     * Set GroupedRelatedItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupedRelatedItemIds
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setGroupedRelatedItemIds($groupedRelatedItemIds = null)
    {
        // validation for constraint: string
        if (!is_null($groupedRelatedItemIds) && !is_string($groupedRelatedItemIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupedRelatedItemIds, true), gettype($groupedRelatedItemIds)), __LINE__);
        }
        if (is_null($groupedRelatedItemIds) || (is_array($groupedRelatedItemIds) && empty($groupedRelatedItemIds))) {
            unset($this->GroupedRelatedItemIds);
        } else {
            $this->GroupedRelatedItemIds = $groupedRelatedItemIds;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallName
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setHallName($hallName = null)
    {
        // validation for constraint: string
        if (!is_null($hallName) && !is_string($hallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallName, true), gettype($hallName)), __LINE__);
        }
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get IsGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGroup()
    {
        return isset($this->IsGroup) ? $this->IsGroup : null;
    }
    /**
     * Set IsGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGroup
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setIsGroup($isGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGroup) && !is_bool($isGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGroup, true), gettype($isGroup)), __LINE__);
        }
        if (is_null($isGroup) || (is_array($isGroup) && empty($isGroup))) {
            unset($this->IsGroup);
        } else {
            $this->IsGroup = $isGroup;
        }
        return $this;
    }
    /**
     * Get IsPurchasedByClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPurchasedByClient()
    {
        return isset($this->IsPurchasedByClient) ? $this->IsPurchasedByClient : null;
    }
    /**
     * Set IsPurchasedByClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPurchasedByClient
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setIsPurchasedByClient($isPurchasedByClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPurchasedByClient) && !is_bool($isPurchasedByClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPurchasedByClient, true), gettype($isPurchasedByClient)), __LINE__);
        }
        if (is_null($isPurchasedByClient) || (is_array($isPurchasedByClient) && empty($isPurchasedByClient))) {
            unset($this->IsPurchasedByClient);
        } else {
            $this->IsPurchasedByClient = $isPurchasedByClient;
        }
        return $this;
    }
    /**
     * Get ItemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemName()
    {
        return isset($this->ItemName) ? $this->ItemName : null;
    }
    /**
     * Set ItemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemName
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        if (is_null($itemName) || (is_array($itemName) && empty($itemName))) {
            unset($this->ItemName);
        } else {
            $this->ItemName = $itemName;
        }
        return $this;
    }
    /**
     * Get ItemTypeNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemTypeNumber()
    {
        return isset($this->ItemTypeNumber) ? $this->ItemTypeNumber : null;
    }
    /**
     * Set ItemTypeNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemTypeNumber
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setItemTypeNumber($itemTypeNumber = null)
    {
        // validation for constraint: int
        if (!is_null($itemTypeNumber) && !(is_int($itemTypeNumber) || ctype_digit($itemTypeNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemTypeNumber, true), gettype($itemTypeNumber)), __LINE__);
        }
        if (is_null($itemTypeNumber) || (is_array($itemTypeNumber) && empty($itemTypeNumber))) {
            unset($this->ItemTypeNumber);
        } else {
            $this->ItemTypeNumber = $itemTypeNumber;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $qty
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setQty($qty = null)
    {
        // validation for constraint: int
        if (!is_null($qty) && !(is_int($qty) || ctype_digit($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get RelatedId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedId()
    {
        return isset($this->RelatedId) ? $this->RelatedId : null;
    }
    /**
     * Set RelatedId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedId
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setRelatedId($relatedId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedId) && !is_string($relatedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedId, true), gettype($relatedId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedId, true)), __LINE__);
        }
        if (is_null($relatedId) || (is_array($relatedId) && empty($relatedId))) {
            unset($this->RelatedId);
        } else {
            $this->RelatedId = $relatedId;
        }
        return $this;
    }
    /**
     * Get RelatedItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatedItemId()
    {
        return isset($this->RelatedItemId) ? $this->RelatedItemId : null;
    }
    /**
     * Set RelatedItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatedItemId
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setRelatedItemId($relatedItemId = null)
    {
        // validation for constraint: int
        if (!is_null($relatedItemId) && !(is_int($relatedItemId) || ctype_digit($relatedItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatedItemId, true), gettype($relatedItemId)), __LINE__);
        }
        if (is_null($relatedItemId) || (is_array($relatedItemId) && empty($relatedItemId))) {
            unset($this->RelatedItemId);
        } else {
            $this->RelatedItemId = $relatedItemId;
        }
        return $this;
    }
    /**
     * Get RelatedProductInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedProductInstanceId()
    {
        return isset($this->RelatedProductInstanceId) ? $this->RelatedProductInstanceId : null;
    }
    /**
     * Set RelatedProductInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedProductInstanceId
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setRelatedProductInstanceId($relatedProductInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedProductInstanceId) && !is_string($relatedProductInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedProductInstanceId, true), gettype($relatedProductInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedProductInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedProductInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedProductInstanceId, true)), __LINE__);
        }
        if (is_null($relatedProductInstanceId) || (is_array($relatedProductInstanceId) && empty($relatedProductInstanceId))) {
            unset($this->RelatedProductInstanceId);
        } else {
            $this->RelatedProductInstanceId = $relatedProductInstanceId;
        }
        return $this;
    }
    /**
     * Get RelatedTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedTransactionId()
    {
        return isset($this->RelatedTransactionId) ? $this->RelatedTransactionId : null;
    }
    /**
     * Set RelatedTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedTransactionId
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setRelatedTransactionId($relatedTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedTransactionId) && !is_string($relatedTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedTransactionId, true), gettype($relatedTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedTransactionId, true)), __LINE__);
        }
        if (is_null($relatedTransactionId) || (is_array($relatedTransactionId) && empty($relatedTransactionId))) {
            unset($this->RelatedTransactionId);
        } else {
            $this->RelatedTransactionId = $relatedTransactionId;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorName
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setSectorName($sectorName = null)
    {
        // validation for constraint: string
        if (!is_null($sectorName) && !is_string($sectorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorName, true), gettype($sectorName)), __LINE__);
        }
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get TransactionClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionClientId()
    {
        return isset($this->TransactionClientId) ? $this->TransactionClientId : null;
    }
    /**
     * Set TransactionClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionClientId
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setTransactionClientId($transactionClientId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionClientId) && !is_string($transactionClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionClientId, true), gettype($transactionClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionClientId, true)), __LINE__);
        }
        if (is_null($transactionClientId) || (is_array($transactionClientId) && empty($transactionClientId))) {
            unset($this->TransactionClientId);
        } else {
            $this->TransactionClientId = $transactionClientId;
        }
        return $this;
    }
    /**
     * Get TransactionReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionReferenceNumber()
    {
        return isset($this->TransactionReferenceNumber) ? $this->TransactionReferenceNumber : null;
    }
    /**
     * Set TransactionReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionReferenceNumber
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setTransactionReferenceNumber($transactionReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionReferenceNumber) && !(is_int($transactionReferenceNumber) || ctype_digit($transactionReferenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionReferenceNumber, true), gettype($transactionReferenceNumber)), __LINE__);
        }
        if (is_null($transactionReferenceNumber) || (is_array($transactionReferenceNumber) && empty($transactionReferenceNumber))) {
            unset($this->TransactionReferenceNumber);
        } else {
            $this->TransactionReferenceNumber = $transactionReferenceNumber;
        }
        return $this;
    }
    /**
     * Get WaitForActionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getWaitForActionType()
    {
        return isset($this->WaitForActionType) ? $this->WaitForActionType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWaitForActionType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWaitForActionType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWaitForActionTypeForArrayConstraintsFromSetWaitForActionType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $facade_ItemWaitingForActionWaitForActionTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\WaitingForActionType::valueIsValid($facade_ItemWaitingForActionWaitForActionTypeItem)) {
                $invalidValues[] = is_object($facade_ItemWaitingForActionWaitForActionTypeItem) ? get_class($facade_ItemWaitingForActionWaitForActionTypeItem) : sprintf('%s(%s)', gettype($facade_ItemWaitingForActionWaitForActionTypeItem), var_export($facade_ItemWaitingForActionWaitForActionTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\WaitingForActionType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\WaitingForActionType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WaitForActionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\WaitingForActionType::valueIsValid()
     * @uses \patest\EnumType\WaitingForActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $waitForActionType
     * @return \patest\StructType\Facade_ItemWaitingForAction
     */
    public function setWaitForActionType(array $waitForActionType = array())
    {
        // validation for constraint: list
        if ('' !== ($waitForActionTypeArrayErrorMessage = self::validateWaitForActionTypeForArrayConstraintsFromSetWaitForActionType($waitForActionType))) {
            throw new \InvalidArgumentException($waitForActionTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($waitForActionType) || (is_array($waitForActionType) && empty($waitForActionType))) {
            unset($this->WaitForActionType);
        } else {
            $this->WaitForActionType = is_array($waitForActionType) ? implode(' ', $waitForActionType) : null;
        }
        return $this;
    }
}
