<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtendedConnect-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExtendedConnect-Request
 * @subpackage Structs
 */
class ExtendedConnect_Request extends ExtensibleDataContract
{
    /**
     * The ConnectParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Connect_Request
     */
    public $ConnectParameters;
    /**
     * The CrmClientLoginId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CrmClientLoginId;
    /**
     * The UpdateSecurityTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UpdateSecurityTokenId;
    /**
     * Constructor method for ExtendedConnect-Request
     * @uses ExtendedConnect_Request::setConnectParameters()
     * @uses ExtendedConnect_Request::setCrmClientLoginId()
     * @uses ExtendedConnect_Request::setUpdateSecurityTokenId()
     * @param \patest\StructType\Connect_Request $connectParameters
     * @param string $crmClientLoginId
     * @param string $updateSecurityTokenId
     */
    public function __construct(\patest\StructType\Connect_Request $connectParameters = null, $crmClientLoginId = null, $updateSecurityTokenId = null)
    {
        $this
            ->setConnectParameters($connectParameters)
            ->setCrmClientLoginId($crmClientLoginId)
            ->setUpdateSecurityTokenId($updateSecurityTokenId);
    }
    /**
     * Get ConnectParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Connect_Request|null
     */
    public function getConnectParameters()
    {
        return isset($this->ConnectParameters) ? $this->ConnectParameters : null;
    }
    /**
     * Set ConnectParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Connect_Request $connectParameters
     * @return \patest\StructType\ExtendedConnect_Request
     */
    public function setConnectParameters(\patest\StructType\Connect_Request $connectParameters = null)
    {
        if (is_null($connectParameters) || (is_array($connectParameters) && empty($connectParameters))) {
            unset($this->ConnectParameters);
        } else {
            $this->ConnectParameters = $connectParameters;
        }
        return $this;
    }
    /**
     * Get CrmClientLoginId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmClientLoginId()
    {
        return isset($this->CrmClientLoginId) ? $this->CrmClientLoginId : null;
    }
    /**
     * Set CrmClientLoginId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmClientLoginId
     * @return \patest\StructType\ExtendedConnect_Request
     */
    public function setCrmClientLoginId($crmClientLoginId = null)
    {
        // validation for constraint: string
        if (!is_null($crmClientLoginId) && !is_string($crmClientLoginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmClientLoginId, true), gettype($crmClientLoginId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($crmClientLoginId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $crmClientLoginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($crmClientLoginId, true)), __LINE__);
        }
        if (is_null($crmClientLoginId) || (is_array($crmClientLoginId) && empty($crmClientLoginId))) {
            unset($this->CrmClientLoginId);
        } else {
            $this->CrmClientLoginId = $crmClientLoginId;
        }
        return $this;
    }
    /**
     * Get UpdateSecurityTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateSecurityTokenId()
    {
        return isset($this->UpdateSecurityTokenId) ? $this->UpdateSecurityTokenId : null;
    }
    /**
     * Set UpdateSecurityTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateSecurityTokenId
     * @return \patest\StructType\ExtendedConnect_Request
     */
    public function setUpdateSecurityTokenId($updateSecurityTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($updateSecurityTokenId) && !is_string($updateSecurityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateSecurityTokenId, true), gettype($updateSecurityTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($updateSecurityTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $updateSecurityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($updateSecurityTokenId, true)), __LINE__);
        }
        if (is_null($updateSecurityTokenId) || (is_array($updateSecurityTokenId) && empty($updateSecurityTokenId))) {
            unset($this->UpdateSecurityTokenId);
        } else {
            $this->UpdateSecurityTokenId = $updateSecurityTokenId;
        }
        return $this;
    }
}
