<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventPricingDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EventPricingDescription
 * @subpackage Structs
 */
class EventPricingDescription extends AbstractStructBase
{
    /**
     * The PriceLevelAxis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValuePairOfguidstring
     */
    public $PriceLevelAxis;
    /**
     * The PriceMatrix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfArrayOfInventoryPricingEntry
     */
    public $PriceMatrix;
    /**
     * The PriceModifierDescriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidstring
     */
    public $PriceModifierDescriptions;
    /**
     * The PriceTypeAxis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValuePairOfguidstring
     */
    public $PriceTypeAxis;
    /**
     * The BonusPricesInSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfInventoryPricingEntry
     */
    public $BonusPricesInSeries;
    /**
     * The RegularPricesInSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfInventoryPricingEntry
     */
    public $RegularPricesInSeries;
    /**
     * The AvailablePriceLevelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AvailablePriceLevelIds;
    /**
     * The PriceMatrixPriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceMatrixPriceListId;
    /**
     * The AvailablePriceTypesByAllocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfguidox8ieOcg
     */
    public $AvailablePriceTypesByAllocation;
    /**
     * The PriceTypeDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidPriceTypeDetailshpjoQDea
     */
    public $PriceTypeDetails;
    /**
     * The SeatPriceOverrides
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSeatsPriceOverrideData
     */
    public $SeatPriceOverrides;
    /**
     * The MaxTransactionLevelNominalCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaxTransactionLevelNominalCommission;
    /**
     * The PriceModifierDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidInventoryPriceModifierDetailshpjoQDea
     */
    public $PriceModifierDetails;
    /**
     * Constructor method for EventPricingDescription
     * @uses EventPricingDescription::setPriceLevelAxis()
     * @uses EventPricingDescription::setPriceMatrix()
     * @uses EventPricingDescription::setPriceModifierDescriptions()
     * @uses EventPricingDescription::setPriceTypeAxis()
     * @uses EventPricingDescription::setBonusPricesInSeries()
     * @uses EventPricingDescription::setRegularPricesInSeries()
     * @uses EventPricingDescription::setAvailablePriceLevelIds()
     * @uses EventPricingDescription::setPriceMatrixPriceListId()
     * @uses EventPricingDescription::setAvailablePriceTypesByAllocation()
     * @uses EventPricingDescription::setPriceTypeDetails()
     * @uses EventPricingDescription::setSeatPriceOverrides()
     * @uses EventPricingDescription::setMaxTransactionLevelNominalCommission()
     * @uses EventPricingDescription::setPriceModifierDetails()
     * @param \patest\ArrayType\ArrayOfKeyValuePairOfguidstring $priceLevelAxis
     * @param \patest\ArrayType\ArrayOfArrayOfInventoryPricingEntry $priceMatrix
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidstring $priceModifierDescriptions
     * @param \patest\ArrayType\ArrayOfKeyValuePairOfguidstring $priceTypeAxis
     * @param \patest\ArrayType\ArrayOfInventoryPricingEntry $bonusPricesInSeries
     * @param \patest\ArrayType\ArrayOfInventoryPricingEntry $regularPricesInSeries
     * @param \patest\ArrayType\ArrayOfguid $availablePriceLevelIds
     * @param string $priceMatrixPriceListId
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfguidox8ieOcg $availablePriceTypesByAllocation
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidPriceTypeDetailshpjoQDea $priceTypeDetails
     * @param \patest\ArrayType\ArrayOfSeatsPriceOverrideData $seatPriceOverrides
     * @param float $maxTransactionLevelNominalCommission
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidInventoryPriceModifierDetailshpjoQDea $priceModifierDetails
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValuePairOfguidstring $priceLevelAxis = null, \patest\ArrayType\ArrayOfArrayOfInventoryPricingEntry $priceMatrix = null, \patest\ArrayType\ArrayOfKeyValueOfguidstring $priceModifierDescriptions = null, \patest\ArrayType\ArrayOfKeyValuePairOfguidstring $priceTypeAxis = null, \patest\ArrayType\ArrayOfInventoryPricingEntry $bonusPricesInSeries = null, \patest\ArrayType\ArrayOfInventoryPricingEntry $regularPricesInSeries = null, \patest\ArrayType\ArrayOfguid $availablePriceLevelIds = null, $priceMatrixPriceListId = null, \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfguidox8ieOcg $availablePriceTypesByAllocation = null, \patest\ArrayType\ArrayOfKeyValueOfguidPriceTypeDetailshpjoQDea $priceTypeDetails = null, \patest\ArrayType\ArrayOfSeatsPriceOverrideData $seatPriceOverrides = null, $maxTransactionLevelNominalCommission = null, \patest\ArrayType\ArrayOfKeyValueOfguidInventoryPriceModifierDetailshpjoQDea $priceModifierDetails = null)
    {
        $this
            ->setPriceLevelAxis($priceLevelAxis)
            ->setPriceMatrix($priceMatrix)
            ->setPriceModifierDescriptions($priceModifierDescriptions)
            ->setPriceTypeAxis($priceTypeAxis)
            ->setBonusPricesInSeries($bonusPricesInSeries)
            ->setRegularPricesInSeries($regularPricesInSeries)
            ->setAvailablePriceLevelIds($availablePriceLevelIds)
            ->setPriceMatrixPriceListId($priceMatrixPriceListId)
            ->setAvailablePriceTypesByAllocation($availablePriceTypesByAllocation)
            ->setPriceTypeDetails($priceTypeDetails)
            ->setSeatPriceOverrides($seatPriceOverrides)
            ->setMaxTransactionLevelNominalCommission($maxTransactionLevelNominalCommission)
            ->setPriceModifierDetails($priceModifierDetails);
    }
    /**
     * Get PriceLevelAxis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValuePairOfguidstring|null
     */
    public function getPriceLevelAxis()
    {
        return isset($this->PriceLevelAxis) ? $this->PriceLevelAxis : null;
    }
    /**
     * Set PriceLevelAxis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValuePairOfguidstring $priceLevelAxis
     * @return \patest\StructType\EventPricingDescription
     */
    public function setPriceLevelAxis(\patest\ArrayType\ArrayOfKeyValuePairOfguidstring $priceLevelAxis = null)
    {
        if (is_null($priceLevelAxis) || (is_array($priceLevelAxis) && empty($priceLevelAxis))) {
            unset($this->PriceLevelAxis);
        } else {
            $this->PriceLevelAxis = $priceLevelAxis;
        }
        return $this;
    }
    /**
     * Get PriceMatrix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfArrayOfInventoryPricingEntry|null
     */
    public function getPriceMatrix()
    {
        return isset($this->PriceMatrix) ? $this->PriceMatrix : null;
    }
    /**
     * Set PriceMatrix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfArrayOfInventoryPricingEntry $priceMatrix
     * @return \patest\StructType\EventPricingDescription
     */
    public function setPriceMatrix(\patest\ArrayType\ArrayOfArrayOfInventoryPricingEntry $priceMatrix = null)
    {
        if (is_null($priceMatrix) || (is_array($priceMatrix) && empty($priceMatrix))) {
            unset($this->PriceMatrix);
        } else {
            $this->PriceMatrix = $priceMatrix;
        }
        return $this;
    }
    /**
     * Get PriceModifierDescriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidstring|null
     */
    public function getPriceModifierDescriptions()
    {
        return isset($this->PriceModifierDescriptions) ? $this->PriceModifierDescriptions : null;
    }
    /**
     * Set PriceModifierDescriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidstring $priceModifierDescriptions
     * @return \patest\StructType\EventPricingDescription
     */
    public function setPriceModifierDescriptions(\patest\ArrayType\ArrayOfKeyValueOfguidstring $priceModifierDescriptions = null)
    {
        if (is_null($priceModifierDescriptions) || (is_array($priceModifierDescriptions) && empty($priceModifierDescriptions))) {
            unset($this->PriceModifierDescriptions);
        } else {
            $this->PriceModifierDescriptions = $priceModifierDescriptions;
        }
        return $this;
    }
    /**
     * Get PriceTypeAxis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValuePairOfguidstring|null
     */
    public function getPriceTypeAxis()
    {
        return isset($this->PriceTypeAxis) ? $this->PriceTypeAxis : null;
    }
    /**
     * Set PriceTypeAxis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValuePairOfguidstring $priceTypeAxis
     * @return \patest\StructType\EventPricingDescription
     */
    public function setPriceTypeAxis(\patest\ArrayType\ArrayOfKeyValuePairOfguidstring $priceTypeAxis = null)
    {
        if (is_null($priceTypeAxis) || (is_array($priceTypeAxis) && empty($priceTypeAxis))) {
            unset($this->PriceTypeAxis);
        } else {
            $this->PriceTypeAxis = $priceTypeAxis;
        }
        return $this;
    }
    /**
     * Get BonusPricesInSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfInventoryPricingEntry|null
     */
    public function getBonusPricesInSeries()
    {
        return isset($this->BonusPricesInSeries) ? $this->BonusPricesInSeries : null;
    }
    /**
     * Set BonusPricesInSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfInventoryPricingEntry $bonusPricesInSeries
     * @return \patest\StructType\EventPricingDescription
     */
    public function setBonusPricesInSeries(\patest\ArrayType\ArrayOfInventoryPricingEntry $bonusPricesInSeries = null)
    {
        if (is_null($bonusPricesInSeries) || (is_array($bonusPricesInSeries) && empty($bonusPricesInSeries))) {
            unset($this->BonusPricesInSeries);
        } else {
            $this->BonusPricesInSeries = $bonusPricesInSeries;
        }
        return $this;
    }
    /**
     * Get RegularPricesInSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfInventoryPricingEntry|null
     */
    public function getRegularPricesInSeries()
    {
        return isset($this->RegularPricesInSeries) ? $this->RegularPricesInSeries : null;
    }
    /**
     * Set RegularPricesInSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfInventoryPricingEntry $regularPricesInSeries
     * @return \patest\StructType\EventPricingDescription
     */
    public function setRegularPricesInSeries(\patest\ArrayType\ArrayOfInventoryPricingEntry $regularPricesInSeries = null)
    {
        if (is_null($regularPricesInSeries) || (is_array($regularPricesInSeries) && empty($regularPricesInSeries))) {
            unset($this->RegularPricesInSeries);
        } else {
            $this->RegularPricesInSeries = $regularPricesInSeries;
        }
        return $this;
    }
    /**
     * Get AvailablePriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAvailablePriceLevelIds()
    {
        return isset($this->AvailablePriceLevelIds) ? $this->AvailablePriceLevelIds : null;
    }
    /**
     * Set AvailablePriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $availablePriceLevelIds
     * @return \patest\StructType\EventPricingDescription
     */
    public function setAvailablePriceLevelIds(\patest\ArrayType\ArrayOfguid $availablePriceLevelIds = null)
    {
        if (is_null($availablePriceLevelIds) || (is_array($availablePriceLevelIds) && empty($availablePriceLevelIds))) {
            unset($this->AvailablePriceLevelIds);
        } else {
            $this->AvailablePriceLevelIds = $availablePriceLevelIds;
        }
        return $this;
    }
    /**
     * Get PriceMatrixPriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceMatrixPriceListId()
    {
        return isset($this->PriceMatrixPriceListId) ? $this->PriceMatrixPriceListId : null;
    }
    /**
     * Set PriceMatrixPriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceMatrixPriceListId
     * @return \patest\StructType\EventPricingDescription
     */
    public function setPriceMatrixPriceListId($priceMatrixPriceListId = null)
    {
        // validation for constraint: string
        if (!is_null($priceMatrixPriceListId) && !is_string($priceMatrixPriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceMatrixPriceListId, true), gettype($priceMatrixPriceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceMatrixPriceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceMatrixPriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceMatrixPriceListId, true)), __LINE__);
        }
        if (is_null($priceMatrixPriceListId) || (is_array($priceMatrixPriceListId) && empty($priceMatrixPriceListId))) {
            unset($this->PriceMatrixPriceListId);
        } else {
            $this->PriceMatrixPriceListId = $priceMatrixPriceListId;
        }
        return $this;
    }
    /**
     * Get AvailablePriceTypesByAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfguidox8ieOcg|null
     */
    public function getAvailablePriceTypesByAllocation()
    {
        return isset($this->AvailablePriceTypesByAllocation) ? $this->AvailablePriceTypesByAllocation : null;
    }
    /**
     * Set AvailablePriceTypesByAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfguidox8ieOcg $availablePriceTypesByAllocation
     * @return \patest\StructType\EventPricingDescription
     */
    public function setAvailablePriceTypesByAllocation(\patest\ArrayType\ArrayOfKeyValueOfguidArrayOfguidox8ieOcg $availablePriceTypesByAllocation = null)
    {
        if (is_null($availablePriceTypesByAllocation) || (is_array($availablePriceTypesByAllocation) && empty($availablePriceTypesByAllocation))) {
            unset($this->AvailablePriceTypesByAllocation);
        } else {
            $this->AvailablePriceTypesByAllocation = $availablePriceTypesByAllocation;
        }
        return $this;
    }
    /**
     * Get PriceTypeDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidPriceTypeDetailshpjoQDea|null
     */
    public function getPriceTypeDetails()
    {
        return isset($this->PriceTypeDetails) ? $this->PriceTypeDetails : null;
    }
    /**
     * Set PriceTypeDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidPriceTypeDetailshpjoQDea $priceTypeDetails
     * @return \patest\StructType\EventPricingDescription
     */
    public function setPriceTypeDetails(\patest\ArrayType\ArrayOfKeyValueOfguidPriceTypeDetailshpjoQDea $priceTypeDetails = null)
    {
        if (is_null($priceTypeDetails) || (is_array($priceTypeDetails) && empty($priceTypeDetails))) {
            unset($this->PriceTypeDetails);
        } else {
            $this->PriceTypeDetails = $priceTypeDetails;
        }
        return $this;
    }
    /**
     * Get SeatPriceOverrides value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSeatsPriceOverrideData|null
     */
    public function getSeatPriceOverrides()
    {
        return isset($this->SeatPriceOverrides) ? $this->SeatPriceOverrides : null;
    }
    /**
     * Set SeatPriceOverrides value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSeatsPriceOverrideData $seatPriceOverrides
     * @return \patest\StructType\EventPricingDescription
     */
    public function setSeatPriceOverrides(\patest\ArrayType\ArrayOfSeatsPriceOverrideData $seatPriceOverrides = null)
    {
        if (is_null($seatPriceOverrides) || (is_array($seatPriceOverrides) && empty($seatPriceOverrides))) {
            unset($this->SeatPriceOverrides);
        } else {
            $this->SeatPriceOverrides = $seatPriceOverrides;
        }
        return $this;
    }
    /**
     * Get MaxTransactionLevelNominalCommission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaxTransactionLevelNominalCommission()
    {
        return isset($this->MaxTransactionLevelNominalCommission) ? $this->MaxTransactionLevelNominalCommission : null;
    }
    /**
     * Set MaxTransactionLevelNominalCommission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maxTransactionLevelNominalCommission
     * @return \patest\StructType\EventPricingDescription
     */
    public function setMaxTransactionLevelNominalCommission($maxTransactionLevelNominalCommission = null)
    {
        // validation for constraint: float
        if (!is_null($maxTransactionLevelNominalCommission) && !(is_float($maxTransactionLevelNominalCommission) || is_numeric($maxTransactionLevelNominalCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxTransactionLevelNominalCommission, true), gettype($maxTransactionLevelNominalCommission)), __LINE__);
        }
        if (is_null($maxTransactionLevelNominalCommission) || (is_array($maxTransactionLevelNominalCommission) && empty($maxTransactionLevelNominalCommission))) {
            unset($this->MaxTransactionLevelNominalCommission);
        } else {
            $this->MaxTransactionLevelNominalCommission = $maxTransactionLevelNominalCommission;
        }
        return $this;
    }
    /**
     * Get PriceModifierDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidInventoryPriceModifierDetailshpjoQDea|null
     */
    public function getPriceModifierDetails()
    {
        return isset($this->PriceModifierDetails) ? $this->PriceModifierDetails : null;
    }
    /**
     * Set PriceModifierDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidInventoryPriceModifierDetailshpjoQDea $priceModifierDetails
     * @return \patest\StructType\EventPricingDescription
     */
    public function setPriceModifierDetails(\patest\ArrayType\ArrayOfKeyValueOfguidInventoryPriceModifierDetailshpjoQDea $priceModifierDetails = null)
    {
        if (is_null($priceModifierDetails) || (is_array($priceModifierDetails) && empty($priceModifierDetails))) {
            unset($this->PriceModifierDetails);
        } else {
            $this->PriceModifierDetails = $priceModifierDetails;
        }
        return $this;
    }
}
