<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntitiesQueryResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EntitiesQueryResponse
 * @subpackage Structs
 */
class EntitiesQueryResponse extends AbstractStructBase
{
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAnyEntity
     */
    public $Data;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Count;
    /**
     * The MaxMatchingRowsToCountReached
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MaxMatchingRowsToCountReached;
    /**
     * The MoreChunksAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MoreChunksAvailable;
    /**
     * The QueryToken
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryToken;
    /**
     * The QueryTokenContextTimeToLiveInSeconds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QueryTokenContextTimeToLiveInSeconds;
    /**
     * The TotalMatchingRows
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalMatchingRows;
    /**
     * Constructor method for EntitiesQueryResponse
     * @uses EntitiesQueryResponse::setData()
     * @uses EntitiesQueryResponse::setCount()
     * @uses EntitiesQueryResponse::setMaxMatchingRowsToCountReached()
     * @uses EntitiesQueryResponse::setMoreChunksAvailable()
     * @uses EntitiesQueryResponse::setQueryToken()
     * @uses EntitiesQueryResponse::setQueryTokenContextTimeToLiveInSeconds()
     * @uses EntitiesQueryResponse::setTotalMatchingRows()
     * @param \patest\StructType\RecordSetOfAnyEntity $data
     * @param int $count
     * @param bool $maxMatchingRowsToCountReached
     * @param bool $moreChunksAvailable
     * @param string $queryToken
     * @param int $queryTokenContextTimeToLiveInSeconds
     * @param int $totalMatchingRows
     */
    public function __construct(\patest\StructType\RecordSetOfAnyEntity $data = null, $count = null, $maxMatchingRowsToCountReached = null, $moreChunksAvailable = null, $queryToken = null, $queryTokenContextTimeToLiveInSeconds = null, $totalMatchingRows = null)
    {
        $this
            ->setData($data)
            ->setCount($count)
            ->setMaxMatchingRowsToCountReached($maxMatchingRowsToCountReached)
            ->setMoreChunksAvailable($moreChunksAvailable)
            ->setQueryToken($queryToken)
            ->setQueryTokenContextTimeToLiveInSeconds($queryTokenContextTimeToLiveInSeconds)
            ->setTotalMatchingRows($totalMatchingRows);
    }
    /**
     * Get Data value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAnyEntity|null
     */
    public function getData()
    {
        return isset($this->Data) ? $this->Data : null;
    }
    /**
     * Set Data value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAnyEntity $data
     * @return \patest\StructType\EntitiesQueryResponse
     */
    public function setData(\patest\StructType\RecordSetOfAnyEntity $data = null)
    {
        if (is_null($data) || (is_array($data) && empty($data))) {
            unset($this->Data);
        } else {
            $this->Data = $data;
        }
        return $this;
    }
    /**
     * Get Count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCount()
    {
        return isset($this->Count) ? $this->Count : null;
    }
    /**
     * Set Count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $count
     * @return \patest\StructType\EntitiesQueryResponse
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        if (is_null($count) || (is_array($count) && empty($count))) {
            unset($this->Count);
        } else {
            $this->Count = $count;
        }
        return $this;
    }
    /**
     * Get MaxMatchingRowsToCountReached value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMaxMatchingRowsToCountReached()
    {
        return isset($this->MaxMatchingRowsToCountReached) ? $this->MaxMatchingRowsToCountReached : null;
    }
    /**
     * Set MaxMatchingRowsToCountReached value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $maxMatchingRowsToCountReached
     * @return \patest\StructType\EntitiesQueryResponse
     */
    public function setMaxMatchingRowsToCountReached($maxMatchingRowsToCountReached = null)
    {
        // validation for constraint: boolean
        if (!is_null($maxMatchingRowsToCountReached) && !is_bool($maxMatchingRowsToCountReached)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($maxMatchingRowsToCountReached, true), gettype($maxMatchingRowsToCountReached)), __LINE__);
        }
        if (is_null($maxMatchingRowsToCountReached) || (is_array($maxMatchingRowsToCountReached) && empty($maxMatchingRowsToCountReached))) {
            unset($this->MaxMatchingRowsToCountReached);
        } else {
            $this->MaxMatchingRowsToCountReached = $maxMatchingRowsToCountReached;
        }
        return $this;
    }
    /**
     * Get MoreChunksAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMoreChunksAvailable()
    {
        return isset($this->MoreChunksAvailable) ? $this->MoreChunksAvailable : null;
    }
    /**
     * Set MoreChunksAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $moreChunksAvailable
     * @return \patest\StructType\EntitiesQueryResponse
     */
    public function setMoreChunksAvailable($moreChunksAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreChunksAvailable) && !is_bool($moreChunksAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moreChunksAvailable, true), gettype($moreChunksAvailable)), __LINE__);
        }
        if (is_null($moreChunksAvailable) || (is_array($moreChunksAvailable) && empty($moreChunksAvailable))) {
            unset($this->MoreChunksAvailable);
        } else {
            $this->MoreChunksAvailable = $moreChunksAvailable;
        }
        return $this;
    }
    /**
     * Get QueryToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryToken()
    {
        return isset($this->QueryToken) ? $this->QueryToken : null;
    }
    /**
     * Set QueryToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryToken
     * @return \patest\StructType\EntitiesQueryResponse
     */
    public function setQueryToken($queryToken = null)
    {
        // validation for constraint: string
        if (!is_null($queryToken) && !is_string($queryToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryToken, true), gettype($queryToken)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryToken) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryToken, true)), __LINE__);
        }
        if (is_null($queryToken) || (is_array($queryToken) && empty($queryToken))) {
            unset($this->QueryToken);
        } else {
            $this->QueryToken = $queryToken;
        }
        return $this;
    }
    /**
     * Get QueryTokenContextTimeToLiveInSeconds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQueryTokenContextTimeToLiveInSeconds()
    {
        return isset($this->QueryTokenContextTimeToLiveInSeconds) ? $this->QueryTokenContextTimeToLiveInSeconds : null;
    }
    /**
     * Set QueryTokenContextTimeToLiveInSeconds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $queryTokenContextTimeToLiveInSeconds
     * @return \patest\StructType\EntitiesQueryResponse
     */
    public function setQueryTokenContextTimeToLiveInSeconds($queryTokenContextTimeToLiveInSeconds = null)
    {
        // validation for constraint: int
        if (!is_null($queryTokenContextTimeToLiveInSeconds) && !(is_int($queryTokenContextTimeToLiveInSeconds) || ctype_digit($queryTokenContextTimeToLiveInSeconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($queryTokenContextTimeToLiveInSeconds, true), gettype($queryTokenContextTimeToLiveInSeconds)), __LINE__);
        }
        if (is_null($queryTokenContextTimeToLiveInSeconds) || (is_array($queryTokenContextTimeToLiveInSeconds) && empty($queryTokenContextTimeToLiveInSeconds))) {
            unset($this->QueryTokenContextTimeToLiveInSeconds);
        } else {
            $this->QueryTokenContextTimeToLiveInSeconds = $queryTokenContextTimeToLiveInSeconds;
        }
        return $this;
    }
    /**
     * Get TotalMatchingRows value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalMatchingRows()
    {
        return isset($this->TotalMatchingRows) ? $this->TotalMatchingRows : null;
    }
    /**
     * Set TotalMatchingRows value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalMatchingRows
     * @return \patest\StructType\EntitiesQueryResponse
     */
    public function setTotalMatchingRows($totalMatchingRows = null)
    {
        // validation for constraint: int
        if (!is_null($totalMatchingRows) && !(is_int($totalMatchingRows) || ctype_digit($totalMatchingRows))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalMatchingRows, true), gettype($totalMatchingRows)), __LINE__);
        }
        if (is_null($totalMatchingRows) || (is_array($totalMatchingRows) && empty($totalMatchingRows))) {
            unset($this->TotalMatchingRows);
        } else {
            $this->TotalMatchingRows = $totalMatchingRows;
        }
        return $this;
    }
}
