<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntitiesCreateOrUpdateResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EntitiesCreateOrUpdateResponse
 * @subpackage Structs
 */
class EntitiesCreateOrUpdateResponse extends AbstractStructBase
{
    /**
     * The Results
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfEntityProcessingResults
     */
    public $Results;
    /**
     * The UpdatedEntities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAnyEntity
     */
    public $UpdatedEntities;
    /**
     * Constructor method for EntitiesCreateOrUpdateResponse
     * @uses EntitiesCreateOrUpdateResponse::setResults()
     * @uses EntitiesCreateOrUpdateResponse::setUpdatedEntities()
     * @param \patest\ArrayType\ArrayOfEntityProcessingResults $results
     * @param \patest\ArrayType\ArrayOfAnyEntity $updatedEntities
     */
    public function __construct(\patest\ArrayType\ArrayOfEntityProcessingResults $results = null, \patest\ArrayType\ArrayOfAnyEntity $updatedEntities = null)
    {
        $this
            ->setResults($results)
            ->setUpdatedEntities($updatedEntities);
    }
    /**
     * Get Results value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfEntityProcessingResults|null
     */
    public function getResults()
    {
        return isset($this->Results) ? $this->Results : null;
    }
    /**
     * Set Results value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfEntityProcessingResults $results
     * @return \patest\StructType\EntitiesCreateOrUpdateResponse
     */
    public function setResults(\patest\ArrayType\ArrayOfEntityProcessingResults $results = null)
    {
        if (is_null($results) || (is_array($results) && empty($results))) {
            unset($this->Results);
        } else {
            $this->Results = $results;
        }
        return $this;
    }
    /**
     * Get UpdatedEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAnyEntity|null
     */
    public function getUpdatedEntities()
    {
        return isset($this->UpdatedEntities) ? $this->UpdatedEntities : null;
    }
    /**
     * Set UpdatedEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAnyEntity $updatedEntities
     * @return \patest\StructType\EntitiesCreateOrUpdateResponse
     */
    public function setUpdatedEntities(\patest\ArrayType\ArrayOfAnyEntity $updatedEntities = null)
    {
        if (is_null($updatedEntities) || (is_array($updatedEntities) && empty($updatedEntities))) {
            unset($this->UpdatedEntities);
        } else {
            $this->UpdatedEntities = $updatedEntities;
        }
        return $this;
    }
}
