<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eSRO.Crm.UserDataForm StructType
 * @subpackage Structs
 */
class ESRO_Crm_UserDataForm extends AnyEntity
{
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The Address2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address2;
    /**
     * The Address3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address3;
    /**
     * The add_user
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $add_user;
    /**
     * The Birthday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Birthday;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $City;
    /**
     * The CityIdOrName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CityIdOrName;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Country;
    /**
     * The CountryIdOrName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryIdOrName;
    /**
     * The DataProtection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DataProtection
     */
    public $DataProtection;
    /**
     * The DateTimeField1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTimeField1;
    /**
     * The DateTimeField2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTimeField2;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The IDNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDNumber;
    /**
     * The Initial
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Initial;
    /**
     * The Initials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Initials;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MiddleName;
    /**
     * The NamePrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NamePrefix;
    /**
     * The NameSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameSuffix;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The Phone2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone2;
    /**
     * The Phone3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone3;
    /**
     * The Preferences
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Preferences
     */
    public $Preferences;
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Region;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $State;
    /**
     * The StateIdOrName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StateIdOrName;
    /**
     * The StringField1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField1;
    /**
     * The StringField2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField2;
    /**
     * The StringField3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField3;
    /**
     * The StringField4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField4;
    /**
     * The StringField5
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField5;
    /**
     * The StringField6
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField6;
    /**
     * The StringField7
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField7;
    /**
     * The TaxExemptNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxExemptNumber;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Type;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The VatRegistrationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VatRegistrationNumber;
    /**
     * The Website
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Website;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for eSRO.Crm.UserDataForm
     * @uses ESRO_Crm_UserDataForm::setAccountName()
     * @uses ESRO_Crm_UserDataForm::setAddress()
     * @uses ESRO_Crm_UserDataForm::setAddress2()
     * @uses ESRO_Crm_UserDataForm::setAddress3()
     * @uses ESRO_Crm_UserDataForm::setAdd_user()
     * @uses ESRO_Crm_UserDataForm::setBirthday()
     * @uses ESRO_Crm_UserDataForm::setCity()
     * @uses ESRO_Crm_UserDataForm::setCityIdOrName()
     * @uses ESRO_Crm_UserDataForm::setCountry()
     * @uses ESRO_Crm_UserDataForm::setCountryIdOrName()
     * @uses ESRO_Crm_UserDataForm::setDataProtection()
     * @uses ESRO_Crm_UserDataForm::setDateTimeField1()
     * @uses ESRO_Crm_UserDataForm::setDateTimeField2()
     * @uses ESRO_Crm_UserDataForm::setEmail()
     * @uses ESRO_Crm_UserDataForm::setFax()
     * @uses ESRO_Crm_UserDataForm::setFirstName()
     * @uses ESRO_Crm_UserDataForm::setGender()
     * @uses ESRO_Crm_UserDataForm::setIDNumber()
     * @uses ESRO_Crm_UserDataForm::setInitial()
     * @uses ESRO_Crm_UserDataForm::setInitials()
     * @uses ESRO_Crm_UserDataForm::setLastName()
     * @uses ESRO_Crm_UserDataForm::setMiddleName()
     * @uses ESRO_Crm_UserDataForm::setNamePrefix()
     * @uses ESRO_Crm_UserDataForm::setNameSuffix()
     * @uses ESRO_Crm_UserDataForm::setPassword()
     * @uses ESRO_Crm_UserDataForm::setPhone()
     * @uses ESRO_Crm_UserDataForm::setPhone2()
     * @uses ESRO_Crm_UserDataForm::setPhone3()
     * @uses ESRO_Crm_UserDataForm::setPreferences()
     * @uses ESRO_Crm_UserDataForm::setRegion()
     * @uses ESRO_Crm_UserDataForm::setState()
     * @uses ESRO_Crm_UserDataForm::setStateIdOrName()
     * @uses ESRO_Crm_UserDataForm::setStringField1()
     * @uses ESRO_Crm_UserDataForm::setStringField2()
     * @uses ESRO_Crm_UserDataForm::setStringField3()
     * @uses ESRO_Crm_UserDataForm::setStringField4()
     * @uses ESRO_Crm_UserDataForm::setStringField5()
     * @uses ESRO_Crm_UserDataForm::setStringField6()
     * @uses ESRO_Crm_UserDataForm::setStringField7()
     * @uses ESRO_Crm_UserDataForm::setTaxExemptNumber()
     * @uses ESRO_Crm_UserDataForm::setType()
     * @uses ESRO_Crm_UserDataForm::setUserName()
     * @uses ESRO_Crm_UserDataForm::setVatRegistrationNumber()
     * @uses ESRO_Crm_UserDataForm::setWebsite()
     * @uses ESRO_Crm_UserDataForm::setZipCode()
     * @param string $accountName
     * @param string $address
     * @param string $address2
     * @param string $address3
     * @param bool $add_user
     * @param string $birthday
     * @param string $city
     * @param string $cityIdOrName
     * @param string $country
     * @param string $countryIdOrName
     * @param \patest\StructType\DataProtection $dataProtection
     * @param string $dateTimeField1
     * @param string $dateTimeField2
     * @param string $email
     * @param string $fax
     * @param string $firstName
     * @param string $gender
     * @param string $iDNumber
     * @param string $initial
     * @param string $initials
     * @param string $lastName
     * @param string $middleName
     * @param string $namePrefix
     * @param string $nameSuffix
     * @param string $password
     * @param string $phone
     * @param string $phone2
     * @param string $phone3
     * @param \patest\StructType\Preferences $preferences
     * @param string $region
     * @param string $state
     * @param string $stateIdOrName
     * @param string $stringField1
     * @param string $stringField2
     * @param string $stringField3
     * @param string $stringField4
     * @param string $stringField5
     * @param string $stringField6
     * @param string $stringField7
     * @param string $taxExemptNumber
     * @param string[] $type
     * @param string $userName
     * @param string $vatRegistrationNumber
     * @param string $website
     * @param string $zipCode
     */
    public function __construct($accountName = null, $address = null, $address2 = null, $address3 = null, $add_user = null, $birthday = null, $city = null, $cityIdOrName = null, $country = null, $countryIdOrName = null, \patest\StructType\DataProtection $dataProtection = null, $dateTimeField1 = null, $dateTimeField2 = null, $email = null, $fax = null, $firstName = null, $gender = null, $iDNumber = null, $initial = null, $initials = null, $lastName = null, $middleName = null, $namePrefix = null, $nameSuffix = null, $password = null, $phone = null, $phone2 = null, $phone3 = null, \patest\StructType\Preferences $preferences = null, $region = null, $state = null, $stateIdOrName = null, $stringField1 = null, $stringField2 = null, $stringField3 = null, $stringField4 = null, $stringField5 = null, $stringField6 = null, $stringField7 = null, $taxExemptNumber = null, array $type = array(), $userName = null, $vatRegistrationNumber = null, $website = null, $zipCode = null)
    {
        $this
            ->setAccountName($accountName)
            ->setAddress($address)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setAdd_user($add_user)
            ->setBirthday($birthday)
            ->setCity($city)
            ->setCityIdOrName($cityIdOrName)
            ->setCountry($country)
            ->setCountryIdOrName($countryIdOrName)
            ->setDataProtection($dataProtection)
            ->setDateTimeField1($dateTimeField1)
            ->setDateTimeField2($dateTimeField2)
            ->setEmail($email)
            ->setFax($fax)
            ->setFirstName($firstName)
            ->setGender($gender)
            ->setIDNumber($iDNumber)
            ->setInitial($initial)
            ->setInitials($initials)
            ->setLastName($lastName)
            ->setMiddleName($middleName)
            ->setNamePrefix($namePrefix)
            ->setNameSuffix($nameSuffix)
            ->setPassword($password)
            ->setPhone($phone)
            ->setPhone2($phone2)
            ->setPhone3($phone3)
            ->setPreferences($preferences)
            ->setRegion($region)
            ->setState($state)
            ->setStateIdOrName($stateIdOrName)
            ->setStringField1($stringField1)
            ->setStringField2($stringField2)
            ->setStringField3($stringField3)
            ->setStringField4($stringField4)
            ->setStringField5($stringField5)
            ->setStringField6($stringField6)
            ->setStringField7($stringField7)
            ->setTaxExemptNumber($taxExemptNumber)
            ->setType($type)
            ->setUserName($userName)
            ->setVatRegistrationNumber($vatRegistrationNumber)
            ->setWebsite($website)
            ->setZipCode($zipCode);
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get Address2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress2()
    {
        return isset($this->Address2) ? $this->Address2 : null;
    }
    /**
     * Set Address2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address2
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        if (is_null($address2) || (is_array($address2) && empty($address2))) {
            unset($this->Address2);
        } else {
            $this->Address2 = $address2;
        }
        return $this;
    }
    /**
     * Get Address3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress3()
    {
        return isset($this->Address3) ? $this->Address3 : null;
    }
    /**
     * Set Address3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address3
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address3, true), gettype($address3)), __LINE__);
        }
        if (is_null($address3) || (is_array($address3) && empty($address3))) {
            unset($this->Address3);
        } else {
            $this->Address3 = $address3;
        }
        return $this;
    }
    /**
     * Get add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAdd_user()
    {
        return isset($this->add_user) ? $this->add_user : null;
    }
    /**
     * Set add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $add_user
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setAdd_user($add_user = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_user) && !is_bool($add_user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_user, true), gettype($add_user)), __LINE__);
        }
        if (is_null($add_user) || (is_array($add_user) && empty($add_user))) {
            unset($this->add_user);
        } else {
            $this->add_user = $add_user;
        }
        return $this;
    }
    /**
     * Get Birthday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBirthday()
    {
        return isset($this->Birthday) ? $this->Birthday : null;
    }
    /**
     * Set Birthday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $birthday
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setBirthday($birthday = null)
    {
        // validation for constraint: string
        if (!is_null($birthday) && !is_string($birthday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthday, true), gettype($birthday)), __LINE__);
        }
        if (is_null($birthday) || (is_array($birthday) && empty($birthday))) {
            unset($this->Birthday);
        } else {
            $this->Birthday = $birthday;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($city) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($city, true)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get CityIdOrName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityIdOrName()
    {
        return isset($this->CityIdOrName) ? $this->CityIdOrName : null;
    }
    /**
     * Set CityIdOrName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityIdOrName
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setCityIdOrName($cityIdOrName = null)
    {
        // validation for constraint: string
        if (!is_null($cityIdOrName) && !is_string($cityIdOrName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityIdOrName, true), gettype($cityIdOrName)), __LINE__);
        }
        if (is_null($cityIdOrName) || (is_array($cityIdOrName) && empty($cityIdOrName))) {
            unset($this->CityIdOrName);
        } else {
            $this->CityIdOrName = $cityIdOrName;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($country) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($country, true)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get CountryIdOrName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryIdOrName()
    {
        return isset($this->CountryIdOrName) ? $this->CountryIdOrName : null;
    }
    /**
     * Set CountryIdOrName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryIdOrName
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setCountryIdOrName($countryIdOrName = null)
    {
        // validation for constraint: string
        if (!is_null($countryIdOrName) && !is_string($countryIdOrName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryIdOrName, true), gettype($countryIdOrName)), __LINE__);
        }
        if (is_null($countryIdOrName) || (is_array($countryIdOrName) && empty($countryIdOrName))) {
            unset($this->CountryIdOrName);
        } else {
            $this->CountryIdOrName = $countryIdOrName;
        }
        return $this;
    }
    /**
     * Get DataProtection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DataProtection|null
     */
    public function getDataProtection()
    {
        return isset($this->DataProtection) ? $this->DataProtection : null;
    }
    /**
     * Set DataProtection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DataProtection $dataProtection
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setDataProtection(\patest\StructType\DataProtection $dataProtection = null)
    {
        if (is_null($dataProtection) || (is_array($dataProtection) && empty($dataProtection))) {
            unset($this->DataProtection);
        } else {
            $this->DataProtection = $dataProtection;
        }
        return $this;
    }
    /**
     * Get DateTimeField1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTimeField1()
    {
        return isset($this->DateTimeField1) ? $this->DateTimeField1 : null;
    }
    /**
     * Set DateTimeField1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTimeField1
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setDateTimeField1($dateTimeField1 = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeField1) && !is_string($dateTimeField1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeField1, true), gettype($dateTimeField1)), __LINE__);
        }
        if (is_null($dateTimeField1) || (is_array($dateTimeField1) && empty($dateTimeField1))) {
            unset($this->DateTimeField1);
        } else {
            $this->DateTimeField1 = $dateTimeField1;
        }
        return $this;
    }
    /**
     * Get DateTimeField2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTimeField2()
    {
        return isset($this->DateTimeField2) ? $this->DateTimeField2 : null;
    }
    /**
     * Set DateTimeField2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTimeField2
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setDateTimeField2($dateTimeField2 = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeField2) && !is_string($dateTimeField2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeField2, true), gettype($dateTimeField2)), __LINE__);
        }
        if (is_null($dateTimeField2) || (is_array($dateTimeField2) && empty($dateTimeField2))) {
            unset($this->DateTimeField2);
        } else {
            $this->DateTimeField2 = $dateTimeField2;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get Gender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGender()
    {
        return isset($this->Gender) ? $this->Gender : null;
    }
    /**
     * Set Gender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GenderKind::valueIsValid()
     * @uses \patest\EnumType\GenderKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GenderKind::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GenderKind', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \patest\EnumType\GenderKind::getValidValues())), __LINE__);
        }
        if (is_null($gender) || (is_array($gender) && empty($gender))) {
            unset($this->Gender);
        } else {
            $this->Gender = $gender;
        }
        return $this;
    }
    /**
     * Get IDNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDNumber()
    {
        return isset($this->IDNumber) ? $this->IDNumber : null;
    }
    /**
     * Set IDNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDNumber
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setIDNumber($iDNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iDNumber) && !is_string($iDNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDNumber, true), gettype($iDNumber)), __LINE__);
        }
        if (is_null($iDNumber) || (is_array($iDNumber) && empty($iDNumber))) {
            unset($this->IDNumber);
        } else {
            $this->IDNumber = $iDNumber;
        }
        return $this;
    }
    /**
     * Get Initial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInitial()
    {
        return isset($this->Initial) ? $this->Initial : null;
    }
    /**
     * Set Initial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $initial
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setInitial($initial = null)
    {
        // validation for constraint: string
        if (!is_null($initial) && !is_string($initial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initial, true), gettype($initial)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($initial) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $initial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($initial, true)), __LINE__);
        }
        if (is_null($initial) || (is_array($initial) && empty($initial))) {
            unset($this->Initial);
        } else {
            $this->Initial = $initial;
        }
        return $this;
    }
    /**
     * Get Initials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInitials()
    {
        return isset($this->Initials) ? $this->Initials : null;
    }
    /**
     * Set Initials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $initials
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setInitials($initials = null)
    {
        // validation for constraint: string
        if (!is_null($initials) && !is_string($initials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initials, true), gettype($initials)), __LINE__);
        }
        if (is_null($initials) || (is_array($initials) && empty($initials))) {
            unset($this->Initials);
        } else {
            $this->Initials = $initials;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get MiddleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddleName()
    {
        return isset($this->MiddleName) ? $this->MiddleName : null;
    }
    /**
     * Set MiddleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middleName
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        if (is_null($middleName) || (is_array($middleName) && empty($middleName))) {
            unset($this->MiddleName);
        } else {
            $this->MiddleName = $middleName;
        }
        return $this;
    }
    /**
     * Get NamePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNamePrefix()
    {
        return isset($this->NamePrefix) ? $this->NamePrefix : null;
    }
    /**
     * Set NamePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $namePrefix
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setNamePrefix($namePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($namePrefix) && !is_string($namePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namePrefix, true), gettype($namePrefix)), __LINE__);
        }
        if (is_null($namePrefix) || (is_array($namePrefix) && empty($namePrefix))) {
            unset($this->NamePrefix);
        } else {
            $this->NamePrefix = $namePrefix;
        }
        return $this;
    }
    /**
     * Get NameSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameSuffix()
    {
        return isset($this->NameSuffix) ? $this->NameSuffix : null;
    }
    /**
     * Set NameSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameSuffix
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setNameSuffix($nameSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($nameSuffix) && !is_string($nameSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameSuffix, true), gettype($nameSuffix)), __LINE__);
        }
        if (is_null($nameSuffix) || (is_array($nameSuffix) && empty($nameSuffix))) {
            unset($this->NameSuffix);
        } else {
            $this->NameSuffix = $nameSuffix;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get Phone2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone2()
    {
        return isset($this->Phone2) ? $this->Phone2 : null;
    }
    /**
     * Set Phone2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone2
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone2, true), gettype($phone2)), __LINE__);
        }
        if (is_null($phone2) || (is_array($phone2) && empty($phone2))) {
            unset($this->Phone2);
        } else {
            $this->Phone2 = $phone2;
        }
        return $this;
    }
    /**
     * Get Phone3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone3()
    {
        return isset($this->Phone3) ? $this->Phone3 : null;
    }
    /**
     * Set Phone3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone3
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setPhone3($phone3 = null)
    {
        // validation for constraint: string
        if (!is_null($phone3) && !is_string($phone3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone3, true), gettype($phone3)), __LINE__);
        }
        if (is_null($phone3) || (is_array($phone3) && empty($phone3))) {
            unset($this->Phone3);
        } else {
            $this->Phone3 = $phone3;
        }
        return $this;
    }
    /**
     * Get Preferences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Preferences|null
     */
    public function getPreferences()
    {
        return isset($this->Preferences) ? $this->Preferences : null;
    }
    /**
     * Set Preferences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Preferences $preferences
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setPreferences(\patest\StructType\Preferences $preferences = null)
    {
        if (is_null($preferences) || (is_array($preferences) && empty($preferences))) {
            unset($this->Preferences);
        } else {
            $this->Preferences = $preferences;
        }
        return $this;
    }
    /**
     * Get Region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegion()
    {
        return isset($this->Region) ? $this->Region : null;
    }
    /**
     * Set Region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $region
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($region) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($region, true)), __LINE__);
        }
        if (is_null($region) || (is_array($region) && empty($region))) {
            unset($this->Region);
        } else {
            $this->Region = $region;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($state) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($state, true)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get StateIdOrName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateIdOrName()
    {
        return isset($this->StateIdOrName) ? $this->StateIdOrName : null;
    }
    /**
     * Set StateIdOrName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateIdOrName
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setStateIdOrName($stateIdOrName = null)
    {
        // validation for constraint: string
        if (!is_null($stateIdOrName) && !is_string($stateIdOrName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateIdOrName, true), gettype($stateIdOrName)), __LINE__);
        }
        if (is_null($stateIdOrName) || (is_array($stateIdOrName) && empty($stateIdOrName))) {
            unset($this->StateIdOrName);
        } else {
            $this->StateIdOrName = $stateIdOrName;
        }
        return $this;
    }
    /**
     * Get StringField1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField1()
    {
        return isset($this->StringField1) ? $this->StringField1 : null;
    }
    /**
     * Set StringField1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField1
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setStringField1($stringField1 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField1) && !is_string($stringField1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField1, true), gettype($stringField1)), __LINE__);
        }
        if (is_null($stringField1) || (is_array($stringField1) && empty($stringField1))) {
            unset($this->StringField1);
        } else {
            $this->StringField1 = $stringField1;
        }
        return $this;
    }
    /**
     * Get StringField2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField2()
    {
        return isset($this->StringField2) ? $this->StringField2 : null;
    }
    /**
     * Set StringField2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField2
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setStringField2($stringField2 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField2) && !is_string($stringField2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField2, true), gettype($stringField2)), __LINE__);
        }
        if (is_null($stringField2) || (is_array($stringField2) && empty($stringField2))) {
            unset($this->StringField2);
        } else {
            $this->StringField2 = $stringField2;
        }
        return $this;
    }
    /**
     * Get StringField3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField3()
    {
        return isset($this->StringField3) ? $this->StringField3 : null;
    }
    /**
     * Set StringField3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField3
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setStringField3($stringField3 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField3) && !is_string($stringField3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField3, true), gettype($stringField3)), __LINE__);
        }
        if (is_null($stringField3) || (is_array($stringField3) && empty($stringField3))) {
            unset($this->StringField3);
        } else {
            $this->StringField3 = $stringField3;
        }
        return $this;
    }
    /**
     * Get StringField4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField4()
    {
        return isset($this->StringField4) ? $this->StringField4 : null;
    }
    /**
     * Set StringField4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField4
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setStringField4($stringField4 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField4) && !is_string($stringField4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField4, true), gettype($stringField4)), __LINE__);
        }
        if (is_null($stringField4) || (is_array($stringField4) && empty($stringField4))) {
            unset($this->StringField4);
        } else {
            $this->StringField4 = $stringField4;
        }
        return $this;
    }
    /**
     * Get StringField5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField5()
    {
        return isset($this->StringField5) ? $this->StringField5 : null;
    }
    /**
     * Set StringField5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField5
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setStringField5($stringField5 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField5) && !is_string($stringField5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField5, true), gettype($stringField5)), __LINE__);
        }
        if (is_null($stringField5) || (is_array($stringField5) && empty($stringField5))) {
            unset($this->StringField5);
        } else {
            $this->StringField5 = $stringField5;
        }
        return $this;
    }
    /**
     * Get StringField6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField6()
    {
        return isset($this->StringField6) ? $this->StringField6 : null;
    }
    /**
     * Set StringField6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField6
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setStringField6($stringField6 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField6) && !is_string($stringField6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField6, true), gettype($stringField6)), __LINE__);
        }
        if (is_null($stringField6) || (is_array($stringField6) && empty($stringField6))) {
            unset($this->StringField6);
        } else {
            $this->StringField6 = $stringField6;
        }
        return $this;
    }
    /**
     * Get StringField7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField7()
    {
        return isset($this->StringField7) ? $this->StringField7 : null;
    }
    /**
     * Set StringField7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField7
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setStringField7($stringField7 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField7) && !is_string($stringField7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField7, true), gettype($stringField7)), __LINE__);
        }
        if (is_null($stringField7) || (is_array($stringField7) && empty($stringField7))) {
            unset($this->StringField7);
        } else {
            $this->StringField7 = $stringField7;
        }
        return $this;
    }
    /**
     * Get TaxExemptNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxExemptNumber()
    {
        return isset($this->TaxExemptNumber) ? $this->TaxExemptNumber : null;
    }
    /**
     * Set TaxExemptNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxExemptNumber
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setTaxExemptNumber($taxExemptNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxExemptNumber) && !is_string($taxExemptNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxExemptNumber, true), gettype($taxExemptNumber)), __LINE__);
        }
        if (is_null($taxExemptNumber) || (is_array($taxExemptNumber) && empty($taxExemptNumber))) {
            unset($this->TaxExemptNumber);
        } else {
            $this->TaxExemptNumber = $taxExemptNumber;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * This method is responsible for validating the values passed to the setType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeForArrayConstraintsFromSetType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eSRO_Crm_UserDataFormTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($eSRO_Crm_UserDataFormTypeItem)) {
                $invalidValues[] = is_object($eSRO_Crm_UserDataFormTypeItem) ? get_class($eSRO_Crm_UserDataFormTypeItem) : sprintf('%s(%s)', gettype($eSRO_Crm_UserDataFormTypeItem), var_export($eSRO_Crm_UserDataFormTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $type
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setType(array $type = array())
    {
        // validation for constraint: list
        if ('' !== ($typeArrayErrorMessage = self::validateTypeForArrayConstraintsFromSetType($type))) {
            throw new \InvalidArgumentException($typeArrayErrorMessage, __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = is_array($type) ? implode(' ', $type) : null;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get VatRegistrationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVatRegistrationNumber()
    {
        return isset($this->VatRegistrationNumber) ? $this->VatRegistrationNumber : null;
    }
    /**
     * Set VatRegistrationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vatRegistrationNumber
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setVatRegistrationNumber($vatRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegistrationNumber) && !is_string($vatRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegistrationNumber, true), gettype($vatRegistrationNumber)), __LINE__);
        }
        if (is_null($vatRegistrationNumber) || (is_array($vatRegistrationNumber) && empty($vatRegistrationNumber))) {
            unset($this->VatRegistrationNumber);
        } else {
            $this->VatRegistrationNumber = $vatRegistrationNumber;
        }
        return $this;
    }
    /**
     * Get Website value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebsite()
    {
        return isset($this->Website) ? $this->Website : null;
    }
    /**
     * Set Website value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $website
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setWebsite($website = null)
    {
        // validation for constraint: string
        if (!is_null($website) && !is_string($website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($website, true), gettype($website)), __LINE__);
        }
        if (is_null($website) || (is_array($website) && empty($website))) {
            unset($this->Website);
        } else {
            $this->Website = $website;
        }
        return $this;
    }
    /**
     * Get ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCode()
    {
        return isset($this->ZipCode) ? $this->ZipCode : null;
    }
    /**
     * Set ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipCode
     * @return \patest\StructType\ESRO_Crm_UserDataForm
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        if (is_null($zipCode) || (is_array($zipCode) && empty($zipCode))) {
            unset($this->ZipCode);
        } else {
            $this->ZipCode = $zipCode;
        }
        return $this;
    }
}
