<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eSRO.Basket.AbstractPaymentItem StructType
 * @subpackage Structs
 */
class ESRO_Basket_AbstractPaymentItem extends ESRO_Basket_AbstractItem
{
    /**
     * The PaymentMethodImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodImage;
    /**
     * The PaymentValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaymentValue;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for eSRO.Basket.AbstractPaymentItem
     * @uses ESRO_Basket_AbstractPaymentItem::setPaymentMethodImage()
     * @uses ESRO_Basket_AbstractPaymentItem::setPaymentValue()
     * @uses ESRO_Basket_AbstractPaymentItem::setType()
     * @param string $paymentMethodImage
     * @param \patest\StructType\Money $paymentValue
     * @param string $type
     */
    public function __construct($paymentMethodImage = null, \patest\StructType\Money $paymentValue = null, $type = null)
    {
        $this
            ->setPaymentMethodImage($paymentMethodImage)
            ->setPaymentValue($paymentValue)
            ->setType($type);
    }
    /**
     * Get PaymentMethodImage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodImage()
    {
        return isset($this->PaymentMethodImage) ? $this->PaymentMethodImage : null;
    }
    /**
     * Set PaymentMethodImage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodImage
     * @return \patest\StructType\ESRO_Basket_AbstractPaymentItem
     */
    public function setPaymentMethodImage($paymentMethodImage = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodImage) && !is_string($paymentMethodImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodImage, true), gettype($paymentMethodImage)), __LINE__);
        }
        if (is_null($paymentMethodImage) || (is_array($paymentMethodImage) && empty($paymentMethodImage))) {
            unset($this->PaymentMethodImage);
        } else {
            $this->PaymentMethodImage = $paymentMethodImage;
        }
        return $this;
    }
    /**
     * Get PaymentValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaymentValue()
    {
        return isset($this->PaymentValue) ? $this->PaymentValue : null;
    }
    /**
     * Set PaymentValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paymentValue
     * @return \patest\StructType\ESRO_Basket_AbstractPaymentItem
     */
    public function setPaymentValue(\patest\StructType\Money $paymentValue = null)
    {
        if (is_null($paymentValue) || (is_array($paymentValue) && empty($paymentValue))) {
            unset($this->PaymentValue);
        } else {
            $this->PaymentValue = $paymentValue;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \patest\StructType\ESRO_Basket_AbstractPaymentItem
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
