<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Donation.Pledge StructType
 * @subpackage Structs
 */
class Donation_Pledge extends DistributableEntity
{
    /**
     * The AcknowledgementRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AcknowledgementRequired;
    /**
     * The AppealId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealId;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CampaignId;
    /**
     * The ChannelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ChannelId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The CreditCardToken
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreditCardToken;
    /**
     * The DefaultAmountPerInstallment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DefaultAmountPerInstallment;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The FirstInstallmentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstInstallmentDate;
    /**
     * The FundId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FundId;
    /**
     * The FundName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $FundName;
    /**
     * The GenerateTaxStatement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GenerateTaxStatement;
    /**
     * The GenerateThankYouLetter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GenerateThankYouLetter;
    /**
     * The InstallmentPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentPaymentMethodId;
    /**
     * The Installments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfDonation_PledgeInstallment
     */
    public $Installments;
    /**
     * The InstallmentSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentSchedule;
    /**
     * The InstallmentsType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentsType;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsAnonymous
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAnonymous;
    /**
     * The MandateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MandateId;
    /**
     * The MandateTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MandateTypeId;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notification;
    /**
     * The NumberOfInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfInstallments;
    /**
     * The NumberOfWriteOffs
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfWriteOffs;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PaymentDefinitionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentDefinitionType;
    /**
     * The PayOnDayOfMonth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PayOnDayOfMonth;
    /**
     * The PayOnDayOfWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayOnDayOfWeek;
    /**
     * The PersonToTribute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PersonToTribute;
    /**
     * The SolicitorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SolicitorId;
    /**
     * The ThankYouLetterSpecialMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThankYouLetterSpecialMessage;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmount;
    /**
     * The TributeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeType;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Donation.Pledge
     * @uses Donation_Pledge::setAcknowledgementRequired()
     * @uses Donation_Pledge::setAppealId()
     * @uses Donation_Pledge::setCampaignId()
     * @uses Donation_Pledge::setChannelId()
     * @uses Donation_Pledge::setClientId()
     * @uses Donation_Pledge::setCreationDate()
     * @uses Donation_Pledge::setCreditCardToken()
     * @uses Donation_Pledge::setDefaultAmountPerInstallment()
     * @uses Donation_Pledge::setDisplayName()
     * @uses Donation_Pledge::setFirstInstallmentDate()
     * @uses Donation_Pledge::setFundId()
     * @uses Donation_Pledge::setFundName()
     * @uses Donation_Pledge::setGenerateTaxStatement()
     * @uses Donation_Pledge::setGenerateThankYouLetter()
     * @uses Donation_Pledge::setInstallmentPaymentMethodId()
     * @uses Donation_Pledge::setInstallments()
     * @uses Donation_Pledge::setInstallmentSchedule()
     * @uses Donation_Pledge::setInstallmentsType()
     * @uses Donation_Pledge::setIsActive()
     * @uses Donation_Pledge::setIsAnonymous()
     * @uses Donation_Pledge::setMandateId()
     * @uses Donation_Pledge::setMandateTypeId()
     * @uses Donation_Pledge::setMessage()
     * @uses Donation_Pledge::setNotification()
     * @uses Donation_Pledge::setNumberOfInstallments()
     * @uses Donation_Pledge::setNumberOfWriteOffs()
     * @uses Donation_Pledge::setOrganizationUnitId()
     * @uses Donation_Pledge::setPaymentDefinitionType()
     * @uses Donation_Pledge::setPayOnDayOfMonth()
     * @uses Donation_Pledge::setPayOnDayOfWeek()
     * @uses Donation_Pledge::setPersonToTribute()
     * @uses Donation_Pledge::setSolicitorId()
     * @uses Donation_Pledge::setThankYouLetterSpecialMessage()
     * @uses Donation_Pledge::setTotalAmount()
     * @uses Donation_Pledge::setTributeType()
     * @uses Donation_Pledge::setVisibleBySubordinates()
     * @param bool $acknowledgementRequired
     * @param string $appealId
     * @param string $campaignId
     * @param string $channelId
     * @param string $clientId
     * @param string $creationDate
     * @param string $creditCardToken
     * @param \patest\StructType\Money $defaultAmountPerInstallment
     * @param string $displayName
     * @param string $firstInstallmentDate
     * @param string $fundId
     * @param \patest\StructType\GlobalString $fundName
     * @param bool $generateTaxStatement
     * @param bool $generateThankYouLetter
     * @param string $installmentPaymentMethodId
     * @param \patest\StructType\RecordSetOfDonation_PledgeInstallment $installments
     * @param string $installmentSchedule
     * @param string $installmentsType
     * @param bool $isActive
     * @param bool $isAnonymous
     * @param string $mandateId
     * @param string $mandateTypeId
     * @param string $message
     * @param string $notification
     * @param int $numberOfInstallments
     * @param int $numberOfWriteOffs
     * @param string $organizationUnitId
     * @param string $paymentDefinitionType
     * @param int $payOnDayOfMonth
     * @param string $payOnDayOfWeek
     * @param string $personToTribute
     * @param string $solicitorId
     * @param string $thankYouLetterSpecialMessage
     * @param \patest\StructType\Money $totalAmount
     * @param string $tributeType
     * @param bool $visibleBySubordinates
     */
    public function __construct($acknowledgementRequired = null, $appealId = null, $campaignId = null, $channelId = null, $clientId = null, $creationDate = null, $creditCardToken = null, \patest\StructType\Money $defaultAmountPerInstallment = null, $displayName = null, $firstInstallmentDate = null, $fundId = null, \patest\StructType\GlobalString $fundName = null, $generateTaxStatement = null, $generateThankYouLetter = null, $installmentPaymentMethodId = null, \patest\StructType\RecordSetOfDonation_PledgeInstallment $installments = null, $installmentSchedule = null, $installmentsType = null, $isActive = null, $isAnonymous = null, $mandateId = null, $mandateTypeId = null, $message = null, $notification = null, $numberOfInstallments = null, $numberOfWriteOffs = null, $organizationUnitId = null, $paymentDefinitionType = null, $payOnDayOfMonth = null, $payOnDayOfWeek = null, $personToTribute = null, $solicitorId = null, $thankYouLetterSpecialMessage = null, \patest\StructType\Money $totalAmount = null, $tributeType = null, $visibleBySubordinates = null)
    {
        $this
            ->setAcknowledgementRequired($acknowledgementRequired)
            ->setAppealId($appealId)
            ->setCampaignId($campaignId)
            ->setChannelId($channelId)
            ->setClientId($clientId)
            ->setCreationDate($creationDate)
            ->setCreditCardToken($creditCardToken)
            ->setDefaultAmountPerInstallment($defaultAmountPerInstallment)
            ->setDisplayName($displayName)
            ->setFirstInstallmentDate($firstInstallmentDate)
            ->setFundId($fundId)
            ->setFundName($fundName)
            ->setGenerateTaxStatement($generateTaxStatement)
            ->setGenerateThankYouLetter($generateThankYouLetter)
            ->setInstallmentPaymentMethodId($installmentPaymentMethodId)
            ->setInstallments($installments)
            ->setInstallmentSchedule($installmentSchedule)
            ->setInstallmentsType($installmentsType)
            ->setIsActive($isActive)
            ->setIsAnonymous($isAnonymous)
            ->setMandateId($mandateId)
            ->setMandateTypeId($mandateTypeId)
            ->setMessage($message)
            ->setNotification($notification)
            ->setNumberOfInstallments($numberOfInstallments)
            ->setNumberOfWriteOffs($numberOfWriteOffs)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPaymentDefinitionType($paymentDefinitionType)
            ->setPayOnDayOfMonth($payOnDayOfMonth)
            ->setPayOnDayOfWeek($payOnDayOfWeek)
            ->setPersonToTribute($personToTribute)
            ->setSolicitorId($solicitorId)
            ->setThankYouLetterSpecialMessage($thankYouLetterSpecialMessage)
            ->setTotalAmount($totalAmount)
            ->setTributeType($tributeType)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AcknowledgementRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAcknowledgementRequired()
    {
        return isset($this->AcknowledgementRequired) ? $this->AcknowledgementRequired : null;
    }
    /**
     * Set AcknowledgementRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $acknowledgementRequired
     * @return \patest\StructType\Donation_Pledge
     */
    public function setAcknowledgementRequired($acknowledgementRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($acknowledgementRequired) && !is_bool($acknowledgementRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($acknowledgementRequired, true), gettype($acknowledgementRequired)), __LINE__);
        }
        if (is_null($acknowledgementRequired) || (is_array($acknowledgementRequired) && empty($acknowledgementRequired))) {
            unset($this->AcknowledgementRequired);
        } else {
            $this->AcknowledgementRequired = $acknowledgementRequired;
        }
        return $this;
    }
    /**
     * Get AppealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealId()
    {
        return isset($this->AppealId) ? $this->AppealId : null;
    }
    /**
     * Set AppealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealId
     * @return \patest\StructType\Donation_Pledge
     */
    public function setAppealId($appealId = null)
    {
        // validation for constraint: string
        if (!is_null($appealId) && !is_string($appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealId, true), gettype($appealId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealId, true)), __LINE__);
        }
        if (is_null($appealId) || (is_array($appealId) && empty($appealId))) {
            unset($this->AppealId);
        } else {
            $this->AppealId = $appealId;
        }
        return $this;
    }
    /**
     * Get CampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignId()
    {
        return isset($this->CampaignId) ? $this->CampaignId : null;
    }
    /**
     * Set CampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignId
     * @return \patest\StructType\Donation_Pledge
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: string
        if (!is_null($campaignId) && !is_string($campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($campaignId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($campaignId, true)), __LINE__);
        }
        if (is_null($campaignId) || (is_array($campaignId) && empty($campaignId))) {
            unset($this->CampaignId);
        } else {
            $this->CampaignId = $campaignId;
        }
        return $this;
    }
    /**
     * Get ChannelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannelId()
    {
        return isset($this->ChannelId) ? $this->ChannelId : null;
    }
    /**
     * Set ChannelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channelId
     * @return \patest\StructType\Donation_Pledge
     */
    public function setChannelId($channelId = null)
    {
        // validation for constraint: string
        if (!is_null($channelId) && !is_string($channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channelId, true), gettype($channelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($channelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($channelId, true)), __LINE__);
        }
        if (is_null($channelId) || (is_array($channelId) && empty($channelId))) {
            unset($this->ChannelId);
        } else {
            $this->ChannelId = $channelId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Donation_Pledge
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Donation_Pledge
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get CreditCardToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardToken()
    {
        return isset($this->CreditCardToken) ? $this->CreditCardToken : null;
    }
    /**
     * Set CreditCardToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardToken
     * @return \patest\StructType\Donation_Pledge
     */
    public function setCreditCardToken($creditCardToken = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardToken) && !is_string($creditCardToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardToken, true), gettype($creditCardToken)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($creditCardToken) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $creditCardToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($creditCardToken, true)), __LINE__);
        }
        if (is_null($creditCardToken) || (is_array($creditCardToken) && empty($creditCardToken))) {
            unset($this->CreditCardToken);
        } else {
            $this->CreditCardToken = $creditCardToken;
        }
        return $this;
    }
    /**
     * Get DefaultAmountPerInstallment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDefaultAmountPerInstallment()
    {
        return isset($this->DefaultAmountPerInstallment) ? $this->DefaultAmountPerInstallment : null;
    }
    /**
     * Set DefaultAmountPerInstallment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $defaultAmountPerInstallment
     * @return \patest\StructType\Donation_Pledge
     */
    public function setDefaultAmountPerInstallment(\patest\StructType\Money $defaultAmountPerInstallment = null)
    {
        if (is_null($defaultAmountPerInstallment) || (is_array($defaultAmountPerInstallment) && empty($defaultAmountPerInstallment))) {
            unset($this->DefaultAmountPerInstallment);
        } else {
            $this->DefaultAmountPerInstallment = $defaultAmountPerInstallment;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \patest\StructType\Donation_Pledge
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get FirstInstallmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstInstallmentDate()
    {
        return isset($this->FirstInstallmentDate) ? $this->FirstInstallmentDate : null;
    }
    /**
     * Set FirstInstallmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstInstallmentDate
     * @return \patest\StructType\Donation_Pledge
     */
    public function setFirstInstallmentDate($firstInstallmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstInstallmentDate) && !is_string($firstInstallmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstInstallmentDate, true), gettype($firstInstallmentDate)), __LINE__);
        }
        if (is_null($firstInstallmentDate) || (is_array($firstInstallmentDate) && empty($firstInstallmentDate))) {
            unset($this->FirstInstallmentDate);
        } else {
            $this->FirstInstallmentDate = $firstInstallmentDate;
        }
        return $this;
    }
    /**
     * Get FundId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFundId()
    {
        return isset($this->FundId) ? $this->FundId : null;
    }
    /**
     * Set FundId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fundId
     * @return \patest\StructType\Donation_Pledge
     */
    public function setFundId($fundId = null)
    {
        // validation for constraint: string
        if (!is_null($fundId) && !is_string($fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fundId, true), gettype($fundId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fundId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fundId, true)), __LINE__);
        }
        if (is_null($fundId) || (is_array($fundId) && empty($fundId))) {
            unset($this->FundId);
        } else {
            $this->FundId = $fundId;
        }
        return $this;
    }
    /**
     * Get FundName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFundName()
    {
        return isset($this->FundName) ? $this->FundName : null;
    }
    /**
     * Set FundName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $fundName
     * @return \patest\StructType\Donation_Pledge
     */
    public function setFundName(\patest\StructType\GlobalString $fundName = null)
    {
        if (is_null($fundName) || (is_array($fundName) && empty($fundName))) {
            unset($this->FundName);
        } else {
            $this->FundName = $fundName;
        }
        return $this;
    }
    /**
     * Get GenerateTaxStatement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGenerateTaxStatement()
    {
        return isset($this->GenerateTaxStatement) ? $this->GenerateTaxStatement : null;
    }
    /**
     * Set GenerateTaxStatement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $generateTaxStatement
     * @return \patest\StructType\Donation_Pledge
     */
    public function setGenerateTaxStatement($generateTaxStatement = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateTaxStatement) && !is_bool($generateTaxStatement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateTaxStatement, true), gettype($generateTaxStatement)), __LINE__);
        }
        if (is_null($generateTaxStatement) || (is_array($generateTaxStatement) && empty($generateTaxStatement))) {
            unset($this->GenerateTaxStatement);
        } else {
            $this->GenerateTaxStatement = $generateTaxStatement;
        }
        return $this;
    }
    /**
     * Get GenerateThankYouLetter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGenerateThankYouLetter()
    {
        return isset($this->GenerateThankYouLetter) ? $this->GenerateThankYouLetter : null;
    }
    /**
     * Set GenerateThankYouLetter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $generateThankYouLetter
     * @return \patest\StructType\Donation_Pledge
     */
    public function setGenerateThankYouLetter($generateThankYouLetter = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateThankYouLetter) && !is_bool($generateThankYouLetter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateThankYouLetter, true), gettype($generateThankYouLetter)), __LINE__);
        }
        if (is_null($generateThankYouLetter) || (is_array($generateThankYouLetter) && empty($generateThankYouLetter))) {
            unset($this->GenerateThankYouLetter);
        } else {
            $this->GenerateThankYouLetter = $generateThankYouLetter;
        }
        return $this;
    }
    /**
     * Get InstallmentPaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentPaymentMethodId()
    {
        return isset($this->InstallmentPaymentMethodId) ? $this->InstallmentPaymentMethodId : null;
    }
    /**
     * Set InstallmentPaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentPaymentMethodId
     * @return \patest\StructType\Donation_Pledge
     */
    public function setInstallmentPaymentMethodId($installmentPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentPaymentMethodId) && !is_string($installmentPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentPaymentMethodId, true), gettype($installmentPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentPaymentMethodId, true)), __LINE__);
        }
        if (is_null($installmentPaymentMethodId) || (is_array($installmentPaymentMethodId) && empty($installmentPaymentMethodId))) {
            unset($this->InstallmentPaymentMethodId);
        } else {
            $this->InstallmentPaymentMethodId = $installmentPaymentMethodId;
        }
        return $this;
    }
    /**
     * Get Installments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfDonation_PledgeInstallment|null
     */
    public function getInstallments()
    {
        return isset($this->Installments) ? $this->Installments : null;
    }
    /**
     * Set Installments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfDonation_PledgeInstallment $installments
     * @return \patest\StructType\Donation_Pledge
     */
    public function setInstallments(\patest\StructType\RecordSetOfDonation_PledgeInstallment $installments = null)
    {
        if (is_null($installments) || (is_array($installments) && empty($installments))) {
            unset($this->Installments);
        } else {
            $this->Installments = $installments;
        }
        return $this;
    }
    /**
     * Get InstallmentSchedule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentSchedule()
    {
        return isset($this->InstallmentSchedule) ? $this->InstallmentSchedule : null;
    }
    /**
     * Set InstallmentSchedule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PledgeInstallmentsSchedule::valueIsValid()
     * @uses \patest\EnumType\PledgeInstallmentsSchedule::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentSchedule
     * @return \patest\StructType\Donation_Pledge
     */
    public function setInstallmentSchedule($installmentSchedule = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PledgeInstallmentsSchedule::valueIsValid($installmentSchedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PledgeInstallmentsSchedule', is_array($installmentSchedule) ? implode(', ', $installmentSchedule) : var_export($installmentSchedule, true), implode(', ', \patest\EnumType\PledgeInstallmentsSchedule::getValidValues())), __LINE__);
        }
        if (is_null($installmentSchedule) || (is_array($installmentSchedule) && empty($installmentSchedule))) {
            unset($this->InstallmentSchedule);
        } else {
            $this->InstallmentSchedule = $installmentSchedule;
        }
        return $this;
    }
    /**
     * Get InstallmentsType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsType()
    {
        return isset($this->InstallmentsType) ? $this->InstallmentsType : null;
    }
    /**
     * Set InstallmentsType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PledgeInstallmentsType::valueIsValid()
     * @uses \patest\EnumType\PledgeInstallmentsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentsType
     * @return \patest\StructType\Donation_Pledge
     */
    public function setInstallmentsType($installmentsType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PledgeInstallmentsType::valueIsValid($installmentsType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PledgeInstallmentsType', is_array($installmentsType) ? implode(', ', $installmentsType) : var_export($installmentsType, true), implode(', ', \patest\EnumType\PledgeInstallmentsType::getValidValues())), __LINE__);
        }
        if (is_null($installmentsType) || (is_array($installmentsType) && empty($installmentsType))) {
            unset($this->InstallmentsType);
        } else {
            $this->InstallmentsType = $installmentsType;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Donation_Pledge
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsAnonymous value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAnonymous()
    {
        return isset($this->IsAnonymous) ? $this->IsAnonymous : null;
    }
    /**
     * Set IsAnonymous value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAnonymous
     * @return \patest\StructType\Donation_Pledge
     */
    public function setIsAnonymous($isAnonymous = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAnonymous) && !is_bool($isAnonymous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAnonymous, true), gettype($isAnonymous)), __LINE__);
        }
        if (is_null($isAnonymous) || (is_array($isAnonymous) && empty($isAnonymous))) {
            unset($this->IsAnonymous);
        } else {
            $this->IsAnonymous = $isAnonymous;
        }
        return $this;
    }
    /**
     * Get MandateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateId()
    {
        return isset($this->MandateId) ? $this->MandateId : null;
    }
    /**
     * Set MandateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateId
     * @return \patest\StructType\Donation_Pledge
     */
    public function setMandateId($mandateId = null)
    {
        // validation for constraint: string
        if (!is_null($mandateId) && !is_string($mandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateId, true), gettype($mandateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mandateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mandateId, true)), __LINE__);
        }
        if (is_null($mandateId) || (is_array($mandateId) && empty($mandateId))) {
            unset($this->MandateId);
        } else {
            $this->MandateId = $mandateId;
        }
        return $this;
    }
    /**
     * Get MandateTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateTypeId()
    {
        return isset($this->MandateTypeId) ? $this->MandateTypeId : null;
    }
    /**
     * Set MandateTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateTypeId
     * @return \patest\StructType\Donation_Pledge
     */
    public function setMandateTypeId($mandateTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($mandateTypeId) && !is_string($mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateTypeId, true), gettype($mandateTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mandateTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mandateTypeId, true)), __LINE__);
        }
        if (is_null($mandateTypeId) || (is_array($mandateTypeId) && empty($mandateTypeId))) {
            unset($this->MandateTypeId);
        } else {
            $this->MandateTypeId = $mandateTypeId;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \patest\StructType\Donation_Pledge
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get Notification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotification()
    {
        return isset($this->Notification) ? $this->Notification : null;
    }
    /**
     * Set Notification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notification
     * @return \patest\StructType\Donation_Pledge
     */
    public function setNotification($notification = null)
    {
        // validation for constraint: string
        if (!is_null($notification) && !is_string($notification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notification, true), gettype($notification)), __LINE__);
        }
        if (is_null($notification) || (is_array($notification) && empty($notification))) {
            unset($this->Notification);
        } else {
            $this->Notification = $notification;
        }
        return $this;
    }
    /**
     * Get NumberOfInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfInstallments()
    {
        return isset($this->NumberOfInstallments) ? $this->NumberOfInstallments : null;
    }
    /**
     * Set NumberOfInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfInstallments
     * @return \patest\StructType\Donation_Pledge
     */
    public function setNumberOfInstallments($numberOfInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInstallments) && !(is_int($numberOfInstallments) || ctype_digit($numberOfInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfInstallments, true), gettype($numberOfInstallments)), __LINE__);
        }
        if (is_null($numberOfInstallments) || (is_array($numberOfInstallments) && empty($numberOfInstallments))) {
            unset($this->NumberOfInstallments);
        } else {
            $this->NumberOfInstallments = $numberOfInstallments;
        }
        return $this;
    }
    /**
     * Get NumberOfWriteOffs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfWriteOffs()
    {
        return isset($this->NumberOfWriteOffs) ? $this->NumberOfWriteOffs : null;
    }
    /**
     * Set NumberOfWriteOffs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfWriteOffs
     * @return \patest\StructType\Donation_Pledge
     */
    public function setNumberOfWriteOffs($numberOfWriteOffs = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfWriteOffs) && !(is_int($numberOfWriteOffs) || ctype_digit($numberOfWriteOffs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfWriteOffs, true), gettype($numberOfWriteOffs)), __LINE__);
        }
        if (is_null($numberOfWriteOffs) || (is_array($numberOfWriteOffs) && empty($numberOfWriteOffs))) {
            unset($this->NumberOfWriteOffs);
        } else {
            $this->NumberOfWriteOffs = $numberOfWriteOffs;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Donation_Pledge
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PaymentDefinitionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentDefinitionType()
    {
        return isset($this->PaymentDefinitionType) ? $this->PaymentDefinitionType : null;
    }
    /**
     * Set PaymentDefinitionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PledgePaymentDefinitionType::valueIsValid()
     * @uses \patest\EnumType\PledgePaymentDefinitionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentDefinitionType
     * @return \patest\StructType\Donation_Pledge
     */
    public function setPaymentDefinitionType($paymentDefinitionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PledgePaymentDefinitionType::valueIsValid($paymentDefinitionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PledgePaymentDefinitionType', is_array($paymentDefinitionType) ? implode(', ', $paymentDefinitionType) : var_export($paymentDefinitionType, true), implode(', ', \patest\EnumType\PledgePaymentDefinitionType::getValidValues())), __LINE__);
        }
        if (is_null($paymentDefinitionType) || (is_array($paymentDefinitionType) && empty($paymentDefinitionType))) {
            unset($this->PaymentDefinitionType);
        } else {
            $this->PaymentDefinitionType = $paymentDefinitionType;
        }
        return $this;
    }
    /**
     * Get PayOnDayOfMonth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPayOnDayOfMonth()
    {
        return isset($this->PayOnDayOfMonth) ? $this->PayOnDayOfMonth : null;
    }
    /**
     * Set PayOnDayOfMonth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $payOnDayOfMonth
     * @return \patest\StructType\Donation_Pledge
     */
    public function setPayOnDayOfMonth($payOnDayOfMonth = null)
    {
        // validation for constraint: int
        if (!is_null($payOnDayOfMonth) && !(is_int($payOnDayOfMonth) || ctype_digit($payOnDayOfMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payOnDayOfMonth, true), gettype($payOnDayOfMonth)), __LINE__);
        }
        if (is_null($payOnDayOfMonth) || (is_array($payOnDayOfMonth) && empty($payOnDayOfMonth))) {
            unset($this->PayOnDayOfMonth);
        } else {
            $this->PayOnDayOfMonth = $payOnDayOfMonth;
        }
        return $this;
    }
    /**
     * Get PayOnDayOfWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayOnDayOfWeek()
    {
        return isset($this->PayOnDayOfWeek) ? $this->PayOnDayOfWeek : null;
    }
    /**
     * Set PayOnDayOfWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DayOfWeek::valueIsValid()
     * @uses \patest\EnumType\DayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $payOnDayOfWeek
     * @return \patest\StructType\Donation_Pledge
     */
    public function setPayOnDayOfWeek($payOnDayOfWeek = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DayOfWeek::valueIsValid($payOnDayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DayOfWeek', is_array($payOnDayOfWeek) ? implode(', ', $payOnDayOfWeek) : var_export($payOnDayOfWeek, true), implode(', ', \patest\EnumType\DayOfWeek::getValidValues())), __LINE__);
        }
        if (is_null($payOnDayOfWeek) || (is_array($payOnDayOfWeek) && empty($payOnDayOfWeek))) {
            unset($this->PayOnDayOfWeek);
        } else {
            $this->PayOnDayOfWeek = $payOnDayOfWeek;
        }
        return $this;
    }
    /**
     * Get PersonToTribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonToTribute()
    {
        return isset($this->PersonToTribute) ? $this->PersonToTribute : null;
    }
    /**
     * Set PersonToTribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personToTribute
     * @return \patest\StructType\Donation_Pledge
     */
    public function setPersonToTribute($personToTribute = null)
    {
        // validation for constraint: string
        if (!is_null($personToTribute) && !is_string($personToTribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personToTribute, true), gettype($personToTribute)), __LINE__);
        }
        if (is_null($personToTribute) || (is_array($personToTribute) && empty($personToTribute))) {
            unset($this->PersonToTribute);
        } else {
            $this->PersonToTribute = $personToTribute;
        }
        return $this;
    }
    /**
     * Get SolicitorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSolicitorId()
    {
        return isset($this->SolicitorId) ? $this->SolicitorId : null;
    }
    /**
     * Set SolicitorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $solicitorId
     * @return \patest\StructType\Donation_Pledge
     */
    public function setSolicitorId($solicitorId = null)
    {
        // validation for constraint: string
        if (!is_null($solicitorId) && !is_string($solicitorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($solicitorId, true), gettype($solicitorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($solicitorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $solicitorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($solicitorId, true)), __LINE__);
        }
        if (is_null($solicitorId) || (is_array($solicitorId) && empty($solicitorId))) {
            unset($this->SolicitorId);
        } else {
            $this->SolicitorId = $solicitorId;
        }
        return $this;
    }
    /**
     * Get ThankYouLetterSpecialMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThankYouLetterSpecialMessage()
    {
        return isset($this->ThankYouLetterSpecialMessage) ? $this->ThankYouLetterSpecialMessage : null;
    }
    /**
     * Set ThankYouLetterSpecialMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thankYouLetterSpecialMessage
     * @return \patest\StructType\Donation_Pledge
     */
    public function setThankYouLetterSpecialMessage($thankYouLetterSpecialMessage = null)
    {
        // validation for constraint: string
        if (!is_null($thankYouLetterSpecialMessage) && !is_string($thankYouLetterSpecialMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thankYouLetterSpecialMessage, true), gettype($thankYouLetterSpecialMessage)), __LINE__);
        }
        if (is_null($thankYouLetterSpecialMessage) || (is_array($thankYouLetterSpecialMessage) && empty($thankYouLetterSpecialMessage))) {
            unset($this->ThankYouLetterSpecialMessage);
        } else {
            $this->ThankYouLetterSpecialMessage = $thankYouLetterSpecialMessage;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmount
     * @return \patest\StructType\Donation_Pledge
     */
    public function setTotalAmount(\patest\StructType\Money $totalAmount = null)
    {
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get TributeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeType()
    {
        return isset($this->TributeType) ? $this->TributeType : null;
    }
    /**
     * Set TributeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TributeType::valueIsValid()
     * @uses \patest\EnumType\TributeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tributeType
     * @return \patest\StructType\Donation_Pledge
     */
    public function setTributeType($tributeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TributeType::valueIsValid($tributeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TributeType', is_array($tributeType) ? implode(', ', $tributeType) : var_export($tributeType, true), implode(', ', \patest\EnumType\TributeType::getValidValues())), __LINE__);
        }
        if (is_null($tributeType) || (is_array($tributeType) && empty($tributeType))) {
            unset($this->TributeType);
        } else {
            $this->TributeType = $tributeType;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Donation_Pledge
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
