<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Donation.MatchingGiftsForClient StructType
 * @subpackage Structs
 */
class Donation_MatchingGiftsForClient extends AnyEntity
{
    /**
     * The BillingDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BillingDate;
    /**
     * The DonationTotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DonationTotalAmount;
    /**
     * The IsSelected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSelected;
    /**
     * The LastPrintDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastPrintDateTime;
    /**
     * The LastSentByEmailDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastSentByEmailDateTime;
    /**
     * The LastSentByEmailTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastSentByEmailTo;
    /**
     * The MatchAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MatchAmount;
    /**
     * The MatcherId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MatcherId;
    /**
     * The NumberOfDonations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfDonations;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PaidAmount;
    /**
     * The Remaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Remaining;
    /**
     * Constructor method for Donation.MatchingGiftsForClient
     * @uses Donation_MatchingGiftsForClient::setBillingDate()
     * @uses Donation_MatchingGiftsForClient::setDonationTotalAmount()
     * @uses Donation_MatchingGiftsForClient::setIsSelected()
     * @uses Donation_MatchingGiftsForClient::setLastPrintDateTime()
     * @uses Donation_MatchingGiftsForClient::setLastSentByEmailDateTime()
     * @uses Donation_MatchingGiftsForClient::setLastSentByEmailTo()
     * @uses Donation_MatchingGiftsForClient::setMatchAmount()
     * @uses Donation_MatchingGiftsForClient::setMatcherId()
     * @uses Donation_MatchingGiftsForClient::setNumberOfDonations()
     * @uses Donation_MatchingGiftsForClient::setPaidAmount()
     * @uses Donation_MatchingGiftsForClient::setRemaining()
     * @param string $billingDate
     * @param float $donationTotalAmount
     * @param bool $isSelected
     * @param string $lastPrintDateTime
     * @param string $lastSentByEmailDateTime
     * @param string $lastSentByEmailTo
     * @param float $matchAmount
     * @param string $matcherId
     * @param int $numberOfDonations
     * @param float $paidAmount
     * @param float $remaining
     */
    public function __construct($billingDate = null, $donationTotalAmount = null, $isSelected = null, $lastPrintDateTime = null, $lastSentByEmailDateTime = null, $lastSentByEmailTo = null, $matchAmount = null, $matcherId = null, $numberOfDonations = null, $paidAmount = null, $remaining = null)
    {
        $this
            ->setBillingDate($billingDate)
            ->setDonationTotalAmount($donationTotalAmount)
            ->setIsSelected($isSelected)
            ->setLastPrintDateTime($lastPrintDateTime)
            ->setLastSentByEmailDateTime($lastSentByEmailDateTime)
            ->setLastSentByEmailTo($lastSentByEmailTo)
            ->setMatchAmount($matchAmount)
            ->setMatcherId($matcherId)
            ->setNumberOfDonations($numberOfDonations)
            ->setPaidAmount($paidAmount)
            ->setRemaining($remaining);
    }
    /**
     * Get BillingDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBillingDate()
    {
        return isset($this->BillingDate) ? $this->BillingDate : null;
    }
    /**
     * Set BillingDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $billingDate
     * @return \patest\StructType\Donation_MatchingGiftsForClient
     */
    public function setBillingDate($billingDate = null)
    {
        // validation for constraint: string
        if (!is_null($billingDate) && !is_string($billingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingDate, true), gettype($billingDate)), __LINE__);
        }
        if (is_null($billingDate) || (is_array($billingDate) && empty($billingDate))) {
            unset($this->BillingDate);
        } else {
            $this->BillingDate = $billingDate;
        }
        return $this;
    }
    /**
     * Get DonationTotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDonationTotalAmount()
    {
        return isset($this->DonationTotalAmount) ? $this->DonationTotalAmount : null;
    }
    /**
     * Set DonationTotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $donationTotalAmount
     * @return \patest\StructType\Donation_MatchingGiftsForClient
     */
    public function setDonationTotalAmount($donationTotalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($donationTotalAmount) && !(is_float($donationTotalAmount) || is_numeric($donationTotalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($donationTotalAmount, true), gettype($donationTotalAmount)), __LINE__);
        }
        if (is_null($donationTotalAmount) || (is_array($donationTotalAmount) && empty($donationTotalAmount))) {
            unset($this->DonationTotalAmount);
        } else {
            $this->DonationTotalAmount = $donationTotalAmount;
        }
        return $this;
    }
    /**
     * Get IsSelected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSelected()
    {
        return isset($this->IsSelected) ? $this->IsSelected : null;
    }
    /**
     * Set IsSelected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSelected
     * @return \patest\StructType\Donation_MatchingGiftsForClient
     */
    public function setIsSelected($isSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSelected) && !is_bool($isSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSelected, true), gettype($isSelected)), __LINE__);
        }
        if (is_null($isSelected) || (is_array($isSelected) && empty($isSelected))) {
            unset($this->IsSelected);
        } else {
            $this->IsSelected = $isSelected;
        }
        return $this;
    }
    /**
     * Get LastPrintDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastPrintDateTime()
    {
        return isset($this->LastPrintDateTime) ? $this->LastPrintDateTime : null;
    }
    /**
     * Set LastPrintDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastPrintDateTime
     * @return \patest\StructType\Donation_MatchingGiftsForClient
     */
    public function setLastPrintDateTime($lastPrintDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastPrintDateTime) && !is_string($lastPrintDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastPrintDateTime, true), gettype($lastPrintDateTime)), __LINE__);
        }
        if (is_null($lastPrintDateTime) || (is_array($lastPrintDateTime) && empty($lastPrintDateTime))) {
            unset($this->LastPrintDateTime);
        } else {
            $this->LastPrintDateTime = $lastPrintDateTime;
        }
        return $this;
    }
    /**
     * Get LastSentByEmailDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastSentByEmailDateTime()
    {
        return isset($this->LastSentByEmailDateTime) ? $this->LastSentByEmailDateTime : null;
    }
    /**
     * Set LastSentByEmailDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastSentByEmailDateTime
     * @return \patest\StructType\Donation_MatchingGiftsForClient
     */
    public function setLastSentByEmailDateTime($lastSentByEmailDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastSentByEmailDateTime) && !is_string($lastSentByEmailDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastSentByEmailDateTime, true), gettype($lastSentByEmailDateTime)), __LINE__);
        }
        if (is_null($lastSentByEmailDateTime) || (is_array($lastSentByEmailDateTime) && empty($lastSentByEmailDateTime))) {
            unset($this->LastSentByEmailDateTime);
        } else {
            $this->LastSentByEmailDateTime = $lastSentByEmailDateTime;
        }
        return $this;
    }
    /**
     * Get LastSentByEmailTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastSentByEmailTo()
    {
        return isset($this->LastSentByEmailTo) ? $this->LastSentByEmailTo : null;
    }
    /**
     * Set LastSentByEmailTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastSentByEmailTo
     * @return \patest\StructType\Donation_MatchingGiftsForClient
     */
    public function setLastSentByEmailTo($lastSentByEmailTo = null)
    {
        // validation for constraint: string
        if (!is_null($lastSentByEmailTo) && !is_string($lastSentByEmailTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastSentByEmailTo, true), gettype($lastSentByEmailTo)), __LINE__);
        }
        if (is_null($lastSentByEmailTo) || (is_array($lastSentByEmailTo) && empty($lastSentByEmailTo))) {
            unset($this->LastSentByEmailTo);
        } else {
            $this->LastSentByEmailTo = $lastSentByEmailTo;
        }
        return $this;
    }
    /**
     * Get MatchAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMatchAmount()
    {
        return isset($this->MatchAmount) ? $this->MatchAmount : null;
    }
    /**
     * Set MatchAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $matchAmount
     * @return \patest\StructType\Donation_MatchingGiftsForClient
     */
    public function setMatchAmount($matchAmount = null)
    {
        // validation for constraint: float
        if (!is_null($matchAmount) && !(is_float($matchAmount) || is_numeric($matchAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($matchAmount, true), gettype($matchAmount)), __LINE__);
        }
        if (is_null($matchAmount) || (is_array($matchAmount) && empty($matchAmount))) {
            unset($this->MatchAmount);
        } else {
            $this->MatchAmount = $matchAmount;
        }
        return $this;
    }
    /**
     * Get MatcherId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMatcherId()
    {
        return isset($this->MatcherId) ? $this->MatcherId : null;
    }
    /**
     * Set MatcherId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $matcherId
     * @return \patest\StructType\Donation_MatchingGiftsForClient
     */
    public function setMatcherId($matcherId = null)
    {
        // validation for constraint: string
        if (!is_null($matcherId) && !is_string($matcherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matcherId, true), gettype($matcherId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($matcherId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $matcherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($matcherId, true)), __LINE__);
        }
        if (is_null($matcherId) || (is_array($matcherId) && empty($matcherId))) {
            unset($this->MatcherId);
        } else {
            $this->MatcherId = $matcherId;
        }
        return $this;
    }
    /**
     * Get NumberOfDonations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfDonations()
    {
        return isset($this->NumberOfDonations) ? $this->NumberOfDonations : null;
    }
    /**
     * Set NumberOfDonations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfDonations
     * @return \patest\StructType\Donation_MatchingGiftsForClient
     */
    public function setNumberOfDonations($numberOfDonations = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDonations) && !(is_int($numberOfDonations) || ctype_digit($numberOfDonations))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfDonations, true), gettype($numberOfDonations)), __LINE__);
        }
        if (is_null($numberOfDonations) || (is_array($numberOfDonations) && empty($numberOfDonations))) {
            unset($this->NumberOfDonations);
        } else {
            $this->NumberOfDonations = $numberOfDonations;
        }
        return $this;
    }
    /**
     * Get PaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPaidAmount()
    {
        return isset($this->PaidAmount) ? $this->PaidAmount : null;
    }
    /**
     * Set PaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $paidAmount
     * @return \patest\StructType\Donation_MatchingGiftsForClient
     */
    public function setPaidAmount($paidAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paidAmount) && !(is_float($paidAmount) || is_numeric($paidAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paidAmount, true), gettype($paidAmount)), __LINE__);
        }
        if (is_null($paidAmount) || (is_array($paidAmount) && empty($paidAmount))) {
            unset($this->PaidAmount);
        } else {
            $this->PaidAmount = $paidAmount;
        }
        return $this;
    }
    /**
     * Get Remaining value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRemaining()
    {
        return isset($this->Remaining) ? $this->Remaining : null;
    }
    /**
     * Set Remaining value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $remaining
     * @return \patest\StructType\Donation_MatchingGiftsForClient
     */
    public function setRemaining($remaining = null)
    {
        // validation for constraint: float
        if (!is_null($remaining) && !(is_float($remaining) || is_numeric($remaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remaining, true), gettype($remaining)), __LINE__);
        }
        if (is_null($remaining) || (is_array($remaining) && empty($remaining))) {
            unset($this->Remaining);
        } else {
            $this->Remaining = $remaining;
        }
        return $this;
    }
}
