<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DonationProductItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DonationProductItem
 * @subpackage Structs
 */
class DonationProductItem extends AbstractProductItem
{
    /**
     * The AmountType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AmountType;
    /**
     * The AppealId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealId;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CampaignId;
    /**
     * The ChannelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ChannelId;
    /**
     * The DonationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DonationDate;
    /**
     * The DonationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DonationId;
    /**
     * The FundId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FundId;
    /**
     * The FundName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FundName;
    /**
     * The GenerateTaxStatement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GenerateTaxStatement;
    /**
     * The GenerateThankYouLetter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GenerateThankYouLetter;
    /**
     * The GiftDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftDescription;
    /**
     * The GiftType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GiftType;
    /**
     * The IsAnonymous
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAnonymous;
    /**
     * The IsPrintSpecialClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPrintSpecialClientName;
    /**
     * The IsPrinting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPrinting;
    /**
     * The MatchingOfDonationProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MatchingOfDonationProductId;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NameOnDonation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $NameOnDonation;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notification;
    /**
     * The PersonToTribute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PersonToTribute;
    /**
     * The PledgeInstallment
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PledgeInstallment;
    /**
     * The SoftCreditDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSoftCreditDetail
     */
    public $SoftCreditDetails;
    /**
     * The TaxStatementNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxStatementNumbers;
    /**
     * The TaxStatementPrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TaxStatementPrintCount;
    /**
     * The TaxStatementPrintedOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxStatementPrintedOn;
    /**
     * The ThankYouLetterPrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ThankYouLetterPrintCount;
    /**
     * The ThankYouLetterSpecialMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThankYouLetterSpecialMessage;
    /**
     * The TributeLetterPrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TributeLetterPrintCount;
    /**
     * The TributeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TributeType;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Value;
    /**
     * Constructor method for DonationProductItem
     * @uses DonationProductItem::setAmountType()
     * @uses DonationProductItem::setAppealId()
     * @uses DonationProductItem::setCampaignId()
     * @uses DonationProductItem::setChannelId()
     * @uses DonationProductItem::setDonationDate()
     * @uses DonationProductItem::setDonationId()
     * @uses DonationProductItem::setFundId()
     * @uses DonationProductItem::setFundName()
     * @uses DonationProductItem::setGenerateTaxStatement()
     * @uses DonationProductItem::setGenerateThankYouLetter()
     * @uses DonationProductItem::setGiftDescription()
     * @uses DonationProductItem::setGiftType()
     * @uses DonationProductItem::setIsAnonymous()
     * @uses DonationProductItem::setIsPrintSpecialClientName()
     * @uses DonationProductItem::setIsPrinting()
     * @uses DonationProductItem::setMatchingOfDonationProductId()
     * @uses DonationProductItem::setMessage()
     * @uses DonationProductItem::setName()
     * @uses DonationProductItem::setNameOnDonation()
     * @uses DonationProductItem::setNotification()
     * @uses DonationProductItem::setPersonToTribute()
     * @uses DonationProductItem::setPledgeInstallment()
     * @uses DonationProductItem::setSoftCreditDetails()
     * @uses DonationProductItem::setTaxStatementNumbers()
     * @uses DonationProductItem::setTaxStatementPrintCount()
     * @uses DonationProductItem::setTaxStatementPrintedOn()
     * @uses DonationProductItem::setThankYouLetterPrintCount()
     * @uses DonationProductItem::setThankYouLetterSpecialMessage()
     * @uses DonationProductItem::setTributeLetterPrintCount()
     * @uses DonationProductItem::setTributeType()
     * @uses DonationProductItem::setValue()
     * @param string $amountType
     * @param string $appealId
     * @param string $campaignId
     * @param string $channelId
     * @param string $donationDate
     * @param string $donationId
     * @param string $fundId
     * @param string $fundName
     * @param bool $generateTaxStatement
     * @param bool $generateThankYouLetter
     * @param string $giftDescription
     * @param string $giftType
     * @param bool $isAnonymous
     * @param bool $isPrintSpecialClientName
     * @param bool $isPrinting
     * @param string $matchingOfDonationProductId
     * @param string $message
     * @param string $name
     * @param \patest\StructType\GlobalString $nameOnDonation
     * @param string $notification
     * @param string $personToTribute
     * @param string $pledgeInstallment
     * @param \patest\ArrayType\ArrayOfSoftCreditDetail $softCreditDetails
     * @param string $taxStatementNumbers
     * @param int $taxStatementPrintCount
     * @param string $taxStatementPrintedOn
     * @param int $thankYouLetterPrintCount
     * @param string $thankYouLetterSpecialMessage
     * @param int $tributeLetterPrintCount
     * @param string $tributeType
     * @param float $value
     */
    public function __construct($amountType = null, $appealId = null, $campaignId = null, $channelId = null, $donationDate = null, $donationId = null, $fundId = null, $fundName = null, $generateTaxStatement = null, $generateThankYouLetter = null, $giftDescription = null, $giftType = null, $isAnonymous = null, $isPrintSpecialClientName = null, $isPrinting = null, $matchingOfDonationProductId = null, $message = null, $name = null, \patest\StructType\GlobalString $nameOnDonation = null, $notification = null, $personToTribute = null, $pledgeInstallment = null, \patest\ArrayType\ArrayOfSoftCreditDetail $softCreditDetails = null, $taxStatementNumbers = null, $taxStatementPrintCount = null, $taxStatementPrintedOn = null, $thankYouLetterPrintCount = null, $thankYouLetterSpecialMessage = null, $tributeLetterPrintCount = null, $tributeType = null, $value = null)
    {
        $this
            ->setAmountType($amountType)
            ->setAppealId($appealId)
            ->setCampaignId($campaignId)
            ->setChannelId($channelId)
            ->setDonationDate($donationDate)
            ->setDonationId($donationId)
            ->setFundId($fundId)
            ->setFundName($fundName)
            ->setGenerateTaxStatement($generateTaxStatement)
            ->setGenerateThankYouLetter($generateThankYouLetter)
            ->setGiftDescription($giftDescription)
            ->setGiftType($giftType)
            ->setIsAnonymous($isAnonymous)
            ->setIsPrintSpecialClientName($isPrintSpecialClientName)
            ->setIsPrinting($isPrinting)
            ->setMatchingOfDonationProductId($matchingOfDonationProductId)
            ->setMessage($message)
            ->setName($name)
            ->setNameOnDonation($nameOnDonation)
            ->setNotification($notification)
            ->setPersonToTribute($personToTribute)
            ->setPledgeInstallment($pledgeInstallment)
            ->setSoftCreditDetails($softCreditDetails)
            ->setTaxStatementNumbers($taxStatementNumbers)
            ->setTaxStatementPrintCount($taxStatementPrintCount)
            ->setTaxStatementPrintedOn($taxStatementPrintedOn)
            ->setThankYouLetterPrintCount($thankYouLetterPrintCount)
            ->setThankYouLetterSpecialMessage($thankYouLetterSpecialMessage)
            ->setTributeLetterPrintCount($tributeLetterPrintCount)
            ->setTributeType($tributeType)
            ->setValue($value);
    }
    /**
     * Get AmountType value
     * @return string|null
     */
    public function getAmountType()
    {
        return $this->AmountType;
    }
    /**
     * Set AmountType value
     * @uses \patest\EnumType\AmountType::valueIsValid()
     * @uses \patest\EnumType\AmountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $amountType
     * @return \patest\StructType\DonationProductItem
     */
    public function setAmountType($amountType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AmountType::valueIsValid($amountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AmountType', is_array($amountType) ? implode(', ', $amountType) : var_export($amountType, true), implode(', ', \patest\EnumType\AmountType::getValidValues())), __LINE__);
        }
        $this->AmountType = $amountType;
        return $this;
    }
    /**
     * Get AppealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealId()
    {
        return isset($this->AppealId) ? $this->AppealId : null;
    }
    /**
     * Set AppealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealId
     * @return \patest\StructType\DonationProductItem
     */
    public function setAppealId($appealId = null)
    {
        // validation for constraint: string
        if (!is_null($appealId) && !is_string($appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealId, true), gettype($appealId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealId, true)), __LINE__);
        }
        if (is_null($appealId) || (is_array($appealId) && empty($appealId))) {
            unset($this->AppealId);
        } else {
            $this->AppealId = $appealId;
        }
        return $this;
    }
    /**
     * Get CampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignId()
    {
        return isset($this->CampaignId) ? $this->CampaignId : null;
    }
    /**
     * Set CampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignId
     * @return \patest\StructType\DonationProductItem
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: string
        if (!is_null($campaignId) && !is_string($campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($campaignId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($campaignId, true)), __LINE__);
        }
        if (is_null($campaignId) || (is_array($campaignId) && empty($campaignId))) {
            unset($this->CampaignId);
        } else {
            $this->CampaignId = $campaignId;
        }
        return $this;
    }
    /**
     * Get ChannelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannelId()
    {
        return isset($this->ChannelId) ? $this->ChannelId : null;
    }
    /**
     * Set ChannelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channelId
     * @return \patest\StructType\DonationProductItem
     */
    public function setChannelId($channelId = null)
    {
        // validation for constraint: string
        if (!is_null($channelId) && !is_string($channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channelId, true), gettype($channelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($channelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($channelId, true)), __LINE__);
        }
        if (is_null($channelId) || (is_array($channelId) && empty($channelId))) {
            unset($this->ChannelId);
        } else {
            $this->ChannelId = $channelId;
        }
        return $this;
    }
    /**
     * Get DonationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationDate()
    {
        return isset($this->DonationDate) ? $this->DonationDate : null;
    }
    /**
     * Set DonationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationDate
     * @return \patest\StructType\DonationProductItem
     */
    public function setDonationDate($donationDate = null)
    {
        // validation for constraint: string
        if (!is_null($donationDate) && !is_string($donationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationDate, true), gettype($donationDate)), __LINE__);
        }
        if (is_null($donationDate) || (is_array($donationDate) && empty($donationDate))) {
            unset($this->DonationDate);
        } else {
            $this->DonationDate = $donationDate;
        }
        return $this;
    }
    /**
     * Get DonationId value
     * @return string|null
     */
    public function getDonationId()
    {
        return $this->DonationId;
    }
    /**
     * Set DonationId value
     * @param string $donationId
     * @return \patest\StructType\DonationProductItem
     */
    public function setDonationId($donationId = null)
    {
        // validation for constraint: string
        if (!is_null($donationId) && !is_string($donationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationId, true), gettype($donationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($donationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $donationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($donationId, true)), __LINE__);
        }
        $this->DonationId = $donationId;
        return $this;
    }
    /**
     * Get FundId value
     * @return string|null
     */
    public function getFundId()
    {
        return $this->FundId;
    }
    /**
     * Set FundId value
     * @param string $fundId
     * @return \patest\StructType\DonationProductItem
     */
    public function setFundId($fundId = null)
    {
        // validation for constraint: string
        if (!is_null($fundId) && !is_string($fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fundId, true), gettype($fundId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fundId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fundId, true)), __LINE__);
        }
        $this->FundId = $fundId;
        return $this;
    }
    /**
     * Get FundName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFundName()
    {
        return isset($this->FundName) ? $this->FundName : null;
    }
    /**
     * Set FundName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fundName
     * @return \patest\StructType\DonationProductItem
     */
    public function setFundName($fundName = null)
    {
        // validation for constraint: string
        if (!is_null($fundName) && !is_string($fundName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fundName, true), gettype($fundName)), __LINE__);
        }
        if (is_null($fundName) || (is_array($fundName) && empty($fundName))) {
            unset($this->FundName);
        } else {
            $this->FundName = $fundName;
        }
        return $this;
    }
    /**
     * Get GenerateTaxStatement value
     * @return bool|null
     */
    public function getGenerateTaxStatement()
    {
        return $this->GenerateTaxStatement;
    }
    /**
     * Set GenerateTaxStatement value
     * @param bool $generateTaxStatement
     * @return \patest\StructType\DonationProductItem
     */
    public function setGenerateTaxStatement($generateTaxStatement = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateTaxStatement) && !is_bool($generateTaxStatement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateTaxStatement, true), gettype($generateTaxStatement)), __LINE__);
        }
        $this->GenerateTaxStatement = $generateTaxStatement;
        return $this;
    }
    /**
     * Get GenerateThankYouLetter value
     * @return bool|null
     */
    public function getGenerateThankYouLetter()
    {
        return $this->GenerateThankYouLetter;
    }
    /**
     * Set GenerateThankYouLetter value
     * @param bool $generateThankYouLetter
     * @return \patest\StructType\DonationProductItem
     */
    public function setGenerateThankYouLetter($generateThankYouLetter = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateThankYouLetter) && !is_bool($generateThankYouLetter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateThankYouLetter, true), gettype($generateThankYouLetter)), __LINE__);
        }
        $this->GenerateThankYouLetter = $generateThankYouLetter;
        return $this;
    }
    /**
     * Get GiftDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftDescription()
    {
        return isset($this->GiftDescription) ? $this->GiftDescription : null;
    }
    /**
     * Set GiftDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftDescription
     * @return \patest\StructType\DonationProductItem
     */
    public function setGiftDescription($giftDescription = null)
    {
        // validation for constraint: string
        if (!is_null($giftDescription) && !is_string($giftDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftDescription, true), gettype($giftDescription)), __LINE__);
        }
        if (is_null($giftDescription) || (is_array($giftDescription) && empty($giftDescription))) {
            unset($this->GiftDescription);
        } else {
            $this->GiftDescription = $giftDescription;
        }
        return $this;
    }
    /**
     * Get GiftType value
     * @return string|null
     */
    public function getGiftType()
    {
        return $this->GiftType;
    }
    /**
     * Set GiftType value
     * @uses \patest\EnumType\GiftType::valueIsValid()
     * @uses \patest\EnumType\GiftType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $giftType
     * @return \patest\StructType\DonationProductItem
     */
    public function setGiftType($giftType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GiftType::valueIsValid($giftType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GiftType', is_array($giftType) ? implode(', ', $giftType) : var_export($giftType, true), implode(', ', \patest\EnumType\GiftType::getValidValues())), __LINE__);
        }
        $this->GiftType = $giftType;
        return $this;
    }
    /**
     * Get IsAnonymous value
     * @return bool|null
     */
    public function getIsAnonymous()
    {
        return $this->IsAnonymous;
    }
    /**
     * Set IsAnonymous value
     * @param bool $isAnonymous
     * @return \patest\StructType\DonationProductItem
     */
    public function setIsAnonymous($isAnonymous = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAnonymous) && !is_bool($isAnonymous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAnonymous, true), gettype($isAnonymous)), __LINE__);
        }
        $this->IsAnonymous = $isAnonymous;
        return $this;
    }
    /**
     * Get IsPrintSpecialClientName value
     * @return bool|null
     */
    public function getIsPrintSpecialClientName()
    {
        return $this->IsPrintSpecialClientName;
    }
    /**
     * Set IsPrintSpecialClientName value
     * @param bool $isPrintSpecialClientName
     * @return \patest\StructType\DonationProductItem
     */
    public function setIsPrintSpecialClientName($isPrintSpecialClientName = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrintSpecialClientName) && !is_bool($isPrintSpecialClientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrintSpecialClientName, true), gettype($isPrintSpecialClientName)), __LINE__);
        }
        $this->IsPrintSpecialClientName = $isPrintSpecialClientName;
        return $this;
    }
    /**
     * Get IsPrinting value
     * @return bool|null
     */
    public function getIsPrinting()
    {
        return $this->IsPrinting;
    }
    /**
     * Set IsPrinting value
     * @param bool $isPrinting
     * @return \patest\StructType\DonationProductItem
     */
    public function setIsPrinting($isPrinting = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinting) && !is_bool($isPrinting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinting, true), gettype($isPrinting)), __LINE__);
        }
        $this->IsPrinting = $isPrinting;
        return $this;
    }
    /**
     * Get MatchingOfDonationProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMatchingOfDonationProductId()
    {
        return isset($this->MatchingOfDonationProductId) ? $this->MatchingOfDonationProductId : null;
    }
    /**
     * Set MatchingOfDonationProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $matchingOfDonationProductId
     * @return \patest\StructType\DonationProductItem
     */
    public function setMatchingOfDonationProductId($matchingOfDonationProductId = null)
    {
        // validation for constraint: string
        if (!is_null($matchingOfDonationProductId) && !is_string($matchingOfDonationProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchingOfDonationProductId, true), gettype($matchingOfDonationProductId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($matchingOfDonationProductId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $matchingOfDonationProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($matchingOfDonationProductId, true)), __LINE__);
        }
        if (is_null($matchingOfDonationProductId) || (is_array($matchingOfDonationProductId) && empty($matchingOfDonationProductId))) {
            unset($this->MatchingOfDonationProductId);
        } else {
            $this->MatchingOfDonationProductId = $matchingOfDonationProductId;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \patest\StructType\DonationProductItem
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\DonationProductItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NameOnDonation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNameOnDonation()
    {
        return isset($this->NameOnDonation) ? $this->NameOnDonation : null;
    }
    /**
     * Set NameOnDonation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $nameOnDonation
     * @return \patest\StructType\DonationProductItem
     */
    public function setNameOnDonation(\patest\StructType\GlobalString $nameOnDonation = null)
    {
        if (is_null($nameOnDonation) || (is_array($nameOnDonation) && empty($nameOnDonation))) {
            unset($this->NameOnDonation);
        } else {
            $this->NameOnDonation = $nameOnDonation;
        }
        return $this;
    }
    /**
     * Get Notification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotification()
    {
        return isset($this->Notification) ? $this->Notification : null;
    }
    /**
     * Set Notification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notification
     * @return \patest\StructType\DonationProductItem
     */
    public function setNotification($notification = null)
    {
        // validation for constraint: string
        if (!is_null($notification) && !is_string($notification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notification, true), gettype($notification)), __LINE__);
        }
        if (is_null($notification) || (is_array($notification) && empty($notification))) {
            unset($this->Notification);
        } else {
            $this->Notification = $notification;
        }
        return $this;
    }
    /**
     * Get PersonToTribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonToTribute()
    {
        return isset($this->PersonToTribute) ? $this->PersonToTribute : null;
    }
    /**
     * Set PersonToTribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personToTribute
     * @return \patest\StructType\DonationProductItem
     */
    public function setPersonToTribute($personToTribute = null)
    {
        // validation for constraint: string
        if (!is_null($personToTribute) && !is_string($personToTribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personToTribute, true), gettype($personToTribute)), __LINE__);
        }
        if (is_null($personToTribute) || (is_array($personToTribute) && empty($personToTribute))) {
            unset($this->PersonToTribute);
        } else {
            $this->PersonToTribute = $personToTribute;
        }
        return $this;
    }
    /**
     * Get PledgeInstallment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPledgeInstallment()
    {
        return isset($this->PledgeInstallment) ? $this->PledgeInstallment : null;
    }
    /**
     * Set PledgeInstallment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pledgeInstallment
     * @return \patest\StructType\DonationProductItem
     */
    public function setPledgeInstallment($pledgeInstallment = null)
    {
        // validation for constraint: string
        if (!is_null($pledgeInstallment) && !is_string($pledgeInstallment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pledgeInstallment, true), gettype($pledgeInstallment)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($pledgeInstallment) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $pledgeInstallment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($pledgeInstallment, true)), __LINE__);
        }
        if (is_null($pledgeInstallment) || (is_array($pledgeInstallment) && empty($pledgeInstallment))) {
            unset($this->PledgeInstallment);
        } else {
            $this->PledgeInstallment = $pledgeInstallment;
        }
        return $this;
    }
    /**
     * Get SoftCreditDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSoftCreditDetail|null
     */
    public function getSoftCreditDetails()
    {
        return isset($this->SoftCreditDetails) ? $this->SoftCreditDetails : null;
    }
    /**
     * Set SoftCreditDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSoftCreditDetail $softCreditDetails
     * @return \patest\StructType\DonationProductItem
     */
    public function setSoftCreditDetails(\patest\ArrayType\ArrayOfSoftCreditDetail $softCreditDetails = null)
    {
        if (is_null($softCreditDetails) || (is_array($softCreditDetails) && empty($softCreditDetails))) {
            unset($this->SoftCreditDetails);
        } else {
            $this->SoftCreditDetails = $softCreditDetails;
        }
        return $this;
    }
    /**
     * Get TaxStatementNumbers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxStatementNumbers()
    {
        return isset($this->TaxStatementNumbers) ? $this->TaxStatementNumbers : null;
    }
    /**
     * Set TaxStatementNumbers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxStatementNumbers
     * @return \patest\StructType\DonationProductItem
     */
    public function setTaxStatementNumbers($taxStatementNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($taxStatementNumbers) && !is_string($taxStatementNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxStatementNumbers, true), gettype($taxStatementNumbers)), __LINE__);
        }
        if (is_null($taxStatementNumbers) || (is_array($taxStatementNumbers) && empty($taxStatementNumbers))) {
            unset($this->TaxStatementNumbers);
        } else {
            $this->TaxStatementNumbers = $taxStatementNumbers;
        }
        return $this;
    }
    /**
     * Get TaxStatementPrintCount value
     * @return int|null
     */
    public function getTaxStatementPrintCount()
    {
        return $this->TaxStatementPrintCount;
    }
    /**
     * Set TaxStatementPrintCount value
     * @param int $taxStatementPrintCount
     * @return \patest\StructType\DonationProductItem
     */
    public function setTaxStatementPrintCount($taxStatementPrintCount = null)
    {
        // validation for constraint: int
        if (!is_null($taxStatementPrintCount) && !(is_int($taxStatementPrintCount) || ctype_digit($taxStatementPrintCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxStatementPrintCount, true), gettype($taxStatementPrintCount)), __LINE__);
        }
        $this->TaxStatementPrintCount = $taxStatementPrintCount;
        return $this;
    }
    /**
     * Get TaxStatementPrintedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxStatementPrintedOn()
    {
        return isset($this->TaxStatementPrintedOn) ? $this->TaxStatementPrintedOn : null;
    }
    /**
     * Set TaxStatementPrintedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxStatementPrintedOn
     * @return \patest\StructType\DonationProductItem
     */
    public function setTaxStatementPrintedOn($taxStatementPrintedOn = null)
    {
        // validation for constraint: string
        if (!is_null($taxStatementPrintedOn) && !is_string($taxStatementPrintedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxStatementPrintedOn, true), gettype($taxStatementPrintedOn)), __LINE__);
        }
        if (is_null($taxStatementPrintedOn) || (is_array($taxStatementPrintedOn) && empty($taxStatementPrintedOn))) {
            unset($this->TaxStatementPrintedOn);
        } else {
            $this->TaxStatementPrintedOn = $taxStatementPrintedOn;
        }
        return $this;
    }
    /**
     * Get ThankYouLetterPrintCount value
     * @return int|null
     */
    public function getThankYouLetterPrintCount()
    {
        return $this->ThankYouLetterPrintCount;
    }
    /**
     * Set ThankYouLetterPrintCount value
     * @param int $thankYouLetterPrintCount
     * @return \patest\StructType\DonationProductItem
     */
    public function setThankYouLetterPrintCount($thankYouLetterPrintCount = null)
    {
        // validation for constraint: int
        if (!is_null($thankYouLetterPrintCount) && !(is_int($thankYouLetterPrintCount) || ctype_digit($thankYouLetterPrintCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($thankYouLetterPrintCount, true), gettype($thankYouLetterPrintCount)), __LINE__);
        }
        $this->ThankYouLetterPrintCount = $thankYouLetterPrintCount;
        return $this;
    }
    /**
     * Get ThankYouLetterSpecialMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThankYouLetterSpecialMessage()
    {
        return isset($this->ThankYouLetterSpecialMessage) ? $this->ThankYouLetterSpecialMessage : null;
    }
    /**
     * Set ThankYouLetterSpecialMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thankYouLetterSpecialMessage
     * @return \patest\StructType\DonationProductItem
     */
    public function setThankYouLetterSpecialMessage($thankYouLetterSpecialMessage = null)
    {
        // validation for constraint: string
        if (!is_null($thankYouLetterSpecialMessage) && !is_string($thankYouLetterSpecialMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thankYouLetterSpecialMessage, true), gettype($thankYouLetterSpecialMessage)), __LINE__);
        }
        if (is_null($thankYouLetterSpecialMessage) || (is_array($thankYouLetterSpecialMessage) && empty($thankYouLetterSpecialMessage))) {
            unset($this->ThankYouLetterSpecialMessage);
        } else {
            $this->ThankYouLetterSpecialMessage = $thankYouLetterSpecialMessage;
        }
        return $this;
    }
    /**
     * Get TributeLetterPrintCount value
     * @return int|null
     */
    public function getTributeLetterPrintCount()
    {
        return $this->TributeLetterPrintCount;
    }
    /**
     * Set TributeLetterPrintCount value
     * @param int $tributeLetterPrintCount
     * @return \patest\StructType\DonationProductItem
     */
    public function setTributeLetterPrintCount($tributeLetterPrintCount = null)
    {
        // validation for constraint: int
        if (!is_null($tributeLetterPrintCount) && !(is_int($tributeLetterPrintCount) || ctype_digit($tributeLetterPrintCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tributeLetterPrintCount, true), gettype($tributeLetterPrintCount)), __LINE__);
        }
        $this->TributeLetterPrintCount = $tributeLetterPrintCount;
        return $this;
    }
    /**
     * Get TributeType value
     * @return string|null
     */
    public function getTributeType()
    {
        return $this->TributeType;
    }
    /**
     * Set TributeType value
     * @uses \patest\EnumType\TributeType::valueIsValid()
     * @uses \patest\EnumType\TributeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tributeType
     * @return \patest\StructType\DonationProductItem
     */
    public function setTributeType($tributeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TributeType::valueIsValid($tributeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TributeType', is_array($tributeType) ? implode(', ', $tributeType) : var_export($tributeType, true), implode(', ', \patest\EnumType\TributeType::getValidValues())), __LINE__);
        }
        $this->TributeType = $tributeType;
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \patest\StructType\DonationProductItem
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
