<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistributableEntity StructType
 * @subpackage Structs
 */
class DistributableEntity extends PersistableEntity
{
    /**
     * The IssuerTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IssuerTenantId;
    /**
     * Constructor method for DistributableEntity
     * @uses DistributableEntity::setIssuerTenantId()
     * @param int $issuerTenantId
     */
    public function __construct($issuerTenantId = null)
    {
        $this
            ->setIssuerTenantId($issuerTenantId);
    }
    /**
     * Get IssuerTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIssuerTenantId()
    {
        return isset($this->IssuerTenantId) ? $this->IssuerTenantId : null;
    }
    /**
     * Set IssuerTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $issuerTenantId
     * @return \patest\StructType\DistributableEntity
     */
    public function setIssuerTenantId($issuerTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerTenantId) && !(is_int($issuerTenantId) || ctype_digit($issuerTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerTenantId, true), gettype($issuerTenantId)), __LINE__);
        }
        if (is_null($issuerTenantId) || (is_array($issuerTenantId) && empty($issuerTenantId))) {
            unset($this->IssuerTenantId);
        } else {
            $this->IssuerTenantId = $issuerTenantId;
        }
        return $this;
    }
}
