<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteTicketSchemeEnrollment-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeleteTicketSchemeEnrollment-Request
 * @subpackage Structs
 */
class DeleteTicketSchemeEnrollment_Request extends AbstractStructBase
{
    /**
     * The EnrollmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EnrollmentId;
    /**
     * Constructor method for DeleteTicketSchemeEnrollment-Request
     * @uses DeleteTicketSchemeEnrollment_Request::setEnrollmentId()
     * @param string $enrollmentId
     */
    public function __construct($enrollmentId = null)
    {
        $this
            ->setEnrollmentId($enrollmentId);
    }
    /**
     * Get EnrollmentId value
     * @return string|null
     */
    public function getEnrollmentId()
    {
        return $this->EnrollmentId;
    }
    /**
     * Set EnrollmentId value
     * @param string $enrollmentId
     * @return \patest\StructType\DeleteTicketSchemeEnrollment_Request
     */
    public function setEnrollmentId($enrollmentId = null)
    {
        // validation for constraint: string
        if (!is_null($enrollmentId) && !is_string($enrollmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enrollmentId, true), gettype($enrollmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($enrollmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $enrollmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($enrollmentId, true)), __LINE__);
        }
        $this->EnrollmentId = $enrollmentId;
        return $this;
    }
}
