<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataBatchPartEntityPropertiesList StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DataBatchPartEntityPropertiesList
 * @subpackage Structs
 */
class DataBatchPartEntityPropertiesList extends AbstractStructBase
{
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The PropertyNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $PropertyNames;
    /**
     * Constructor method for DataBatchPartEntityPropertiesList
     * @uses DataBatchPartEntityPropertiesList::setEntityName()
     * @uses DataBatchPartEntityPropertiesList::setPropertyNames()
     * @param string $entityName
     * @param \patest\ArrayType\ArrayOfstring $propertyNames
     */
    public function __construct($entityName = null, \patest\ArrayType\ArrayOfstring $propertyNames = null)
    {
        $this
            ->setEntityName($entityName)
            ->setPropertyNames($propertyNames);
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\DataBatchPartEntityPropertiesList
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get PropertyNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getPropertyNames()
    {
        return isset($this->PropertyNames) ? $this->PropertyNames : null;
    }
    /**
     * Set PropertyNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $propertyNames
     * @return \patest\StructType\DataBatchPartEntityPropertiesList
     */
    public function setPropertyNames(\patest\ArrayType\ArrayOfstring $propertyNames = null)
    {
        if (is_null($propertyNames) || (is_array($propertyNames) && empty($propertyNames))) {
            unset($this->PropertyNames);
        } else {
            $this->PropertyNames = $propertyNames;
        }
        return $this;
    }
}
