<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.StandaloneCustomer4Printing StructType
 * @subpackage Structs
 */
class Crm_StandaloneCustomer4Printing extends Crm_Customer4Printing
{
    /**
     * The CultureId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CultureId;
    /**
     * The JobTitleName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $JobTitleName;
    /**
     * The JobTitleType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JobTitleType;
    /**
     * The MaritalStatusName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MaritalStatusName;
    /**
     * The Picture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_ClientImage4Printing
     */
    public $Picture;
    /**
     * The PreferredCulture
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ScreenParts_SupportedCulture
     */
    public $PreferredCulture;
    /**
     * The TitleName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TitleName;
    /**
     * The TitleType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TitleType;
    /**
     * Constructor method for Crm.StandaloneCustomer4Printing
     * @uses Crm_StandaloneCustomer4Printing::setCultureId()
     * @uses Crm_StandaloneCustomer4Printing::setJobTitleName()
     * @uses Crm_StandaloneCustomer4Printing::setJobTitleType()
     * @uses Crm_StandaloneCustomer4Printing::setMaritalStatusName()
     * @uses Crm_StandaloneCustomer4Printing::setPicture()
     * @uses Crm_StandaloneCustomer4Printing::setPreferredCulture()
     * @uses Crm_StandaloneCustomer4Printing::setTitleName()
     * @uses Crm_StandaloneCustomer4Printing::setTitleType()
     * @param int $cultureId
     * @param \patest\StructType\GlobalString $jobTitleName
     * @param string $jobTitleType
     * @param \patest\StructType\GlobalString $maritalStatusName
     * @param \patest\StructType\Crm_ClientImage4Printing $picture
     * @param \patest\StructType\ScreenParts_SupportedCulture $preferredCulture
     * @param \patest\StructType\GlobalString $titleName
     * @param string $titleType
     */
    public function __construct($cultureId = null, \patest\StructType\GlobalString $jobTitleName = null, $jobTitleType = null, \patest\StructType\GlobalString $maritalStatusName = null, \patest\StructType\Crm_ClientImage4Printing $picture = null, \patest\StructType\ScreenParts_SupportedCulture $preferredCulture = null, \patest\StructType\GlobalString $titleName = null, $titleType = null)
    {
        $this
            ->setCultureId($cultureId)
            ->setJobTitleName($jobTitleName)
            ->setJobTitleType($jobTitleType)
            ->setMaritalStatusName($maritalStatusName)
            ->setPicture($picture)
            ->setPreferredCulture($preferredCulture)
            ->setTitleName($titleName)
            ->setTitleType($titleType);
    }
    /**
     * Get CultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCultureId()
    {
        return isset($this->CultureId) ? $this->CultureId : null;
    }
    /**
     * Set CultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cultureId
     * @return \patest\StructType\Crm_StandaloneCustomer4Printing
     */
    public function setCultureId($cultureId = null)
    {
        // validation for constraint: int
        if (!is_null($cultureId) && !(is_int($cultureId) || ctype_digit($cultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cultureId, true), gettype($cultureId)), __LINE__);
        }
        if (is_null($cultureId) || (is_array($cultureId) && empty($cultureId))) {
            unset($this->CultureId);
        } else {
            $this->CultureId = $cultureId;
        }
        return $this;
    }
    /**
     * Get JobTitleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getJobTitleName()
    {
        return isset($this->JobTitleName) ? $this->JobTitleName : null;
    }
    /**
     * Set JobTitleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $jobTitleName
     * @return \patest\StructType\Crm_StandaloneCustomer4Printing
     */
    public function setJobTitleName(\patest\StructType\GlobalString $jobTitleName = null)
    {
        if (is_null($jobTitleName) || (is_array($jobTitleName) && empty($jobTitleName))) {
            unset($this->JobTitleName);
        } else {
            $this->JobTitleName = $jobTitleName;
        }
        return $this;
    }
    /**
     * Get JobTitleType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJobTitleType()
    {
        return isset($this->JobTitleType) ? $this->JobTitleType : null;
    }
    /**
     * Set JobTitleType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TitleKind::valueIsValid()
     * @uses \patest\EnumType\TitleKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $jobTitleType
     * @return \patest\StructType\Crm_StandaloneCustomer4Printing
     */
    public function setJobTitleType($jobTitleType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TitleKind::valueIsValid($jobTitleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TitleKind', is_array($jobTitleType) ? implode(', ', $jobTitleType) : var_export($jobTitleType, true), implode(', ', \patest\EnumType\TitleKind::getValidValues())), __LINE__);
        }
        if (is_null($jobTitleType) || (is_array($jobTitleType) && empty($jobTitleType))) {
            unset($this->JobTitleType);
        } else {
            $this->JobTitleType = $jobTitleType;
        }
        return $this;
    }
    /**
     * Get MaritalStatusName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMaritalStatusName()
    {
        return isset($this->MaritalStatusName) ? $this->MaritalStatusName : null;
    }
    /**
     * Set MaritalStatusName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $maritalStatusName
     * @return \patest\StructType\Crm_StandaloneCustomer4Printing
     */
    public function setMaritalStatusName(\patest\StructType\GlobalString $maritalStatusName = null)
    {
        if (is_null($maritalStatusName) || (is_array($maritalStatusName) && empty($maritalStatusName))) {
            unset($this->MaritalStatusName);
        } else {
            $this->MaritalStatusName = $maritalStatusName;
        }
        return $this;
    }
    /**
     * Get Picture value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_ClientImage4Printing|null
     */
    public function getPicture()
    {
        return isset($this->Picture) ? $this->Picture : null;
    }
    /**
     * Set Picture value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_ClientImage4Printing $picture
     * @return \patest\StructType\Crm_StandaloneCustomer4Printing
     */
    public function setPicture(\patest\StructType\Crm_ClientImage4Printing $picture = null)
    {
        if (is_null($picture) || (is_array($picture) && empty($picture))) {
            unset($this->Picture);
        } else {
            $this->Picture = $picture;
        }
        return $this;
    }
    /**
     * Get PreferredCulture value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ScreenParts_SupportedCulture|null
     */
    public function getPreferredCulture()
    {
        return isset($this->PreferredCulture) ? $this->PreferredCulture : null;
    }
    /**
     * Set PreferredCulture value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ScreenParts_SupportedCulture $preferredCulture
     * @return \patest\StructType\Crm_StandaloneCustomer4Printing
     */
    public function setPreferredCulture(\patest\StructType\ScreenParts_SupportedCulture $preferredCulture = null)
    {
        if (is_null($preferredCulture) || (is_array($preferredCulture) && empty($preferredCulture))) {
            unset($this->PreferredCulture);
        } else {
            $this->PreferredCulture = $preferredCulture;
        }
        return $this;
    }
    /**
     * Get TitleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTitleName()
    {
        return isset($this->TitleName) ? $this->TitleName : null;
    }
    /**
     * Set TitleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $titleName
     * @return \patest\StructType\Crm_StandaloneCustomer4Printing
     */
    public function setTitleName(\patest\StructType\GlobalString $titleName = null)
    {
        if (is_null($titleName) || (is_array($titleName) && empty($titleName))) {
            unset($this->TitleName);
        } else {
            $this->TitleName = $titleName;
        }
        return $this;
    }
    /**
     * Get TitleType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitleType()
    {
        return isset($this->TitleType) ? $this->TitleType : null;
    }
    /**
     * Set TitleType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TitleKind::valueIsValid()
     * @uses \patest\EnumType\TitleKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $titleType
     * @return \patest\StructType\Crm_StandaloneCustomer4Printing
     */
    public function setTitleType($titleType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TitleKind::valueIsValid($titleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TitleKind', is_array($titleType) ? implode(', ', $titleType) : var_export($titleType, true), implode(', ', \patest\EnumType\TitleKind::getValidValues())), __LINE__);
        }
        if (is_null($titleType) || (is_array($titleType) && empty($titleType))) {
            unset($this->TitleType);
        } else {
            $this->TitleType = $titleType;
        }
        return $this;
    }
}
