<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.SimplifiedDataProtection StructType
 * @subpackage Structs
 */
class Crm_SimplifiedDataProtection extends AnyEntity
{
    /**
     * The Answer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Answer;
    /**
     * The AnsweredDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AnsweredDate;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DataProtectionQuestionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DataProtectionQuestionId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The LongQuestionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LongQuestionName;
    /**
     * The QuestionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QuestionName;
    /**
     * Constructor method for Crm.SimplifiedDataProtection
     * @uses Crm_SimplifiedDataProtection::setAnswer()
     * @uses Crm_SimplifiedDataProtection::setAnsweredDate()
     * @uses Crm_SimplifiedDataProtection::setClientId()
     * @uses Crm_SimplifiedDataProtection::setDataProtectionQuestionId()
     * @uses Crm_SimplifiedDataProtection::setId()
     * @uses Crm_SimplifiedDataProtection::setLongQuestionName()
     * @uses Crm_SimplifiedDataProtection::setQuestionName()
     * @param string $answer
     * @param string $answeredDate
     * @param string $clientId
     * @param string $dataProtectionQuestionId
     * @param string $id
     * @param string $longQuestionName
     * @param string $questionName
     */
    public function __construct($answer = null, $answeredDate = null, $clientId = null, $dataProtectionQuestionId = null, $id = null, $longQuestionName = null, $questionName = null)
    {
        $this
            ->setAnswer($answer)
            ->setAnsweredDate($answeredDate)
            ->setClientId($clientId)
            ->setDataProtectionQuestionId($dataProtectionQuestionId)
            ->setId($id)
            ->setLongQuestionName($longQuestionName)
            ->setQuestionName($questionName);
    }
    /**
     * Get Answer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnswer()
    {
        return isset($this->Answer) ? $this->Answer : null;
    }
    /**
     * Set Answer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DataProtectionAnswerKind::valueIsValid()
     * @uses \patest\EnumType\DataProtectionAnswerKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answer
     * @return \patest\StructType\Crm_SimplifiedDataProtection
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DataProtectionAnswerKind::valueIsValid($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DataProtectionAnswerKind', is_array($answer) ? implode(', ', $answer) : var_export($answer, true), implode(', ', \patest\EnumType\DataProtectionAnswerKind::getValidValues())), __LINE__);
        }
        if (is_null($answer) || (is_array($answer) && empty($answer))) {
            unset($this->Answer);
        } else {
            $this->Answer = $answer;
        }
        return $this;
    }
    /**
     * Get AnsweredDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnsweredDate()
    {
        return isset($this->AnsweredDate) ? $this->AnsweredDate : null;
    }
    /**
     * Set AnsweredDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $answeredDate
     * @return \patest\StructType\Crm_SimplifiedDataProtection
     */
    public function setAnsweredDate($answeredDate = null)
    {
        // validation for constraint: string
        if (!is_null($answeredDate) && !is_string($answeredDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answeredDate, true), gettype($answeredDate)), __LINE__);
        }
        if (is_null($answeredDate) || (is_array($answeredDate) && empty($answeredDate))) {
            unset($this->AnsweredDate);
        } else {
            $this->AnsweredDate = $answeredDate;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Crm_SimplifiedDataProtection
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DataProtectionQuestionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataProtectionQuestionId()
    {
        return isset($this->DataProtectionQuestionId) ? $this->DataProtectionQuestionId : null;
    }
    /**
     * Set DataProtectionQuestionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataProtectionQuestionId
     * @return \patest\StructType\Crm_SimplifiedDataProtection
     */
    public function setDataProtectionQuestionId($dataProtectionQuestionId = null)
    {
        // validation for constraint: string
        if (!is_null($dataProtectionQuestionId) && !is_string($dataProtectionQuestionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataProtectionQuestionId, true), gettype($dataProtectionQuestionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dataProtectionQuestionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dataProtectionQuestionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dataProtectionQuestionId, true)), __LINE__);
        }
        if (is_null($dataProtectionQuestionId) || (is_array($dataProtectionQuestionId) && empty($dataProtectionQuestionId))) {
            unset($this->DataProtectionQuestionId);
        } else {
            $this->DataProtectionQuestionId = $dataProtectionQuestionId;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Crm_SimplifiedDataProtection
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get LongQuestionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLongQuestionName()
    {
        return isset($this->LongQuestionName) ? $this->LongQuestionName : null;
    }
    /**
     * Set LongQuestionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $longQuestionName
     * @return \patest\StructType\Crm_SimplifiedDataProtection
     */
    public function setLongQuestionName($longQuestionName = null)
    {
        // validation for constraint: string
        if (!is_null($longQuestionName) && !is_string($longQuestionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longQuestionName, true), gettype($longQuestionName)), __LINE__);
        }
        if (is_null($longQuestionName) || (is_array($longQuestionName) && empty($longQuestionName))) {
            unset($this->LongQuestionName);
        } else {
            $this->LongQuestionName = $longQuestionName;
        }
        return $this;
    }
    /**
     * Get QuestionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQuestionName()
    {
        return isset($this->QuestionName) ? $this->QuestionName : null;
    }
    /**
     * Set QuestionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $questionName
     * @return \patest\StructType\Crm_SimplifiedDataProtection
     */
    public function setQuestionName($questionName = null)
    {
        // validation for constraint: string
        if (!is_null($questionName) && !is_string($questionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionName, true), gettype($questionName)), __LINE__);
        }
        if (is_null($questionName) || (is_array($questionName) && empty($questionName))) {
            unset($this->QuestionName);
        } else {
            $this->QuestionName = $questionName;
        }
        return $this;
    }
}
