<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.SimplifiedClient StructType
 * @subpackage Structs
 */
class Crm_SimplifiedClient extends AnyEntity
{
    /**
     * The AllAddresses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_SimplifiedAddress
     */
    public $AllAddresses;
    /**
     * The BusinessAddresses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_SimplifiedAddress
     */
    public $BusinessAddresses;
    /**
     * The BusinessPhones
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $BusinessPhones;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ClientTypeDetail
     */
    public $ClientTypes;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The Custom1Contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $Custom1Contact;
    /**
     * The Custom2Contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $Custom2Contact;
    /**
     * The Custom3Contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $Custom3Contact;
    /**
     * The Custom4Contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $Custom4Contact;
    /**
     * The Custom5Contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $Custom5Contact;
    /**
     * The Custom6Contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $Custom6Contact;
    /**
     * The Custom7Contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $Custom7Contact;
    /**
     * The Custom8Contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $Custom8Contact;
    /**
     * The Custom9Contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $Custom9Contact;
    /**
     * The DataProtections
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_SimplifiedDataProtection
     */
    public $DataProtections;
    /**
     * The DoNotMerge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DoNotMerge;
    /**
     * The Emails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $Emails;
    /**
     * The ExemptValidUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExemptValidUntil;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The ExtraFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_ClientExtraFields
     */
    public $ExtraFields;
    /**
     * The Faxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $Faxes;
    /**
     * The ForceCreate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ForceCreate;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The HomeAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_SimplifiedAddress
     */
    public $HomeAddress;
    /**
     * The HomePhones
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $HomePhones;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The ImageId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ImageId;
    /**
     * The IsHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHidden;
    /**
     * The IssuerCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IssuerCompanyId;
    /**
     * The MobilePhones
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $MobilePhones;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The PreferenceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PreferenceIds
     */
    public $PreferenceIds;
    /**
     * The PreferredCultureId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PreferredCultureId;
    /**
     * The SalutationIndividualText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalutationIndividualText;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_ClientStatusDetail
     */
    public $Status;
    /**
     * The TaxExemptNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxExemptNumber;
    /**
     * The TemporaryAddresses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_SimplifiedAddress
     */
    public $TemporaryAddresses;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Type;
    /**
     * The WebSites
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $WebSites;
    /**
     * Constructor method for Crm.SimplifiedClient
     * @uses Crm_SimplifiedClient::setAllAddresses()
     * @uses Crm_SimplifiedClient::setBusinessAddresses()
     * @uses Crm_SimplifiedClient::setBusinessPhones()
     * @uses Crm_SimplifiedClient::setClientTypes()
     * @uses Crm_SimplifiedClient::setCrmId()
     * @uses Crm_SimplifiedClient::setCustom1Contact()
     * @uses Crm_SimplifiedClient::setCustom2Contact()
     * @uses Crm_SimplifiedClient::setCustom3Contact()
     * @uses Crm_SimplifiedClient::setCustom4Contact()
     * @uses Crm_SimplifiedClient::setCustom5Contact()
     * @uses Crm_SimplifiedClient::setCustom6Contact()
     * @uses Crm_SimplifiedClient::setCustom7Contact()
     * @uses Crm_SimplifiedClient::setCustom8Contact()
     * @uses Crm_SimplifiedClient::setCustom9Contact()
     * @uses Crm_SimplifiedClient::setDataProtections()
     * @uses Crm_SimplifiedClient::setDoNotMerge()
     * @uses Crm_SimplifiedClient::setEmails()
     * @uses Crm_SimplifiedClient::setExemptValidUntil()
     * @uses Crm_SimplifiedClient::setExternalId()
     * @uses Crm_SimplifiedClient::setExtraFields()
     * @uses Crm_SimplifiedClient::setFaxes()
     * @uses Crm_SimplifiedClient::setForceCreate()
     * @uses Crm_SimplifiedClient::setHolderCompanyId()
     * @uses Crm_SimplifiedClient::setHomeAddress()
     * @uses Crm_SimplifiedClient::setHomePhones()
     * @uses Crm_SimplifiedClient::setId()
     * @uses Crm_SimplifiedClient::setImageId()
     * @uses Crm_SimplifiedClient::setIsHidden()
     * @uses Crm_SimplifiedClient::setIssuerCompanyId()
     * @uses Crm_SimplifiedClient::setMobilePhones()
     * @uses Crm_SimplifiedClient::setNote()
     * @uses Crm_SimplifiedClient::setPreferenceIds()
     * @uses Crm_SimplifiedClient::setPreferredCultureId()
     * @uses Crm_SimplifiedClient::setSalutationIndividualText()
     * @uses Crm_SimplifiedClient::setStatus()
     * @uses Crm_SimplifiedClient::setTaxExemptNumber()
     * @uses Crm_SimplifiedClient::setTemporaryAddresses()
     * @uses Crm_SimplifiedClient::setType()
     * @uses Crm_SimplifiedClient::setWebSites()
     * @param \patest\StructType\RecordSetOfCrm_SimplifiedAddress $allAddresses
     * @param \patest\StructType\RecordSetOfCrm_SimplifiedAddress $businessAddresses
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $businessPhones
     * @param \patest\StructType\RecordSetOfCrm_ClientTypeDetail $clientTypes
     * @param string $crmId
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom1Contact
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom2Contact
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom3Contact
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom4Contact
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom5Contact
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom6Contact
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom7Contact
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom8Contact
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom9Contact
     * @param \patest\StructType\RecordSetOfCrm_SimplifiedDataProtection $dataProtections
     * @param bool $doNotMerge
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $emails
     * @param string $exemptValidUntil
     * @param string $externalId
     * @param \patest\StructType\Crm_ClientExtraFields $extraFields
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $faxes
     * @param bool $forceCreate
     * @param int $holderCompanyId
     * @param \patest\StructType\Crm_SimplifiedAddress $homeAddress
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $homePhones
     * @param string $id
     * @param string $imageId
     * @param bool $isHidden
     * @param int $issuerCompanyId
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $mobilePhones
     * @param string $note
     * @param \patest\StructType\PreferenceIds $preferenceIds
     * @param string $preferredCultureId
     * @param string $salutationIndividualText
     * @param \patest\StructType\Crm_ClientStatusDetail $status
     * @param string $taxExemptNumber
     * @param \patest\StructType\RecordSetOfCrm_SimplifiedAddress $temporaryAddresses
     * @param string[] $type
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $webSites
     */
    public function __construct(\patest\StructType\RecordSetOfCrm_SimplifiedAddress $allAddresses = null, \patest\StructType\RecordSetOfCrm_SimplifiedAddress $businessAddresses = null, \patest\StructType\RecordSetOfCrm_ContactDetail $businessPhones = null, \patest\StructType\RecordSetOfCrm_ClientTypeDetail $clientTypes = null, $crmId = null, \patest\StructType\RecordSetOfCrm_ContactDetail $custom1Contact = null, \patest\StructType\RecordSetOfCrm_ContactDetail $custom2Contact = null, \patest\StructType\RecordSetOfCrm_ContactDetail $custom3Contact = null, \patest\StructType\RecordSetOfCrm_ContactDetail $custom4Contact = null, \patest\StructType\RecordSetOfCrm_ContactDetail $custom5Contact = null, \patest\StructType\RecordSetOfCrm_ContactDetail $custom6Contact = null, \patest\StructType\RecordSetOfCrm_ContactDetail $custom7Contact = null, \patest\StructType\RecordSetOfCrm_ContactDetail $custom8Contact = null, \patest\StructType\RecordSetOfCrm_ContactDetail $custom9Contact = null, \patest\StructType\RecordSetOfCrm_SimplifiedDataProtection $dataProtections = null, $doNotMerge = null, \patest\StructType\RecordSetOfCrm_ContactDetail $emails = null, $exemptValidUntil = null, $externalId = null, \patest\StructType\Crm_ClientExtraFields $extraFields = null, \patest\StructType\RecordSetOfCrm_ContactDetail $faxes = null, $forceCreate = null, $holderCompanyId = null, \patest\StructType\Crm_SimplifiedAddress $homeAddress = null, \patest\StructType\RecordSetOfCrm_ContactDetail $homePhones = null, $id = null, $imageId = null, $isHidden = null, $issuerCompanyId = null, \patest\StructType\RecordSetOfCrm_ContactDetail $mobilePhones = null, $note = null, \patest\StructType\PreferenceIds $preferenceIds = null, $preferredCultureId = null, $salutationIndividualText = null, \patest\StructType\Crm_ClientStatusDetail $status = null, $taxExemptNumber = null, \patest\StructType\RecordSetOfCrm_SimplifiedAddress $temporaryAddresses = null, array $type = array(), \patest\StructType\RecordSetOfCrm_ContactDetail $webSites = null)
    {
        $this
            ->setAllAddresses($allAddresses)
            ->setBusinessAddresses($businessAddresses)
            ->setBusinessPhones($businessPhones)
            ->setClientTypes($clientTypes)
            ->setCrmId($crmId)
            ->setCustom1Contact($custom1Contact)
            ->setCustom2Contact($custom2Contact)
            ->setCustom3Contact($custom3Contact)
            ->setCustom4Contact($custom4Contact)
            ->setCustom5Contact($custom5Contact)
            ->setCustom6Contact($custom6Contact)
            ->setCustom7Contact($custom7Contact)
            ->setCustom8Contact($custom8Contact)
            ->setCustom9Contact($custom9Contact)
            ->setDataProtections($dataProtections)
            ->setDoNotMerge($doNotMerge)
            ->setEmails($emails)
            ->setExemptValidUntil($exemptValidUntil)
            ->setExternalId($externalId)
            ->setExtraFields($extraFields)
            ->setFaxes($faxes)
            ->setForceCreate($forceCreate)
            ->setHolderCompanyId($holderCompanyId)
            ->setHomeAddress($homeAddress)
            ->setHomePhones($homePhones)
            ->setId($id)
            ->setImageId($imageId)
            ->setIsHidden($isHidden)
            ->setIssuerCompanyId($issuerCompanyId)
            ->setMobilePhones($mobilePhones)
            ->setNote($note)
            ->setPreferenceIds($preferenceIds)
            ->setPreferredCultureId($preferredCultureId)
            ->setSalutationIndividualText($salutationIndividualText)
            ->setStatus($status)
            ->setTaxExemptNumber($taxExemptNumber)
            ->setTemporaryAddresses($temporaryAddresses)
            ->setType($type)
            ->setWebSites($webSites);
    }
    /**
     * Get AllAddresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_SimplifiedAddress|null
     */
    public function getAllAddresses()
    {
        return isset($this->AllAddresses) ? $this->AllAddresses : null;
    }
    /**
     * Set AllAddresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_SimplifiedAddress $allAddresses
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setAllAddresses(\patest\StructType\RecordSetOfCrm_SimplifiedAddress $allAddresses = null)
    {
        if (is_null($allAddresses) || (is_array($allAddresses) && empty($allAddresses))) {
            unset($this->AllAddresses);
        } else {
            $this->AllAddresses = $allAddresses;
        }
        return $this;
    }
    /**
     * Get BusinessAddresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_SimplifiedAddress|null
     */
    public function getBusinessAddresses()
    {
        return isset($this->BusinessAddresses) ? $this->BusinessAddresses : null;
    }
    /**
     * Set BusinessAddresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_SimplifiedAddress $businessAddresses
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setBusinessAddresses(\patest\StructType\RecordSetOfCrm_SimplifiedAddress $businessAddresses = null)
    {
        if (is_null($businessAddresses) || (is_array($businessAddresses) && empty($businessAddresses))) {
            unset($this->BusinessAddresses);
        } else {
            $this->BusinessAddresses = $businessAddresses;
        }
        return $this;
    }
    /**
     * Get BusinessPhones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getBusinessPhones()
    {
        return isset($this->BusinessPhones) ? $this->BusinessPhones : null;
    }
    /**
     * Set BusinessPhones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $businessPhones
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setBusinessPhones(\patest\StructType\RecordSetOfCrm_ContactDetail $businessPhones = null)
    {
        if (is_null($businessPhones) || (is_array($businessPhones) && empty($businessPhones))) {
            unset($this->BusinessPhones);
        } else {
            $this->BusinessPhones = $businessPhones;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ClientTypeDetail|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ClientTypeDetail $clientTypes
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setClientTypes(\patest\StructType\RecordSetOfCrm_ClientTypeDetail $clientTypes = null)
    {
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get Custom1Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getCustom1Contact()
    {
        return isset($this->Custom1Contact) ? $this->Custom1Contact : null;
    }
    /**
     * Set Custom1Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom1Contact
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setCustom1Contact(\patest\StructType\RecordSetOfCrm_ContactDetail $custom1Contact = null)
    {
        if (is_null($custom1Contact) || (is_array($custom1Contact) && empty($custom1Contact))) {
            unset($this->Custom1Contact);
        } else {
            $this->Custom1Contact = $custom1Contact;
        }
        return $this;
    }
    /**
     * Get Custom2Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getCustom2Contact()
    {
        return isset($this->Custom2Contact) ? $this->Custom2Contact : null;
    }
    /**
     * Set Custom2Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom2Contact
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setCustom2Contact(\patest\StructType\RecordSetOfCrm_ContactDetail $custom2Contact = null)
    {
        if (is_null($custom2Contact) || (is_array($custom2Contact) && empty($custom2Contact))) {
            unset($this->Custom2Contact);
        } else {
            $this->Custom2Contact = $custom2Contact;
        }
        return $this;
    }
    /**
     * Get Custom3Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getCustom3Contact()
    {
        return isset($this->Custom3Contact) ? $this->Custom3Contact : null;
    }
    /**
     * Set Custom3Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom3Contact
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setCustom3Contact(\patest\StructType\RecordSetOfCrm_ContactDetail $custom3Contact = null)
    {
        if (is_null($custom3Contact) || (is_array($custom3Contact) && empty($custom3Contact))) {
            unset($this->Custom3Contact);
        } else {
            $this->Custom3Contact = $custom3Contact;
        }
        return $this;
    }
    /**
     * Get Custom4Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getCustom4Contact()
    {
        return isset($this->Custom4Contact) ? $this->Custom4Contact : null;
    }
    /**
     * Set Custom4Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom4Contact
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setCustom4Contact(\patest\StructType\RecordSetOfCrm_ContactDetail $custom4Contact = null)
    {
        if (is_null($custom4Contact) || (is_array($custom4Contact) && empty($custom4Contact))) {
            unset($this->Custom4Contact);
        } else {
            $this->Custom4Contact = $custom4Contact;
        }
        return $this;
    }
    /**
     * Get Custom5Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getCustom5Contact()
    {
        return isset($this->Custom5Contact) ? $this->Custom5Contact : null;
    }
    /**
     * Set Custom5Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom5Contact
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setCustom5Contact(\patest\StructType\RecordSetOfCrm_ContactDetail $custom5Contact = null)
    {
        if (is_null($custom5Contact) || (is_array($custom5Contact) && empty($custom5Contact))) {
            unset($this->Custom5Contact);
        } else {
            $this->Custom5Contact = $custom5Contact;
        }
        return $this;
    }
    /**
     * Get Custom6Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getCustom6Contact()
    {
        return isset($this->Custom6Contact) ? $this->Custom6Contact : null;
    }
    /**
     * Set Custom6Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom6Contact
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setCustom6Contact(\patest\StructType\RecordSetOfCrm_ContactDetail $custom6Contact = null)
    {
        if (is_null($custom6Contact) || (is_array($custom6Contact) && empty($custom6Contact))) {
            unset($this->Custom6Contact);
        } else {
            $this->Custom6Contact = $custom6Contact;
        }
        return $this;
    }
    /**
     * Get Custom7Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getCustom7Contact()
    {
        return isset($this->Custom7Contact) ? $this->Custom7Contact : null;
    }
    /**
     * Set Custom7Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom7Contact
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setCustom7Contact(\patest\StructType\RecordSetOfCrm_ContactDetail $custom7Contact = null)
    {
        if (is_null($custom7Contact) || (is_array($custom7Contact) && empty($custom7Contact))) {
            unset($this->Custom7Contact);
        } else {
            $this->Custom7Contact = $custom7Contact;
        }
        return $this;
    }
    /**
     * Get Custom8Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getCustom8Contact()
    {
        return isset($this->Custom8Contact) ? $this->Custom8Contact : null;
    }
    /**
     * Set Custom8Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom8Contact
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setCustom8Contact(\patest\StructType\RecordSetOfCrm_ContactDetail $custom8Contact = null)
    {
        if (is_null($custom8Contact) || (is_array($custom8Contact) && empty($custom8Contact))) {
            unset($this->Custom8Contact);
        } else {
            $this->Custom8Contact = $custom8Contact;
        }
        return $this;
    }
    /**
     * Get Custom9Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getCustom9Contact()
    {
        return isset($this->Custom9Contact) ? $this->Custom9Contact : null;
    }
    /**
     * Set Custom9Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $custom9Contact
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setCustom9Contact(\patest\StructType\RecordSetOfCrm_ContactDetail $custom9Contact = null)
    {
        if (is_null($custom9Contact) || (is_array($custom9Contact) && empty($custom9Contact))) {
            unset($this->Custom9Contact);
        } else {
            $this->Custom9Contact = $custom9Contact;
        }
        return $this;
    }
    /**
     * Get DataProtections value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_SimplifiedDataProtection|null
     */
    public function getDataProtections()
    {
        return isset($this->DataProtections) ? $this->DataProtections : null;
    }
    /**
     * Set DataProtections value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_SimplifiedDataProtection $dataProtections
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setDataProtections(\patest\StructType\RecordSetOfCrm_SimplifiedDataProtection $dataProtections = null)
    {
        if (is_null($dataProtections) || (is_array($dataProtections) && empty($dataProtections))) {
            unset($this->DataProtections);
        } else {
            $this->DataProtections = $dataProtections;
        }
        return $this;
    }
    /**
     * Get DoNotMerge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDoNotMerge()
    {
        return isset($this->DoNotMerge) ? $this->DoNotMerge : null;
    }
    /**
     * Set DoNotMerge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $doNotMerge
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setDoNotMerge($doNotMerge = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotMerge) && !is_bool($doNotMerge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotMerge, true), gettype($doNotMerge)), __LINE__);
        }
        if (is_null($doNotMerge) || (is_array($doNotMerge) && empty($doNotMerge))) {
            unset($this->DoNotMerge);
        } else {
            $this->DoNotMerge = $doNotMerge;
        }
        return $this;
    }
    /**
     * Get Emails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getEmails()
    {
        return isset($this->Emails) ? $this->Emails : null;
    }
    /**
     * Set Emails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $emails
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setEmails(\patest\StructType\RecordSetOfCrm_ContactDetail $emails = null)
    {
        if (is_null($emails) || (is_array($emails) && empty($emails))) {
            unset($this->Emails);
        } else {
            $this->Emails = $emails;
        }
        return $this;
    }
    /**
     * Get ExemptValidUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExemptValidUntil()
    {
        return isset($this->ExemptValidUntil) ? $this->ExemptValidUntil : null;
    }
    /**
     * Set ExemptValidUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exemptValidUntil
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setExemptValidUntil($exemptValidUntil = null)
    {
        // validation for constraint: string
        if (!is_null($exemptValidUntil) && !is_string($exemptValidUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exemptValidUntil, true), gettype($exemptValidUntil)), __LINE__);
        }
        if (is_null($exemptValidUntil) || (is_array($exemptValidUntil) && empty($exemptValidUntil))) {
            unset($this->ExemptValidUntil);
        } else {
            $this->ExemptValidUntil = $exemptValidUntil;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get ExtraFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_ClientExtraFields|null
     */
    public function getExtraFields()
    {
        return isset($this->ExtraFields) ? $this->ExtraFields : null;
    }
    /**
     * Set ExtraFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_ClientExtraFields $extraFields
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setExtraFields(\patest\StructType\Crm_ClientExtraFields $extraFields = null)
    {
        if (is_null($extraFields) || (is_array($extraFields) && empty($extraFields))) {
            unset($this->ExtraFields);
        } else {
            $this->ExtraFields = $extraFields;
        }
        return $this;
    }
    /**
     * Get Faxes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getFaxes()
    {
        return isset($this->Faxes) ? $this->Faxes : null;
    }
    /**
     * Set Faxes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $faxes
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setFaxes(\patest\StructType\RecordSetOfCrm_ContactDetail $faxes = null)
    {
        if (is_null($faxes) || (is_array($faxes) && empty($faxes))) {
            unset($this->Faxes);
        } else {
            $this->Faxes = $faxes;
        }
        return $this;
    }
    /**
     * Get ForceCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceCreate()
    {
        return isset($this->ForceCreate) ? $this->ForceCreate : null;
    }
    /**
     * Set ForceCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceCreate
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setForceCreate($forceCreate = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceCreate) && !is_bool($forceCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceCreate, true), gettype($forceCreate)), __LINE__);
        }
        if (is_null($forceCreate) || (is_array($forceCreate) && empty($forceCreate))) {
            unset($this->ForceCreate);
        } else {
            $this->ForceCreate = $forceCreate;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get HomeAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_SimplifiedAddress|null
     */
    public function getHomeAddress()
    {
        return isset($this->HomeAddress) ? $this->HomeAddress : null;
    }
    /**
     * Set HomeAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_SimplifiedAddress $homeAddress
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setHomeAddress(\patest\StructType\Crm_SimplifiedAddress $homeAddress = null)
    {
        if (is_null($homeAddress) || (is_array($homeAddress) && empty($homeAddress))) {
            unset($this->HomeAddress);
        } else {
            $this->HomeAddress = $homeAddress;
        }
        return $this;
    }
    /**
     * Get HomePhones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getHomePhones()
    {
        return isset($this->HomePhones) ? $this->HomePhones : null;
    }
    /**
     * Set HomePhones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $homePhones
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setHomePhones(\patest\StructType\RecordSetOfCrm_ContactDetail $homePhones = null)
    {
        if (is_null($homePhones) || (is_array($homePhones) && empty($homePhones))) {
            unset($this->HomePhones);
        } else {
            $this->HomePhones = $homePhones;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get ImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageId()
    {
        return isset($this->ImageId) ? $this->ImageId : null;
    }
    /**
     * Set ImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageId
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setImageId($imageId = null)
    {
        // validation for constraint: string
        if (!is_null($imageId) && !is_string($imageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageId, true), gettype($imageId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($imageId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $imageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($imageId, true)), __LINE__);
        }
        if (is_null($imageId) || (is_array($imageId) && empty($imageId))) {
            unset($this->ImageId);
        } else {
            $this->ImageId = $imageId;
        }
        return $this;
    }
    /**
     * Get IsHidden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHidden()
    {
        return isset($this->IsHidden) ? $this->IsHidden : null;
    }
    /**
     * Set IsHidden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHidden
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHidden) && !is_bool($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHidden, true), gettype($isHidden)), __LINE__);
        }
        if (is_null($isHidden) || (is_array($isHidden) && empty($isHidden))) {
            unset($this->IsHidden);
        } else {
            $this->IsHidden = $isHidden;
        }
        return $this;
    }
    /**
     * Get IssuerCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIssuerCompanyId()
    {
        return isset($this->IssuerCompanyId) ? $this->IssuerCompanyId : null;
    }
    /**
     * Set IssuerCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $issuerCompanyId
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setIssuerCompanyId($issuerCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerCompanyId) && !(is_int($issuerCompanyId) || ctype_digit($issuerCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerCompanyId, true), gettype($issuerCompanyId)), __LINE__);
        }
        if (is_null($issuerCompanyId) || (is_array($issuerCompanyId) && empty($issuerCompanyId))) {
            unset($this->IssuerCompanyId);
        } else {
            $this->IssuerCompanyId = $issuerCompanyId;
        }
        return $this;
    }
    /**
     * Get MobilePhones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getMobilePhones()
    {
        return isset($this->MobilePhones) ? $this->MobilePhones : null;
    }
    /**
     * Set MobilePhones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $mobilePhones
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setMobilePhones(\patest\StructType\RecordSetOfCrm_ContactDetail $mobilePhones = null)
    {
        if (is_null($mobilePhones) || (is_array($mobilePhones) && empty($mobilePhones))) {
            unset($this->MobilePhones);
        } else {
            $this->MobilePhones = $mobilePhones;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get PreferenceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PreferenceIds|null
     */
    public function getPreferenceIds()
    {
        return isset($this->PreferenceIds) ? $this->PreferenceIds : null;
    }
    /**
     * Set PreferenceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PreferenceIds $preferenceIds
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setPreferenceIds(\patest\StructType\PreferenceIds $preferenceIds = null)
    {
        if (is_null($preferenceIds) || (is_array($preferenceIds) && empty($preferenceIds))) {
            unset($this->PreferenceIds);
        } else {
            $this->PreferenceIds = $preferenceIds;
        }
        return $this;
    }
    /**
     * Get PreferredCultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredCultureId()
    {
        return isset($this->PreferredCultureId) ? $this->PreferredCultureId : null;
    }
    /**
     * Set PreferredCultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredCultureId
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setPreferredCultureId($preferredCultureId = null)
    {
        // validation for constraint: string
        if (!is_null($preferredCultureId) && !is_string($preferredCultureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredCultureId, true), gettype($preferredCultureId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($preferredCultureId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $preferredCultureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($preferredCultureId, true)), __LINE__);
        }
        if (is_null($preferredCultureId) || (is_array($preferredCultureId) && empty($preferredCultureId))) {
            unset($this->PreferredCultureId);
        } else {
            $this->PreferredCultureId = $preferredCultureId;
        }
        return $this;
    }
    /**
     * Get SalutationIndividualText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalutationIndividualText()
    {
        return isset($this->SalutationIndividualText) ? $this->SalutationIndividualText : null;
    }
    /**
     * Set SalutationIndividualText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salutationIndividualText
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setSalutationIndividualText($salutationIndividualText = null)
    {
        // validation for constraint: string
        if (!is_null($salutationIndividualText) && !is_string($salutationIndividualText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutationIndividualText, true), gettype($salutationIndividualText)), __LINE__);
        }
        if (is_null($salutationIndividualText) || (is_array($salutationIndividualText) && empty($salutationIndividualText))) {
            unset($this->SalutationIndividualText);
        } else {
            $this->SalutationIndividualText = $salutationIndividualText;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_ClientStatusDetail|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_ClientStatusDetail $status
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setStatus(\patest\StructType\Crm_ClientStatusDetail $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxExemptNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxExemptNumber()
    {
        return isset($this->TaxExemptNumber) ? $this->TaxExemptNumber : null;
    }
    /**
     * Set TaxExemptNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxExemptNumber
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setTaxExemptNumber($taxExemptNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxExemptNumber) && !is_string($taxExemptNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxExemptNumber, true), gettype($taxExemptNumber)), __LINE__);
        }
        if (is_null($taxExemptNumber) || (is_array($taxExemptNumber) && empty($taxExemptNumber))) {
            unset($this->TaxExemptNumber);
        } else {
            $this->TaxExemptNumber = $taxExemptNumber;
        }
        return $this;
    }
    /**
     * Get TemporaryAddresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_SimplifiedAddress|null
     */
    public function getTemporaryAddresses()
    {
        return isset($this->TemporaryAddresses) ? $this->TemporaryAddresses : null;
    }
    /**
     * Set TemporaryAddresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_SimplifiedAddress $temporaryAddresses
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setTemporaryAddresses(\patest\StructType\RecordSetOfCrm_SimplifiedAddress $temporaryAddresses = null)
    {
        if (is_null($temporaryAddresses) || (is_array($temporaryAddresses) && empty($temporaryAddresses))) {
            unset($this->TemporaryAddresses);
        } else {
            $this->TemporaryAddresses = $temporaryAddresses;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * This method is responsible for validating the values passed to the setType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeForArrayConstraintsFromSetType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $crm_SimplifiedClientTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($crm_SimplifiedClientTypeItem)) {
                $invalidValues[] = is_object($crm_SimplifiedClientTypeItem) ? get_class($crm_SimplifiedClientTypeItem) : sprintf('%s(%s)', gettype($crm_SimplifiedClientTypeItem), var_export($crm_SimplifiedClientTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $type
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setType(array $type = array())
    {
        // validation for constraint: list
        if ('' !== ($typeArrayErrorMessage = self::validateTypeForArrayConstraintsFromSetType($type))) {
            throw new \InvalidArgumentException($typeArrayErrorMessage, __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = is_array($type) ? implode(' ', $type) : null;
        }
        return $this;
    }
    /**
     * Get WebSites value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getWebSites()
    {
        return isset($this->WebSites) ? $this->WebSites : null;
    }
    /**
     * Set WebSites value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $webSites
     * @return \patest\StructType\Crm_SimplifiedClient
     */
    public function setWebSites(\patest\StructType\RecordSetOfCrm_ContactDetail $webSites = null)
    {
        if (is_null($webSites) || (is_array($webSites) && empty($webSites))) {
            unset($this->WebSites);
        } else {
            $this->WebSites = $webSites;
        }
        return $this;
    }
}
