<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.SalesRepresentative StructType
 * @subpackage Structs
 */
class Crm_SalesRepresentative extends DistributableEntity
{
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerId;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The SaleRepGoals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_SalesRepGoal
     */
    public $SaleRepGoals;
    /**
     * The SalesRepCategoryColor
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesRepCategoryColor;
    /**
     * The SalesRepCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepCategoryId;
    /**
     * The SalesRepCategoryName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SalesRepCategoryName;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Crm.SalesRepresentative
     * @uses Crm_SalesRepresentative::setCrmId()
     * @uses Crm_SalesRepresentative::setCustomerId()
     * @uses Crm_SalesRepresentative::setIsActive()
     * @uses Crm_SalesRepresentative::setName()
     * @uses Crm_SalesRepresentative::setOrganizationUnitId()
     * @uses Crm_SalesRepresentative::setSaleRepGoals()
     * @uses Crm_SalesRepresentative::setSalesRepCategoryColor()
     * @uses Crm_SalesRepresentative::setSalesRepCategoryId()
     * @uses Crm_SalesRepresentative::setSalesRepCategoryName()
     * @uses Crm_SalesRepresentative::setType()
     * @uses Crm_SalesRepresentative::setVisibleBySubordinates()
     * @param string $crmId
     * @param string $customerId
     * @param bool $isActive
     * @param string $name
     * @param string $organizationUnitId
     * @param \patest\StructType\RecordSetOfCrm_SalesRepGoal $saleRepGoals
     * @param string $salesRepCategoryColor
     * @param string $salesRepCategoryId
     * @param \patest\StructType\GlobalString $salesRepCategoryName
     * @param string $type
     * @param bool $visibleBySubordinates
     */
    public function __construct($crmId = null, $customerId = null, $isActive = null, $name = null, $organizationUnitId = null, \patest\StructType\RecordSetOfCrm_SalesRepGoal $saleRepGoals = null, $salesRepCategoryColor = null, $salesRepCategoryId = null, \patest\StructType\GlobalString $salesRepCategoryName = null, $type = null, $visibleBySubordinates = null)
    {
        $this
            ->setCrmId($crmId)
            ->setCustomerId($customerId)
            ->setIsActive($isActive)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setSaleRepGoals($saleRepGoals)
            ->setSalesRepCategoryColor($salesRepCategoryColor)
            ->setSalesRepCategoryId($salesRepCategoryId)
            ->setSalesRepCategoryName($salesRepCategoryName)
            ->setType($type)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Crm_SalesRepresentative
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get CustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerId()
    {
        return isset($this->CustomerId) ? $this->CustomerId : null;
    }
    /**
     * Set CustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerId
     * @return \patest\StructType\Crm_SalesRepresentative
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerId, true)), __LINE__);
        }
        if (is_null($customerId) || (is_array($customerId) && empty($customerId))) {
            unset($this->CustomerId);
        } else {
            $this->CustomerId = $customerId;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Crm_SalesRepresentative
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Crm_SalesRepresentative
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Crm_SalesRepresentative
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get SaleRepGoals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_SalesRepGoal|null
     */
    public function getSaleRepGoals()
    {
        return isset($this->SaleRepGoals) ? $this->SaleRepGoals : null;
    }
    /**
     * Set SaleRepGoals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_SalesRepGoal $saleRepGoals
     * @return \patest\StructType\Crm_SalesRepresentative
     */
    public function setSaleRepGoals(\patest\StructType\RecordSetOfCrm_SalesRepGoal $saleRepGoals = null)
    {
        if (is_null($saleRepGoals) || (is_array($saleRepGoals) && empty($saleRepGoals))) {
            unset($this->SaleRepGoals);
        } else {
            $this->SaleRepGoals = $saleRepGoals;
        }
        return $this;
    }
    /**
     * Get SalesRepCategoryColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepCategoryColor()
    {
        return isset($this->SalesRepCategoryColor) ? $this->SalesRepCategoryColor : null;
    }
    /**
     * Set SalesRepCategoryColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepCategoryColor
     * @return \patest\StructType\Crm_SalesRepresentative
     */
    public function setSalesRepCategoryColor($salesRepCategoryColor = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepCategoryColor) && !is_string($salesRepCategoryColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepCategoryColor, true), gettype($salesRepCategoryColor)), __LINE__);
        }
        if (is_null($salesRepCategoryColor) || (is_array($salesRepCategoryColor) && empty($salesRepCategoryColor))) {
            unset($this->SalesRepCategoryColor);
        } else {
            $this->SalesRepCategoryColor = $salesRepCategoryColor;
        }
        return $this;
    }
    /**
     * Get SalesRepCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepCategoryId()
    {
        return isset($this->SalesRepCategoryId) ? $this->SalesRepCategoryId : null;
    }
    /**
     * Set SalesRepCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepCategoryId
     * @return \patest\StructType\Crm_SalesRepresentative
     */
    public function setSalesRepCategoryId($salesRepCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepCategoryId) && !is_string($salesRepCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepCategoryId, true), gettype($salesRepCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepCategoryId, true)), __LINE__);
        }
        if (is_null($salesRepCategoryId) || (is_array($salesRepCategoryId) && empty($salesRepCategoryId))) {
            unset($this->SalesRepCategoryId);
        } else {
            $this->SalesRepCategoryId = $salesRepCategoryId;
        }
        return $this;
    }
    /**
     * Get SalesRepCategoryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSalesRepCategoryName()
    {
        return isset($this->SalesRepCategoryName) ? $this->SalesRepCategoryName : null;
    }
    /**
     * Set SalesRepCategoryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $salesRepCategoryName
     * @return \patest\StructType\Crm_SalesRepresentative
     */
    public function setSalesRepCategoryName(\patest\StructType\GlobalString $salesRepCategoryName = null)
    {
        if (is_null($salesRepCategoryName) || (is_array($salesRepCategoryName) && empty($salesRepCategoryName))) {
            unset($this->SalesRepCategoryName);
        } else {
            $this->SalesRepCategoryName = $salesRepCategoryName;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SalesRepType::valueIsValid()
     * @uses \patest\EnumType\SalesRepType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\Crm_SalesRepresentative
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SalesRepType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SalesRepType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\SalesRepType::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Crm_SalesRepresentative
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
