<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.RelationshipType StructType
 * @subpackage Structs
 */
class Crm_RelationshipType extends DistributableEntity
{
    /**
     * The AllowInGroupOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowInGroupOnline;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsClientGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsClientGroup;
    /**
     * The IsStrongByDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsStrongByDefault;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The Kind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kind;
    /**
     * The MaxAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxAllowed;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OnlineInstructions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $OnlineInstructions;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Roles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_RelationshipRole
     */
    public $Roles;
    /**
     * The ShouldTriggerEmailApproval
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldTriggerEmailApproval;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Crm.RelationshipType
     * @uses Crm_RelationshipType::setAllowInGroupOnline()
     * @uses Crm_RelationshipType::setDescription()
     * @uses Crm_RelationshipType::setIsActive()
     * @uses Crm_RelationshipType::setIsClientGroup()
     * @uses Crm_RelationshipType::setIsStrongByDefault()
     * @uses Crm_RelationshipType::setIsSystem()
     * @uses Crm_RelationshipType::setKind()
     * @uses Crm_RelationshipType::setMaxAllowed()
     * @uses Crm_RelationshipType::setName()
     * @uses Crm_RelationshipType::setOnlineInstructions()
     * @uses Crm_RelationshipType::setOrganizationUnitId()
     * @uses Crm_RelationshipType::setRoles()
     * @uses Crm_RelationshipType::setShouldTriggerEmailApproval()
     * @uses Crm_RelationshipType::setVisibleBySubordinates()
     * @param bool $allowInGroupOnline
     * @param string $description
     * @param bool $isActive
     * @param bool $isClientGroup
     * @param bool $isStrongByDefault
     * @param bool $isSystem
     * @param string $kind
     * @param int $maxAllowed
     * @param \patest\StructType\GlobalString $name
     * @param \patest\StructType\GlobalString $onlineInstructions
     * @param string $organizationUnitId
     * @param \patest\StructType\RecordSetOfCrm_RelationshipRole $roles
     * @param bool $shouldTriggerEmailApproval
     * @param bool $visibleBySubordinates
     */
    public function __construct($allowInGroupOnline = null, $description = null, $isActive = null, $isClientGroup = null, $isStrongByDefault = null, $isSystem = null, $kind = null, $maxAllowed = null, \patest\StructType\GlobalString $name = null, \patest\StructType\GlobalString $onlineInstructions = null, $organizationUnitId = null, \patest\StructType\RecordSetOfCrm_RelationshipRole $roles = null, $shouldTriggerEmailApproval = null, $visibleBySubordinates = null)
    {
        $this
            ->setAllowInGroupOnline($allowInGroupOnline)
            ->setDescription($description)
            ->setIsActive($isActive)
            ->setIsClientGroup($isClientGroup)
            ->setIsStrongByDefault($isStrongByDefault)
            ->setIsSystem($isSystem)
            ->setKind($kind)
            ->setMaxAllowed($maxAllowed)
            ->setName($name)
            ->setOnlineInstructions($onlineInstructions)
            ->setOrganizationUnitId($organizationUnitId)
            ->setRoles($roles)
            ->setShouldTriggerEmailApproval($shouldTriggerEmailApproval)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AllowInGroupOnline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowInGroupOnline()
    {
        return isset($this->AllowInGroupOnline) ? $this->AllowInGroupOnline : null;
    }
    /**
     * Set AllowInGroupOnline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowInGroupOnline
     * @return \patest\StructType\Crm_RelationshipType
     */
    public function setAllowInGroupOnline($allowInGroupOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowInGroupOnline) && !is_bool($allowInGroupOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowInGroupOnline, true), gettype($allowInGroupOnline)), __LINE__);
        }
        if (is_null($allowInGroupOnline) || (is_array($allowInGroupOnline) && empty($allowInGroupOnline))) {
            unset($this->AllowInGroupOnline);
        } else {
            $this->AllowInGroupOnline = $allowInGroupOnline;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Crm_RelationshipType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Crm_RelationshipType
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsClientGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsClientGroup()
    {
        return isset($this->IsClientGroup) ? $this->IsClientGroup : null;
    }
    /**
     * Set IsClientGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isClientGroup
     * @return \patest\StructType\Crm_RelationshipType
     */
    public function setIsClientGroup($isClientGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClientGroup) && !is_bool($isClientGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClientGroup, true), gettype($isClientGroup)), __LINE__);
        }
        if (is_null($isClientGroup) || (is_array($isClientGroup) && empty($isClientGroup))) {
            unset($this->IsClientGroup);
        } else {
            $this->IsClientGroup = $isClientGroup;
        }
        return $this;
    }
    /**
     * Get IsStrongByDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsStrongByDefault()
    {
        return isset($this->IsStrongByDefault) ? $this->IsStrongByDefault : null;
    }
    /**
     * Set IsStrongByDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isStrongByDefault
     * @return \patest\StructType\Crm_RelationshipType
     */
    public function setIsStrongByDefault($isStrongByDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStrongByDefault) && !is_bool($isStrongByDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStrongByDefault, true), gettype($isStrongByDefault)), __LINE__);
        }
        if (is_null($isStrongByDefault) || (is_array($isStrongByDefault) && empty($isStrongByDefault))) {
            unset($this->IsStrongByDefault);
        } else {
            $this->IsStrongByDefault = $isStrongByDefault;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Crm_RelationshipType
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get Kind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKind()
    {
        return isset($this->Kind) ? $this->Kind : null;
    }
    /**
     * Set Kind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RelationshipTypeKind::valueIsValid()
     * @uses \patest\EnumType\RelationshipTypeKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kind
     * @return \patest\StructType\Crm_RelationshipType
     */
    public function setKind($kind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RelationshipTypeKind::valueIsValid($kind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RelationshipTypeKind', is_array($kind) ? implode(', ', $kind) : var_export($kind, true), implode(', ', \patest\EnumType\RelationshipTypeKind::getValidValues())), __LINE__);
        }
        if (is_null($kind) || (is_array($kind) && empty($kind))) {
            unset($this->Kind);
        } else {
            $this->Kind = $kind;
        }
        return $this;
    }
    /**
     * Get MaxAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxAllowed()
    {
        return isset($this->MaxAllowed) ? $this->MaxAllowed : null;
    }
    /**
     * Set MaxAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxAllowed
     * @return \patest\StructType\Crm_RelationshipType
     */
    public function setMaxAllowed($maxAllowed = null)
    {
        // validation for constraint: int
        if (!is_null($maxAllowed) && !(is_int($maxAllowed) || ctype_digit($maxAllowed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAllowed, true), gettype($maxAllowed)), __LINE__);
        }
        if (is_null($maxAllowed) || (is_array($maxAllowed) && empty($maxAllowed))) {
            unset($this->MaxAllowed);
        } else {
            $this->MaxAllowed = $maxAllowed;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Crm_RelationshipType
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OnlineInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getOnlineInstructions()
    {
        return isset($this->OnlineInstructions) ? $this->OnlineInstructions : null;
    }
    /**
     * Set OnlineInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $onlineInstructions
     * @return \patest\StructType\Crm_RelationshipType
     */
    public function setOnlineInstructions(\patest\StructType\GlobalString $onlineInstructions = null)
    {
        if (is_null($onlineInstructions) || (is_array($onlineInstructions) && empty($onlineInstructions))) {
            unset($this->OnlineInstructions);
        } else {
            $this->OnlineInstructions = $onlineInstructions;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Crm_RelationshipType
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Roles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_RelationshipRole|null
     */
    public function getRoles()
    {
        return isset($this->Roles) ? $this->Roles : null;
    }
    /**
     * Set Roles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_RelationshipRole $roles
     * @return \patest\StructType\Crm_RelationshipType
     */
    public function setRoles(\patest\StructType\RecordSetOfCrm_RelationshipRole $roles = null)
    {
        if (is_null($roles) || (is_array($roles) && empty($roles))) {
            unset($this->Roles);
        } else {
            $this->Roles = $roles;
        }
        return $this;
    }
    /**
     * Get ShouldTriggerEmailApproval value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldTriggerEmailApproval()
    {
        return isset($this->ShouldTriggerEmailApproval) ? $this->ShouldTriggerEmailApproval : null;
    }
    /**
     * Set ShouldTriggerEmailApproval value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldTriggerEmailApproval
     * @return \patest\StructType\Crm_RelationshipType
     */
    public function setShouldTriggerEmailApproval($shouldTriggerEmailApproval = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldTriggerEmailApproval) && !is_bool($shouldTriggerEmailApproval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldTriggerEmailApproval, true), gettype($shouldTriggerEmailApproval)), __LINE__);
        }
        if (is_null($shouldTriggerEmailApproval) || (is_array($shouldTriggerEmailApproval) && empty($shouldTriggerEmailApproval))) {
            unset($this->ShouldTriggerEmailApproval);
        } else {
            $this->ShouldTriggerEmailApproval = $shouldTriggerEmailApproval;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Crm_RelationshipType
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
